/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.core.output2.ExtPlainView;
import org.netbeans.core.output2.WrappedTextView;
import org.openide.util.Exceptions;

final class OutputEditorKit
extends DefaultEditorKit
implements ViewFactory,
ChangeListener {
    private final boolean wrapped;
    private final JTextComponent comp;
    private static final Action[] actions = OutputEditorKit.prepareActions();
    private final PropertyChangeListener propertyChangeListener;
    private WrappedTextView lastWrappedView = null;
    private int lastMark = -1;
    private int lastDot = -1;
    private static final Rectangle scratch = new Rectangle();

    OutputEditorKit(boolean bl, JTextComponent jTextComponent, PropertyChangeListener propertyChangeListener) {
        this.comp = jTextComponent;
        this.wrapped = bl;
        this.propertyChangeListener = propertyChangeListener;
    }

    @Override
    public Action[] getActions() {
        return actions;
    }

    public WrappedTextView view() {
        return this.lastWrappedView;
    }

    @Override
    public View create(Element element) {
        View view = this.wrapped ? new WrappedTextView(element, this.comp, this.propertyChangeListener) : new ExtPlainView(element);
        this.lastWrappedView = this.wrapped ? view : null;
        return view;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    @Override
    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        if (this.wrapped) {
            jEditorPane.getCaret().addChangeListener(this);
        }
    }

    @Override
    public void deinstall(JEditorPane jEditorPane) {
        super.deinstall(jEditorPane);
        if (this.wrapped) {
            jEditorPane.getCaret().removeChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        boolean bl;
        int n;
        int n2 = this.comp.getSelectionStart();
        boolean bl2 = n2 != (n = this.comp.getSelectionEnd());
        boolean bl3 = bl = this.lastMark != this.lastDot;
        if (this.lastMark != n2 || this.lastDot != n) {
            int n3 = Math.min(n2, n);
            int n4 = Math.max(n2, n);
            int n5 = Math.min(this.lastMark, this.lastDot);
            int n6 = Math.max(this.lastMark, this.lastDot);
            if (bl && bl2) {
                if (n3 != n5) {
                    int n7 = Math.min(n3, n5);
                    int n8 = Math.max(n3, n5);
                    this.repaintRange(n7, n8);
                } else {
                    int n9 = Math.min(n4, n6);
                    int n10 = Math.max(n4, n6);
                    this.repaintRange(n9, n10);
                }
            } else if (bl && !bl2) {
                this.repaintRange(n5, n6);
            }
        }
        this.lastMark = n2;
        this.lastDot = n;
    }

    private void repaintRange(int n, int n2) {
        try {
            Rectangle rectangle = (Rectangle)this.view().modelToView(n2, scratch, Position.Bias.Forward);
            int n3 = rectangle.y + rectangle.height;
            rectangle = (Rectangle)this.view().modelToView(n, scratch, Position.Bias.Forward);
            rectangle.x = 0;
            rectangle.width = this.comp.getWidth();
            rectangle.height = n3 - rectangle.y;
            this.comp.repaint(rectangle);
        }
        catch (BadLocationException badLocationException) {
            this.comp.repaint();
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    static Action[] prepareActions() {
        DefaultEditorKit defaultEditorKit = new DefaultEditorKit();
        Action[] actionArray = defaultEditorKit.getActions();
        Action[] actionArray2 = new Action[actionArray.length];
        for (int i = 0; i < actionArray.length; ++i) {
            Object object = actionArray[i].getValue("Name");
            actionArray2[i] = object.equals("caret-begin-line") ? new OutputBeginLineAction("caret-begin-line", false) : (object.equals("selection-begin-line") ? new OutputBeginLineAction("selection-begin-line", true) : (object.equals("caret-end-line") ? new OutputEndLineAction("caret-end-line", false) : (object.equals("selection-end-line") ? new OutputEndLineAction("selection-end-line", true) : actionArray[i])));
        }
        return actionArray2;
    }

    static class OutputEndLineAction
    extends TextAction {
        private boolean select;

        OutputEndLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                Element element = document.getDefaultRootElement();
                int n = jTextComponent.getCaretPosition();
                int n2 = element.getElementIndex(n);
                int n3 = element.getElement(n2).getEndOffset() - 1;
                if (this.select) {
                    jTextComponent.moveCaretPosition(n3);
                } else {
                    jTextComponent.setCaretPosition(n3);
                }
            }
        }
    }

    static class OutputBeginLineAction
    extends TextAction {
        private boolean select;

        OutputBeginLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                Element element = document.getDefaultRootElement();
                int n = jTextComponent.getCaretPosition();
                int n2 = element.getElementIndex(n);
                int n3 = element.getElement(n2).getStartOffset();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n3);
                } else {
                    jTextComponent.setCaretPosition(n3);
                }
            }
        }
    }
}

