/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.cli;

import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.cli.CLIArgumentsList;
import org.netbeans.installer.utils.exceptions.CLIOptionException;

public abstract class CLIOption {
    protected static final String PARSING_ARGUMENT_STRING = "parsing command line parameter \"{0}\"";
    protected static final String UNARY_ARG_VALUE = Boolean.toString(true);

    public void init() {
        LogManager.logIndent(StringUtils.format(PARSING_ARGUMENT_STRING, this.getName()));
    }

    public boolean canExecute(String arg) {
        return this.getName().equalsIgnoreCase(arg);
    }

    public void finish() {
        LogManager.unindent();
    }

    public void validateOptions(CLIArgumentsList arguments) throws CLIOptionException {
        this.validateArgumentsNumber(arguments);
    }

    private void validateArgumentsNumber(CLIArgumentsList arguments) throws CLIOptionException {
        int number = this.getNumberOfArguments();
        if (number != 0 && number + arguments.getIndex() >= arguments.length()) {
            throw new CLIOptionException(this.getLackOfArgumentsMessage());
        }
    }

    protected String getLackOfArgumentsMessage() {
        return null;
    }

    protected abstract int getNumberOfArguments();

    public abstract String getName();

    public abstract void execute(CLIArgumentsList var1) throws CLIOptionException;
}

