/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.html.boot.impl.FindResources;
import org.netbeans.html.boot.impl.JsClassLoader;
import org.netbeans.html.boot.spi.Fn;

public final class FnContext
implements Closeable {
    private static final FnContext DUMMY = new FnContext(null, null);
    private static final ThreadLocal<FnContext> CURRENT = new ThreadLocal();
    private final Fn.Presenter presenter;
    private final FnContext prev;
    private boolean closed;
    private LinkedList<Runnable> pending;

    private FnContext(FnContext prevCtx, Fn.Presenter newP) {
        this.presenter = newP;
        this.prev = prevCtx;
    }

    public static Closeable activate(Fn.Presenter newP) {
        FnContext ctx = CURRENT.get();
        if (ctx != null && ctx.presenter == newP) {
            return DUMMY;
        }
        ctx = new FnContext(ctx, newP);
        CURRENT.set(ctx);
        return ctx;
    }

    public static Fn.Presenter currentPresenter(boolean ignore) {
        FnContext ctx = CURRENT.get();
        return ctx == null ? null : ctx.presenter;
    }

    @Override
    public void close() throws IOException {
        if (DUMMY == this) {
            return;
        }
        if (this.closed) {
            return;
        }
        try {
            this.closed = true;
            while (true) {
                Runnable p;
                Runnable runnable = p = this.pending == null ? null : this.pending.pollFirst();
                if (p == null) break;
                p.run();
            }
            Fn.Presenter presenter = this.presenter;
            if (presenter instanceof Flushable) {
                Flushable flushable = (Flushable)((Object)presenter);
                flushable.flush();
            }
        }
        finally {
            assert (CURRENT.get() == this);
            CURRENT.set(this.prev);
        }
    }

    public static void registerMicrotask(Runnable promise) {
        FnContext ctx = CURRENT.get();
        if (ctx.pending == null) {
            ctx.pending = new LinkedList();
        }
        ctx.pending.add(promise);
    }

    public static URL isJavaScriptCapable(ClassLoader l) {
        if (l instanceof JsClassLoader) {
            return null;
        }
        return l.getResource("META-INF/net.java.html.js.classes");
    }

    public static ClassLoader newLoader(URL res, FindResources impl, Fn.Presenter p, ClassLoader parent) {
        Throwable t;
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        try {
            Method newLoader = Class.forName("org.netbeans.html.boot.impl.FnUtils").getMethod("newLoader", FindResources.class, Fn.Presenter.class, ClassLoader.class);
            return (ClassLoader)newLoader.invoke(null, impl, p, parent);
        }
        catch (LinkageError ex) {
            t = ex;
        }
        catch (Exception ex) {
            t = ex;
        }
        pw.println("When using @JavaScriptBody methods, one needs to either:");
        pw.println(" - include asm-5.0.jar on runtime classpath");
        pw.println(" - post process classes, see http://bits.netbeans.org/html+java/dev/net/java/html/js/package-summary.html#post-process");
        pw.append("However following classes has not been processed from ").println(res);
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(res.openStream()));
            while ((line = r.readLine()) != null) {
                pw.append("  ").println(line);
            }
            r.close();
        }
        catch (IOException io) {
            pw.append("Cannot read ").println(res);
            io.printStackTrace(pw);
        }
        pw.println("Cannot initialize asm-5.0.jar!");
        pw.flush();
        Logger.getLogger(FnContext.class.getName()).log(Level.SEVERE, w.toString(), t);
        return null;
    }
}

