/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.utils;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Optional;
import java.util.function.Supplier;
import org.javamodularity.moduleplugin.shadow.javaparser.JavaParser;
import org.javamodularity.moduleplugin.shadow.javaparser.ParseProblemException;
import org.javamodularity.moduleplugin.shadow.javaparser.ParseResult;
import org.javamodularity.moduleplugin.shadow.javaparser.ParserConfiguration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Log;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.ProjectRoot;

public interface CollectionStrategy {
    public ParserConfiguration getParserConfiguration();

    public ProjectRoot collect(Path var1);

    default public Optional<Path> getRoot(Path file) {
        try {
            JavaParser javaParser = new JavaParser(this.getParserConfiguration());
            ParseResult<CompilationUnit> parseResult = javaParser.parse(file);
            if (parseResult.isSuccessful()) {
                if (parseResult.getResult().isPresent()) {
                    Optional storage = parseResult.getResult().flatMap(CompilationUnit::getStorage);
                    if (storage.isPresent()) {
                        if (((CompilationUnit.Storage)storage.get()).getFileName().equals("module-info.java")) {
                            return Optional.empty();
                        }
                        return storage.map(CompilationUnit.Storage::getSourceRoot);
                    }
                    Log.info("Storage information not present -- an issue with providing a string rather than file reference?", new Supplier[0]);
                }
                Log.info("Parse result not present", new Supplier[0]);
            }
            Log.info("Parsing was not successful.", new Supplier[0]);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = (Supplier<Object> & Serializable)() -> parseResult.getProblems().size();
            supplierArray[1] = parseResult::getProblems;
            Log.info("There were (%d) problems parsing file: %s", supplierArray);
        }
        catch (ParseProblemException e) {
            Log.info("Problem parsing file %s : %s", (Supplier<Object> & Serializable)() -> file, (Supplier<Object> & Serializable)() -> e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            Log.info("Could not parse file %s : %s", (Supplier<Object> & Serializable)() -> file, (Supplier<Object> & Serializable)() -> e.getLocalizedMessage());
        }
        catch (IOException e) {
            Log.info("Could not read file %s : %s", (Supplier<Object> & Serializable)() -> file, (Supplier<Object> & Serializable)() -> e.getLocalizedMessage());
        }
        return Optional.empty();
    }

    default public PathMatcher getPathMatcher(String pattern) {
        return FileSystems.getDefault().getPathMatcher(pattern);
    }
}

