/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import java.util.Objects;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import one.jpro.jproutils.treeshowing.TreeShowing;

public class FocusUtil {
    private FocusUtil() {
    }

    public static void requestFocus(Node node) {
        TreeShowing.treeShowing((Node)node).addListener(it -> {
            if (TreeShowing.isTreeShowing((Node)node)) {
                Platform.runLater(() -> ((Node)node).requestFocus());
            }
        });
        if (TreeShowing.isTreeShowing((Node)node)) {
            Platform.runLater(() -> ((Node)node).requestFocus());
        }
    }

    public static void delegateFocus(Node receiver, Node delegate) {
        Objects.requireNonNull(receiver, "receiving node can not be null");
        Objects.requireNonNull(receiver, "delegate node can not be null");
        receiver.focusedProperty().addListener(it -> {
            if (receiver.isFocused() && TreeShowing.isTreeShowing((Node)delegate)) {
                Platform.runLater(() -> ((Node)delegate).requestFocus());
            }
        });
    }

    public static Node findFirstFocusableNode(Node node) {
        if (node.isFocusTraversable()) {
            return node;
        }
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node tempNode : parent.getChildrenUnmodifiable()) {
                Node firstFocusableNode;
                if (tempNode.isFocusTraversable()) {
                    return tempNode;
                }
                if (!(tempNode instanceof Parent) || (firstFocusableNode = FocusUtil.findFirstFocusableNode(tempNode)) == null) continue;
                return firstFocusableNode;
            }
        }
        return null;
    }

    public static void focusOnFirstFocusableNode(Node node) {
        Node firstFocusableNode = FocusUtil.findFirstFocusableNode(node);
        if (firstFocusableNode != null) {
            Platform.runLater(() -> ((Node)firstFocusableNode).requestFocus());
        }
    }
}

