/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CustomComboBox;
import com.dlsc.gemsfx.YearMonthPicker;
import com.dlsc.gemsfx.YearMonthView;
import com.dlsc.gemsfx.skins.ToggleVisibilityComboBoxSkin;
import java.util.Objects;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.kordamp.ikonli.javafx.FontIcon;

public class YearMonthPickerSkin
extends ToggleVisibilityComboBoxSkin<YearMonthPicker> {
    private final HBox box;
    private final TextField editor;
    private final StackPane editButton;
    private YearMonthView view;

    public YearMonthPickerSkin(YearMonthPicker picker) {
        super(picker);
        this.editor = picker.getEditor();
        HBox.setHgrow((Node)this.editor, (Priority)Priority.ALWAYS);
        FontIcon calendarIcon = new FontIcon();
        calendarIcon.getStyleClass().add((Object)"edit-icon");
        this.editButton = new StackPane(new Node[]{calendarIcon});
        this.editButton.setFocusTraversable(false);
        this.editButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.editButton.getStyleClass().add((Object)"edit-button");
        this.editButton.addEventFilter(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        this.editButton.addEventFilter(MouseEvent.MOUSE_ENTERED, this::mouseEntered);
        this.editButton.addEventFilter(MouseEvent.MOUSE_EXITED, this::mouseExited);
        this.editButton.setMaxWidth(Double.MAX_VALUE);
        this.box = new HBox();
        this.box.getStyleClass().add((Object)"box");
        this.updateBox();
        this.getChildren().add((Object)this.box);
        this.registerChangeListener((ObservableValue)picker.buttonDisplayProperty(), it -> this.updateBox());
    }

    private void updateBox() {
        CustomComboBox.ButtonDisplay buttonDisplay = ((YearMonthPicker)this.getSkinnable()).getButtonDisplay();
        switch (buttonDisplay) {
            case LEFT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editButton, this.editor});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
                break;
            }
            case RIGHT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editor, this.editButton});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
                break;
            }
            case BUTTON_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editButton});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.ALWAYS);
                break;
            }
            case FIELD_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editor});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
            }
        }
    }

    @Override
    protected Node getPopupContent() {
        if (this.view == null) {
            this.view = ((YearMonthPicker)this.getSkinnable()).getYearMonthView();
            this.view.valueProperty().bindBidirectional((Property)((YearMonthPicker)this.getSkinnable()).valueProperty());
            this.view.valueProperty().addListener((obs, oldValue, newValue) -> {
                if (!Objects.equals(oldValue, newValue)) {
                    ((YearMonthPicker)this.getSkinnable()).hide();
                }
            });
        }
        return this.view;
    }
}

