/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.skins.CustomComboBoxSkinBase;
import javafx.event.Event;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public abstract class ToggleVisibilityComboBoxSkin<T extends ComboBoxBase>
extends CustomComboBoxSkinBase<T> {
    private boolean showPopupOnMouseRelease = true;
    private boolean mouseInsideTargetNode = false;

    public ToggleVisibilityComboBoxSkin(T control) {
        super(control);
        control.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.showPopupOnMouseRelease = true;
                this.hide();
            }
        });
    }

    @Override
    protected void popupOnAutoHide(Event event) {
        this.showPopupOnMouseRelease = !this.mouseInsideTargetNode || !this.showPopupOnMouseRelease;
    }

    protected void mouseReleased(MouseEvent mouseEvent) {
        if (this.showPopupOnMouseRelease) {
            this.show();
        } else {
            this.showPopupOnMouseRelease = true;
            this.hide();
        }
    }

    protected void mouseEntered(MouseEvent mouseEvent) {
        this.mouseInsideTargetNode = true;
    }

    protected void mouseExited(MouseEvent mouseEvent) {
        this.mouseInsideTargetNode = false;
    }
}

