/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.TimePicker;
import java.time.LocalTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;

public class TimePickerPopup
extends HBox {
    private final ListView<Integer> hourListView = new ListView();
    private final ListView<Integer> minuteListView = new ListView();
    private final ListView<Integer> secondListView = new ListView();
    private final ListView<Integer> millisecondListView = new ListView();
    private final TimePicker timePicker;

    public TimePickerPopup(TimePicker timePicker) {
        this.timePicker = timePicker;
        this.getStyleClass().add((Object)"time-picker-popup");
        this.hourListView.getStyleClass().addAll((Object[])new String[]{"time-list-view", "hour-list"});
        this.hourListView.setCellFactory(listView -> new HourCell());
        this.hourListView.getSelectionModel().selectedItemProperty().addListener(it -> {
            Integer newHour = (Integer)this.hourListView.getSelectionModel().getSelectedItem();
            if (newHour != null) {
                LocalTime time = timePicker.getTime();
                if (time != null) {
                    timePicker.setTime(LocalTime.of(newHour, time.getMinute(), time.getSecond(), time.getNano()));
                } else {
                    timePicker.setTime(LocalTime.of(newHour, 0, 0, 0));
                }
            }
        });
        this.minuteListView.getStyleClass().addAll((Object[])new String[]{"time-list-view", "minute-list"});
        this.minuteListView.setCellFactory(listView -> new MinuteCell());
        this.minuteListView.getSelectionModel().selectedItemProperty().addListener(it -> {
            Integer newMinute = (Integer)this.minuteListView.getSelectionModel().getSelectedItem();
            if (newMinute != null) {
                LocalTime time = timePicker.getTime();
                if (time != null) {
                    timePicker.setTime(LocalTime.of(time.getHour(), newMinute, time.getSecond(), time.getNano()));
                } else {
                    timePicker.setTime(LocalTime.of(0, newMinute, 0, 0));
                }
            }
        });
        this.secondListView.setVisible(false);
        this.secondListView.setManaged(false);
        this.secondListView.getStyleClass().addAll((Object[])new String[]{"time-list-view", "second-list"});
        this.secondListView.setCellFactory(listView -> new SecondCell());
        this.secondListView.getSelectionModel().selectedItemProperty().addListener(it -> {
            Integer newSecond = (Integer)this.secondListView.getSelectionModel().getSelectedItem();
            if (newSecond != null) {
                LocalTime time = timePicker.getTime();
                if (time != null) {
                    timePicker.setTime(LocalTime.of(time.getHour(), time.getMinute(), newSecond, time.getNano()));
                } else {
                    timePicker.setTime(LocalTime.of(0, 0, newSecond, 0));
                }
            }
        });
        this.millisecondListView.setVisible(false);
        this.millisecondListView.setManaged(false);
        this.millisecondListView.getStyleClass().addAll((Object[])new String[]{"time-list-view", "millisecond-list"});
        this.millisecondListView.setCellFactory(listView -> new MillisecondCell());
        this.millisecondListView.getSelectionModel().selectedItemProperty().addListener(it -> {
            Integer newMillisecond = (Integer)this.millisecondListView.getSelectionModel().getSelectedItem();
            if (newMillisecond != null) {
                LocalTime time = timePicker.getTime();
                if (time != null) {
                    timePicker.setTime(LocalTime.of(time.getHour(), time.getMinute(), time.getSecond(), this.millisecondToNano(newMillisecond)));
                } else {
                    timePicker.setTime(LocalTime.of(0, 0, 0, this.millisecondToNano(newMillisecond)));
                }
            }
        });
        timePicker.timeProperty().addListener(it -> this.updateListViewSelection());
        this.getChildren().addAll((Object[])new Node[]{this.hourListView, this.minuteListView, this.secondListView, this.millisecondListView});
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        InvalidationListener updateListener = it -> this.updateLists();
        timePicker.clockTypeProperty().addListener(updateListener);
        timePicker.stepRateInMinutesProperty().addListener(updateListener);
        timePicker.earliestTimeProperty().addListener(updateListener);
        timePicker.latestTimeProperty().addListener(updateListener);
        this.updateLists();
        timePicker.showingProperty().addListener(it -> this.initializePopupView());
        this.updateTimeUnit();
        timePicker.formatProperty().addListener(it -> this.updateTimeUnit());
        this.initializePopupView();
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(TimePicker.class.getResource("time-picker.css")).toExternalForm();
    }

    private void initializePopupView() {
        Platform.runLater(() -> {
            this.updateListViewSelection();
            this.hourListView.scrollTo(this.hourListView.getSelectionModel().getSelectedIndex());
            this.minuteListView.scrollTo(this.minuteListView.getSelectionModel().getSelectedIndex());
            this.secondListView.scrollTo(this.secondListView.getSelectionModel().getSelectedIndex());
            this.millisecondListView.scrollTo(this.millisecondListView.getSelectionModel().getSelectedIndex());
        });
    }

    private void updateTimeUnit() {
        TimePicker.Format format = (TimePicker.Format)((Object)this.timePicker.formatProperty().get());
        if (format == TimePicker.Format.HOURS_MINUTES) {
            this.updateSecondMillisecondView(false, false);
        } else if (format == TimePicker.Format.HOURS_MINUTES_SECONDS) {
            this.updateSecondMillisecondView(true, false);
        } else {
            this.updateSecondMillisecondView(true, true);
        }
    }

    private void updateSecondMillisecondView(boolean secondVisible, boolean millisecondVisible) {
        this.secondListView.setManaged(secondVisible);
        this.secondListView.setVisible(secondVisible);
        this.millisecondListView.setManaged(millisecondVisible);
        this.millisecondListView.setVisible(millisecondVisible);
    }

    private int nanoToMillisecond(int nano) {
        return Long.valueOf(TimeUnit.NANOSECONDS.toMillis(nano)).intValue();
    }

    private int millisecondToNano(int millisecond) {
        return Long.valueOf(TimeUnit.MILLISECONDS.toNanos(millisecond)).intValue();
    }

    private void updateListViewSelection() {
        LocalTime time = this.timePicker.getTime();
        if (time != null) {
            this.hourListView.getSelectionModel().select((Object)time.getHour());
            this.minuteListView.getSelectionModel().select((Object)time.getMinute());
            this.secondListView.getSelectionModel().select((Object)time.getSecond());
            this.millisecondListView.getSelectionModel().select(this.nanoToMillisecond(time.getNano()));
        } else {
            this.hourListView.getSelectionModel().clearSelection();
            this.minuteListView.getSelectionModel().clearSelection();
            this.secondListView.getSelectionModel().clearSelection();
            this.millisecondListView.getSelectionModel().clearSelection();
        }
    }

    private void updateLists() {
        this.hourListView.getItems().clear();
        this.minuteListView.getItems().clear();
        this.secondListView.getItems().clear();
        this.millisecondListView.getItems().clear();
        for (int hour = this.timePicker.getEarliestTime().getHour(); hour <= this.timePicker.getLatestTime().getHour(); ++hour) {
            this.hourListView.getItems().add((Object)hour);
        }
        for (int minute = 0; minute < 60; minute += this.timePicker.getStepRateInMinutes()) {
            this.minuteListView.getItems().add((Object)minute);
        }
        for (int second = 0; second < 60; ++second) {
            this.secondListView.getItems().add((Object)second);
        }
        for (int milli = 0; milli < 1000; ++milli) {
            this.millisecondListView.getItems().add((Object)milli);
        }
    }

    private boolean shouldDisable(Integer hour, Integer minute, Integer second, Integer millisecond) {
        if (hour != null && minute != null && second != null && millisecond != null) {
            LocalTime time = LocalTime.of(hour, minute, second, this.millisecondToNano(millisecond));
            time = time.plusSeconds(second.intValue());
            return (time = time.plusNanos(this.millisecondToNano(millisecond))).isAfter(this.timePicker.getLatestTime()) || time.isBefore(this.timePicker.getEarliestTime());
        }
        return false;
    }

    private class MillisecondCell
    extends TimeCell {
        public MillisecondCell() {
            this.getStyleClass().add((Object)"millisecond-cell");
            this.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                Integer hour = (Integer)TimePickerPopup.this.hourListView.getSelectionModel().getSelectedItem();
                Integer minute = (Integer)TimePickerPopup.this.minuteListView.getSelectionModel().getSelectedItem();
                Integer second = (Integer)TimePickerPopup.this.secondListView.getSelectionModel().getSelectedItem();
                Integer millisecond = (Integer)this.getItem();
                return TimePickerPopup.this.shouldDisable(hour, minute, second, millisecond);
            }, (Observable[])new Observable[]{TimePickerPopup.this.hourListView.getSelectionModel().selectedItemProperty(), TimePickerPopup.this.timePicker.earliestTimeProperty(), TimePickerPopup.this.timePicker.latestTimeProperty(), this.itemProperty()}));
        }

        protected void updateItem(Integer item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                if (item < 10) {
                    this.setText("00" + item);
                }
                if (item < 100) {
                    this.setText("0" + item);
                } else {
                    this.setText(Integer.toString(item));
                }
            } else {
                this.setText("");
            }
        }
    }

    private class SecondCell
    extends TimeCell {
        public SecondCell() {
            this.getStyleClass().add((Object)"second-cell");
            this.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                Integer hour = (Integer)TimePickerPopup.this.hourListView.getSelectionModel().getSelectedItem();
                Integer minute = (Integer)TimePickerPopup.this.minuteListView.getSelectionModel().getSelectedItem();
                Integer second = (Integer)this.getItem();
                Integer millisecond = (Integer)TimePickerPopup.this.millisecondListView.getSelectionModel().getSelectedItem();
                return TimePickerPopup.this.shouldDisable(hour, minute, second, millisecond);
            }, (Observable[])new Observable[]{TimePickerPopup.this.hourListView.getSelectionModel().selectedItemProperty(), TimePickerPopup.this.timePicker.earliestTimeProperty(), TimePickerPopup.this.timePicker.latestTimeProperty(), this.itemProperty()}));
        }

        protected void updateItem(Integer item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                if (item < 10) {
                    this.setText("0" + item);
                } else {
                    this.setText(Integer.toString(item));
                }
            } else {
                this.setText("");
            }
        }
    }

    private class MinuteCell
    extends TimeCell {
        public MinuteCell() {
            this.getStyleClass().add((Object)"minute-cell");
            this.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                Integer hour = (Integer)TimePickerPopup.this.hourListView.getSelectionModel().getSelectedItem();
                Integer minute = (Integer)this.getItem();
                Integer second = (Integer)TimePickerPopup.this.secondListView.getSelectionModel().getSelectedItem();
                Integer millisecond = (Integer)TimePickerPopup.this.millisecondListView.getSelectionModel().getSelectedItem();
                return TimePickerPopup.this.shouldDisable(hour, minute, second, millisecond);
            }, (Observable[])new Observable[]{TimePickerPopup.this.hourListView.getSelectionModel().selectedItemProperty(), TimePickerPopup.this.timePicker.earliestTimeProperty(), TimePickerPopup.this.timePicker.latestTimeProperty(), this.itemProperty()}));
        }

        protected void updateItem(Integer item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                if (item < 10) {
                    this.setText("0" + item);
                } else {
                    this.setText(Integer.toString(item));
                }
            } else {
                this.setText("");
            }
        }
    }

    private static class HourCell
    extends TimeCell {
        public HourCell() {
            this.getStyleClass().add((Object)"hour-cell");
        }

        protected void updateItem(Integer item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                this.setText(Integer.toString(item));
            } else {
                this.setText("");
            }
        }
    }

    public static abstract class TimeCell
    extends ListCell<Integer> {
        public TimeCell() {
            this.getStyleClass().add((Object)"time-cell");
            Label label = new Label();
            label.getStyleClass().add((Object)"time-label");
            label.visibleProperty().bind((ObservableValue)this.emptyProperty().not());
            label.textProperty().bind((ObservableValue)this.textProperty());
            this.setGraphic((Node)label);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }
}

