/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CircleProgressIndicator;
import com.dlsc.gemsfx.skins.ArcProgressIndicatorSkin;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.util.Duration;

public class CircleProgressIndicatorSkin
extends ArcProgressIndicatorSkin<CircleProgressIndicator> {
    public CircleProgressIndicatorSkin(CircleProgressIndicator control) {
        super(control);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.trackArc.setLength(360.0);
        this.progressArc.startAngleProperty().bind((ObservableValue)((CircleProgressIndicator)this.getSkinnable()).startAngleProperty());
    }

    @Override
    protected double getProgressMaxLength() {
        return -360.0;
    }

    @Override
    protected double computeLabelHeight(double diameter) {
        return diameter;
    }

    @Override
    protected Timeline initIndeterminateAnimation() {
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)0), new KeyValue((WritableValue)this.progressArc.lengthProperty(), (Object)45)}), new KeyFrame(Duration.seconds((double)0.75), new KeyValue[]{new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)180), new KeyValue((WritableValue)this.progressArc.lengthProperty(), (Object)180)}), new KeyFrame(Duration.seconds((double)1.5), new KeyValue[]{new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)360), new KeyValue((WritableValue)this.progressArc.lengthProperty(), (Object)45)})});
        timeline.setCycleCount(-1);
        return timeline;
    }

    @Override
    protected DoubleBinding getRadiusBinding(CircleProgressIndicator control) {
        return Bindings.createDoubleBinding(() -> {
            Insets insets = control.getInsets() != null ? control.getInsets() : Insets.EMPTY;
            double totalHorInset = insets.getLeft() + insets.getRight();
            double totalVerInset = insets.getTop() + insets.getBottom();
            double maxInset = Math.max(totalHorInset, totalVerInset);
            double maxRadius = Math.max(this.trackArc.getStrokeWidth(), this.progressArc.getStrokeWidth());
            return (Math.min(control.getWidth(), control.getHeight()) - maxInset - maxRadius) / 2.0;
        }, (Observable[])new Observable[]{control.widthProperty(), control.heightProperty(), control.insetsProperty(), this.trackArc.strokeWidthProperty(), this.progressArc.strokeWidthProperty()});
    }

    @Override
    protected double computeArcCenterY(double contentY, double contentHeight) {
        return contentY + contentHeight / 2.0;
    }

    @Override
    protected double computeLabelY(double arcCenterY, double labelHeight) {
        return arcCenterY - labelHeight / 2.0;
    }
}

