/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.behavior;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.behavior.Behavior;
import de.undercouch.citeproc.csl.internal.token.TextToken;
import de.undercouch.citeproc.csl.internal.token.Token;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

public class StripPeriods
implements Behavior {
    private final boolean stripPeriods;

    public StripPeriods() {
        this.stripPeriods = false;
    }

    public StripPeriods(Node node) {
        this.stripPeriods = NodeHelper.getAttrValueBool(node, "strip-periods", false);
    }

    @Override
    public void accept(Consumer<RenderContext> renderFunction, RenderContext ctx) {
        if (this.stripPeriods) {
            RenderContext child = new RenderContext(ctx);
            renderFunction.accept(child);
            child.getResult().getTokens().stream().map(this::transform).forEach(ctx::emit);
        } else {
            renderFunction.accept(ctx);
        }
    }

    private Token transform(Token t) {
        if (t instanceof TextToken) {
            TextToken tt = (TextToken)t;
            return tt.copyWithText(StringUtils.remove((String)tt.getText(), (char)'.'));
        }
        return t;
    }
}

