/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.utils.CommonUtils;

public class EditorPartContextualProperty {
    private static final Log log = Log.getLog(EditorPartContextualProperty.class);
    private static final Map<String, EditorPartContextualProperty> knownProps = Collections.synchronizedMap(new HashMap());
    public final String partPropName;
    public final QualifiedName filePropName;
    public final String globalPrefName;
    public final String defaultValue;

    private EditorPartContextualProperty(@NotNull String partPropName, @NotNull QualifiedName filePropName, @NotNull String globalPrefName, @NotNull String defaultValue) {
        this.partPropName = partPropName;
        this.filePropName = filePropName;
        this.globalPrefName = globalPrefName;
        this.defaultValue = defaultValue;
    }

    public static EditorPartContextualProperty setup(@NotNull String partPropName, @NotNull QualifiedName filePropName, @NotNull String globalPrefName, @NotNull String defaultValue) {
        return knownProps.computeIfAbsent(partPropName, partPropName2 -> new EditorPartContextualProperty((String)partPropName2, filePropName, globalPrefName, defaultValue));
    }

    @NotNull
    public PartCustomPropertyValueInfo getPropertyValue(@NotNull EditorPart editor) {
        boolean isInitial;
        String value = editor.getPartProperty(this.partPropName);
        if (value == null) {
            value = this.getPropertyValueInitial(editor);
            isInitial = true;
        } else {
            isInitial = false;
        }
        return new PartCustomPropertyValueInfo(value, isInitial);
    }

    @NotNull
    private String getPropertyValueInitial(@NotNull EditorPart editor) {
        DBPPreferenceStore store;
        IFile activeFile = EditorUtils.getFileFromInput(editor.getEditorInput());
        if (activeFile != null && activeFile.exists()) {
            try {
                String value = activeFile.getPersistentProperty(this.filePropName);
                if (value != null) {
                    return value;
                }
            }
            catch (CoreException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return (store = DBWorkbench.getPlatform().getPreferenceStore()).contains(this.globalPrefName) ? store.getString(this.globalPrefName) : this.defaultValue;
    }

    public boolean setPropertyValue(@NotNull EditorPart editor, @Nullable String value) {
        boolean changed;
        String oldValue = editor.getPartProperty(this.partPropName);
        if (value == null) {
            editor.setPartProperty(this.partPropName, this.defaultValue);
            changed = true;
        } else if (CommonUtils.equalObjects((Object)oldValue, (Object)value)) {
            changed = false;
        } else {
            editor.setPartProperty(this.partPropName, value);
            IFile activeFile = EditorUtils.getFileFromInput(editor.getEditorInput());
            if (activeFile != null) {
                try {
                    activeFile.setPersistentProperty(this.filePropName, value);
                }
                catch (CoreException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            changed = true;
        }
        if (changed) {
            DBWorkbench.getPlatform().getPreferenceStore().firePropertyChangeEvent(this.globalPrefName, (Object)oldValue, (Object)value);
        }
        return changed;
    }

    public static class PartCustomPropertyValueInfo {
        public final String value;
        public final boolean isInitial;

        public PartCustomPropertyValueInfo(@NotNull String value, boolean isInitial) {
            this.value = value;
            this.isInitial = isInitial;
        }
    }
}

