package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VoiceAsyncManualScanResults invokes the green.VoiceAsyncManualScanResults API synchronously
func (client *Client) VoiceAsyncManualScanResults(request *VoiceAsyncManualScanResultsRequest) (response *VoiceAsyncManualScanResultsResponse, err error) {
	response = CreateVoiceAsyncManualScanResultsResponse()
	err = client.DoAction(request, response)
	return
}

// VoiceAsyncManualScanResultsWithChan invokes the green.VoiceAsyncManualScanResults API asynchronously
func (client *Client) VoiceAsyncManualScanResultsWithChan(request *VoiceAsyncManualScanResultsRequest) (<-chan *VoiceAsyncManualScanResultsResponse, <-chan error) {
	responseChan := make(chan *VoiceAsyncManualScanResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VoiceAsyncManualScanResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VoiceAsyncManualScanResultsWithCallback invokes the green.VoiceAsyncManualScanResults API asynchronously
func (client *Client) VoiceAsyncManualScanResultsWithCallback(request *VoiceAsyncManualScanResultsRequest, callback func(response *VoiceAsyncManualScanResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VoiceAsyncManualScanResultsResponse
		var err error
		defer close(result)
		response, err = client.VoiceAsyncManualScanResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VoiceAsyncManualScanResultsRequest is the request struct for api VoiceAsyncManualScanResults
type VoiceAsyncManualScanResultsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VoiceAsyncManualScanResultsResponse is the response struct for api VoiceAsyncManualScanResults
type VoiceAsyncManualScanResultsResponse struct {
	*responses.BaseResponse
}

// CreateVoiceAsyncManualScanResultsRequest creates a request to invoke VoiceAsyncManualScanResults API
func CreateVoiceAsyncManualScanResultsRequest() (request *VoiceAsyncManualScanResultsRequest) {
	request = &VoiceAsyncManualScanResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VoiceAsyncManualScanResults", "/green/voice/manual/scan/results", "", "")
	request.Method = requests.POST
	return
}

// CreateVoiceAsyncManualScanResultsResponse creates a response to parse from VoiceAsyncManualScanResults response
func CreateVoiceAsyncManualScanResultsResponse() (response *VoiceAsyncManualScanResultsResponse) {
	response = &VoiceAsyncManualScanResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
