package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApgroupBatchAddAp invokes the cloudwf.ApgroupBatchAddAp API synchronously
// api document: https://help.aliyun.com/api/cloudwf/apgroupbatchaddap.html
func (client *Client) ApgroupBatchAddAp(request *ApgroupBatchAddApRequest) (response *ApgroupBatchAddApResponse, err error) {
	response = CreateApgroupBatchAddApResponse()
	err = client.DoAction(request, response)
	return
}

// ApgroupBatchAddApWithChan invokes the cloudwf.ApgroupBatchAddAp API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/apgroupbatchaddap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApgroupBatchAddApWithChan(request *ApgroupBatchAddApRequest) (<-chan *ApgroupBatchAddApResponse, <-chan error) {
	responseChan := make(chan *ApgroupBatchAddApResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApgroupBatchAddAp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApgroupBatchAddApWithCallback invokes the cloudwf.ApgroupBatchAddAp API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/apgroupbatchaddap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApgroupBatchAddApWithCallback(request *ApgroupBatchAddApRequest, callback func(response *ApgroupBatchAddApResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApgroupBatchAddApResponse
		var err error
		defer close(result)
		response, err = client.ApgroupBatchAddAp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApgroupBatchAddApRequest is the request struct for api ApgroupBatchAddAp
type ApgroupBatchAddApRequest struct {
	*requests.RpcRequest
	ApAssetIds string           `position:"Query" name:"ApAssetIds"`
	ApgroupId  requests.Integer `position:"Query" name:"ApgroupId"`
}

// ApgroupBatchAddApResponse is the response struct for api ApgroupBatchAddAp
type ApgroupBatchAddApResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateApgroupBatchAddApRequest creates a request to invoke ApgroupBatchAddAp API
func CreateApgroupBatchAddApRequest() (request *ApgroupBatchAddApRequest) {
	request = &ApgroupBatchAddApRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ApgroupBatchAddAp", "cloudwf", "openAPI")
	return
}

// CreateApgroupBatchAddApResponse creates a response to parse from ApgroupBatchAddAp response
func CreateApgroupBatchAddApResponse() (response *ApgroupBatchAddApResponse) {
	response = &ApgroupBatchAddApResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
