/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.watermark;

import com.charliemouse.cambozola.watermark.Watermark;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class WatermarkCollection {
    public static final String NO_URL = null;
    public static final int DEFAULT_INDENT = 5;
    private Vector m_watermarks = new Vector();

    public void populate(String string, URL uRL) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        MediaTracker mediaTracker = new MediaTracker(new Panel());
        int n = 0;
        if (string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "| ");
        try {
            do {
                String string2 = stringTokenizer.nextToken();
                String string3 = "BottomRight";
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                String string4 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
                string3 = string3.toLowerCase();
                int n2 = 1;
                int n3 = 1;
                if (string3.indexOf("top") != -1 || string3.indexOf("north") != -1) {
                    n3 = 0;
                } else if (string3.indexOf("bottom") != -1 || string3.indexOf("south") != -1) {
                    n3 = 2;
                }
                if (string3.indexOf("left") != -1 || string3.indexOf("west") != -1) {
                    n2 = 0;
                } else if (string3.indexOf("right") != -1 || string3.indexOf("east") != -1) {
                    n2 = 2;
                }
                try {
                    URL uRL2 = new URL(uRL, string2);
                    Image image = toolkit.createImage((ImageProducer)uRL2.getContent());
                    mediaTracker.addImage(image, n);
                    try {
                        mediaTracker.waitForID(n);
                        int n4 = mediaTracker.statusID(n, true);
                        if (n4 != 8) {
                            System.err.println("Not all watermarks could be loaded - status=" + n4);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n;
                    this.m_watermarks.addElement(new Watermark(image, n2, n3, 5, 5, string4));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Unable to access watermark URL - '" + string2 + "' : " + malformedURLException);
                }
                catch (IOException iOException) {
                    System.err.println("Unable to access image data for '" + string2 + "' : " + iOException);
                }
            } while (stringTokenizer.hasMoreTokens());
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println("Invalid watermark string '" + string + "'");
        }
    }

    public Watermark isOverClickableWatermark(Point point) {
        Watermark watermark = this.getWatermarkAtPoint(point);
        if (watermark != null && watermark.isClickable()) {
            return watermark;
        }
        return null;
    }

    public Watermark getWatermarkAtPoint(Point point) {
        Enumeration enumeration = this.m_watermarks.elements();
        while (enumeration.hasMoreElements()) {
            Watermark watermark = (Watermark)enumeration.nextElement();
            if (!watermark.hitsPoint(point) || !watermark.isVisible()) continue;
            return watermark;
        }
        return null;
    }

    public void recalculateLocations(Dimension dimension) {
        Enumeration enumeration = this.m_watermarks.elements();
        while (enumeration.hasMoreElements()) {
            Watermark watermark = (Watermark)enumeration.nextElement();
            watermark.recalculateLocation(dimension);
        }
    }

    public void paint(Graphics graphics) {
        Enumeration enumeration = this.m_watermarks.elements();
        while (enumeration.hasMoreElements()) {
            Watermark watermark = (Watermark)enumeration.nextElement();
            watermark.paint(graphics);
        }
    }
}

