/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.processor.config;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.ui.IDataTransferEventProcessorConfigurator;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.utils.CommonUtils;

public class ExecuteCommandEventProcessorConfigurator
implements IDataTransferEventProcessorConfigurator<StreamConsumerSettings> {
    private String command;
    private String workingDirectory;

    public void createControl(@NotNull Composite parent, @NotNull StreamConsumerSettings settings, @NotNull Runnable propertyChangeListener) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(300, -1).create());
        Text commandText = UIUtils.createLabelText((Composite)group, (String)DTUIMessages.data_transfer_event_processor_execute_command_command, (String)this.command);
        commandText.addModifyListener(e -> {
            this.command = commandText.getText();
            propertyChangeListener.run();
        });
        UIUtils.createControlLabel((Composite)group, (String)DTUIMessages.data_transfer_event_processor_execute_command_working_directory);
        TextWithOpenFolder workingDirectoryText = new TextWithOpenFolder(group, DTUIMessages.data_transfer_event_processor_execute_command_working_directory_title);
        workingDirectoryText.setText(this.workingDirectory);
        workingDirectoryText.getTextControl().addModifyListener(e -> {
            this.workingDirectory = workingDirectoryText.getText();
            propertyChangeListener.run();
        });
        workingDirectoryText.setLayoutData((Object)new GridData(768));
    }

    public void loadSettings(@NotNull Map<String, Object> settings) {
        this.command = CommonUtils.toString((Object)settings.get("command"));
        this.workingDirectory = CommonUtils.toString((Object)settings.get("workingDirectory"));
    }

    public void saveSettings(@NotNull Map<String, Object> settings) {
        settings.put("command", this.command);
        if (!CommonUtils.isEmptyTrimmed((String)this.workingDirectory)) {
            settings.put("workingDirectory", this.workingDirectory);
        }
    }

    public void resetSettings(@NotNull Map<String, Object> settings) {
    }

    public boolean isComplete() {
        return !CommonUtils.isEmptyTrimmed((String)this.command);
    }

    @Override
    public boolean isApplicable(@NotNull StreamConsumerSettings configuration) {
        return !configuration.isOutputClipboard();
    }
}

