/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class SQLEditorHandlerToggleOutlineView
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
                IViewReference viewReference = activePage.findViewReference("org.eclipse.ui.views.ContentOutline");
                if (viewReference != null && viewReference.getView(false) != null) {
                    activePage.hideView(viewReference);
                } else {
                    IViewPart outlineView = activePage.showView("org.eclipse.ui.views.ContentOutline");
                    if (outlineView != null) {
                        outlineView.setFocus();
                    }
                }
                SQLEditorHandlerToggleOutlineView.refreshCommandState((IServiceLocator)activeWindow);
            }
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Toggle outline", "Can't open outline view", (Throwable)e);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchPage page = (IWorkbenchPage)element.getServiceLocator().getService(IWorkbenchPage.class);
        IViewReference viewReference = page.findViewReference("org.eclipse.ui.views.ContentOutline");
        boolean isVisible = viewReference != null && viewReference.getView(false) != null;
        element.setChecked(isVisible);
    }

    public static void refreshCommandState(@NotNull IServiceLocator serviceLocator) {
        ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("org.jkiss.dbeaver.ui.editors.sql.show.outline", null);
        }
    }
}

