/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CachedItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadWriteCache
implements CacheConcurrencyStrategy {
    private final Cache cache;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cache$ReadWriteCache == null ? (class$net$sf$hibernate$cache$ReadWriteCache = ReadWriteCache.class$("net.sf.hibernate.cache.ReadWriteCache")) : class$net$sf$hibernate$cache$ReadWriteCache));
    static /* synthetic */ Class class$net$sf$hibernate$cache$ReadWriteCache;

    public ReadWriteCache(Cache cache) {
        this.cache = cache;
    }

    public synchronized Object get(Object key, long txTimestamp) throws CacheException {
        CachedItem item;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cache lookup: " + key));
        }
        if ((item = (CachedItem)this.cache.get(key)) != null && item.getFreshTimestamp() < txTimestamp && item.isFresh()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Cache hit: " + key));
            }
            return item.getValue();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cache miss: " + key));
        }
        return null;
    }

    public synchronized void lock(Object key) throws CacheException {
        CachedItem item;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invalidating: " + key));
        }
        if ((item = (CachedItem)this.cache.get(key)) == null) {
            item = new CachedItem(null);
        }
        item.lock();
        this.cache.put(key, item);
    }

    public synchronized boolean put(Object key, Object value, long txTimestamp) throws CacheException {
        CachedItem item;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caching: " + key));
        }
        if ((item = (CachedItem)this.cache.get(key)) == null || item.isUnlocked() && !item.isFresh() && item.getUnlockTimestamp() < txTimestamp) {
            this.cache.put(key, new CachedItem(value));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Cached: " + key));
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Could not cache: " + key));
        }
        return false;
    }

    public synchronized void release(Object key) throws CacheException {
        CachedItem item;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Releasing: " + key));
        }
        if ((item = (CachedItem)this.cache.get(key)) != null) {
            item.unlock();
            this.cache.put(key, item);
        } else {
            log.warn((Object)"An item was expired by the cache while it was locked");
        }
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy cache", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

