/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class IDDatatypeValidator
extends StringDatatypeValidator {
    private static Object fNullValue = new Object();

    public IDDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
        if (bl) {
            return;
        }
        if (datatypeValidator != null) {
            this.setTokenType(((IDDatatypeValidator)datatypeValidator).fTokenType);
        } else {
            this.setTokenType("ID");
        }
    }

    private boolean addId(String string, Hashtable hashtable) {
        if (hashtable.containsKey(string)) {
            return false;
        }
        try {
            hashtable.put(string, fNullValue);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of Memory: Hashtable of ID's has " + hashtable.size() + " Elements");
            outOfMemoryError.printStackTrace();
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        super.validate(string, object);
        if (object != null && !this.addId(string, (Hashtable)object)) {
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("ID '" + string + "'  has to be unique");
            invalidDatatypeValueException.setMinorCode(76);
            invalidDatatypeValueException.setMajorCode(76);
            throw invalidDatatypeValueException;
        }
        return null;
    }
}

