/*
 * Decompiled with CFR 0.152.
 */
package os.shaded_org_apache_tools_zip;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public class PermissionUtils {
    public static int FILE_TYPE_FLAG = 61440;

    private PermissionUtils() {
    }

    public static int modeFromPermissions(Set<PosixFilePermission> set, FileType fileType) {
        int n;
        switch (fileType) {
            case SYMLINK: {
                n = 10;
                break;
            }
            case REGULAR_FILE: {
                n = 8;
                break;
            }
            case DIR: {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        n <<= 3;
        n <<= 3;
        n = (int)((long)n | PermissionUtils.modeFromPermissions(set, "OWNER"));
        n <<= 3;
        n = (int)((long)n | PermissionUtils.modeFromPermissions(set, "GROUP"));
        n <<= 3;
        n = (int)((long)n | PermissionUtils.modeFromPermissions(set, "OTHERS"));
        return n;
    }

    public static Set<PosixFilePermission> permissionsFromMode(int n) {
        EnumSet<PosixFilePermission> enumSet = EnumSet.noneOf(PosixFilePermission.class);
        PermissionUtils.addPermissions(enumSet, "OTHERS", n);
        PermissionUtils.addPermissions(enumSet, "GROUP", n >> 3);
        PermissionUtils.addPermissions(enumSet, "OWNER", n >> 6);
        return enumSet;
    }

    private static long modeFromPermissions(Set<PosixFilePermission> set, String string2) {
        long l = 0L;
        if (set.contains((Object)PosixFilePermission.valueOf(string2 + "_READ"))) {
            l |= 4L;
        }
        if (set.contains((Object)PosixFilePermission.valueOf(string2 + "_WRITE"))) {
            l |= 2L;
        }
        if (set.contains((Object)PosixFilePermission.valueOf(string2 + "_EXECUTE"))) {
            l |= 1L;
        }
        return l;
    }

    private static void addPermissions(Set<PosixFilePermission> set, String string2, long l) {
        if ((l & 1L) == 1L) {
            set.add(PosixFilePermission.valueOf(string2 + "_EXECUTE"));
        }
        if ((l & 2L) == 2L) {
            set.add(PosixFilePermission.valueOf(string2 + "_WRITE"));
        }
        if ((l & 4L) == 4L) {
            set.add(PosixFilePermission.valueOf(string2 + "_READ"));
        }
    }

    public static enum FileType {
        REGULAR_FILE,
        DIR,
        SYMLINK,
        OTHER;


        public static FileType of(Path path) throws IOException {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (basicFileAttributes.isRegularFile()) {
                return REGULAR_FILE;
            }
            if (basicFileAttributes.isDirectory()) {
                return DIR;
            }
            if (basicFileAttributes.isSymbolicLink()) {
                return SYMLINK;
            }
            return OTHER;
        }
    }
}

