/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;

public class GenericHistoryTableProvider {
    private IFileHistory currentFileHistory;
    private IFile currentFile;
    private String currentRevision;
    private TableViewer viewer;
    private Font currentRevisionFont;
    private static final int COL_REVISIONID = 0;
    private static final int COL_DATE = 1;
    private static final int COL_AUTHOR = 2;
    private static final int COL_COMMENT = 3;

    protected IFileRevision adaptToFileRevision(Object element) {
        IFileRevision entry = null;
        if (element instanceof IFileRevision) {
            entry = (IFileRevision)element;
        } else if (element instanceof IAdaptable) {
            entry = (IFileRevision)((IAdaptable)element).getAdapter(IFileRevision.class);
        }
        return entry;
    }

    public TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(table);
        this.createColumns(table, layout, viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        HistoryComparator sorter = new HistoryComparator(0);
        sorter.setReversed(true);
        viewer.setComparator((ViewerComparator)sorter);
        table.addDisposeListener(e -> {
            if (this.currentRevisionFont != null) {
                this.currentRevisionFont.dispose();
            }
        });
        this.viewer = viewer;
        return viewer;
    }

    private void createColumns(Table table, TableLayout layout, TableViewer viewer) {
        SelectionListener headerListener = this.getColumnListener(viewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Revision);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_RevisionTime);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Author);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Comment);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
                HistoryComparator oldSorter = (HistoryComparator)tableViewer.getComparator();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    tableViewer.refresh();
                } else {
                    tableViewer.setComparator((ViewerComparator)new HistoryComparator(column));
                }
            }
        };
    }

    public void setFile(IFileHistory fileHistory, IFile file) {
        this.currentFileHistory = fileHistory;
        this.currentFile = file;
        this.currentRevision = this.findCurrentRevision();
    }

    private String findCurrentRevision() {
        RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)this.currentFile.getProject());
        IFileRevision fileRevision = teamProvider.getFileHistoryProvider().getWorkspaceFileRevision((IResource)this.currentFile);
        if (fileRevision != null) {
            return fileRevision.getContentIdentifier();
        }
        return null;
    }

    public IFileHistory getIFileHistory() {
        return this.currentFileHistory;
    }

    public String getCurrentRevision() {
        return this.currentRevision;
    }

    class HistoryComparator
    extends ViewerComparator {
        private boolean reversed = false;
        private final int columnNumber;
        private final int[][] SORT_ORDERS_BY_COLUMN;

        public HistoryComparator(int columnNumber) {
            int[][] nArrayArray = new int[5][];
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[4];
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[4];
            nArray3[0] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[4];
            nArray4[0] = 2;
            nArray4[2] = 1;
            nArray4[3] = 3;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[4];
            nArray5[0] = 3;
            nArray5[2] = 1;
            nArray5[3] = 2;
            nArrayArray[4] = nArray5;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            IFileRevision e1 = GenericHistoryTableProvider.this.adaptToFileRevision(o1);
            IFileRevision e2 = GenericHistoryTableProvider.this.adaptToFileRevision(o2);
            int result = 0;
            if (e1 == null || e2 == null) {
                result = super.compare(viewer, o1, o2);
            } else {
                int[] nArray = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int columnSortOrder = nArray[n2];
                    result = this.compareColumnValue(columnSortOrder, e1, e2);
                    if (result != 0) break;
                    ++n2;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, IFileRevision e1, IFileRevision e2) {
            switch (columnNumber) {
                case 0: {
                    return e1.getContentIdentifier().compareTo(e2.getContentIdentifier());
                }
                case 1: {
                    long date1 = e1.getTimestamp();
                    long date2 = e2.getTimestamp();
                    if (date1 == date2) {
                        return 0;
                    }
                    return date1 > date2 ? -1 : 1;
                }
                case 2: {
                    return this.getComparator().compare(e1.getAuthor(), e2.getAuthor());
                }
                case 3: {
                    return this.getComparator().compare(e1.getComment(), e2.getComment());
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }

    class HistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        private DateFormat dateFormat;

        HistoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IFileRevision entry = GenericHistoryTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    String revision = entry.getContentIdentifier();
                    return revision;
                }
                case 1: {
                    long date = entry.getTimestamp();
                    Date dateFromLong = new Date(date);
                    return this.getDateFormat().format(dateFromLong);
                }
                case 2: {
                    return entry.getAuthor();
                }
                case 3: {
                    String comment = entry.getComment();
                    return comment;
                }
            }
            return "";
        }

        private synchronized DateFormat getDateFormat() {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getInstance();
            }
            return this.dateFormat;
        }

        public Color getForeground(Object element) {
            IFileRevision entry = GenericHistoryTableProvider.this.adaptToFileRevision(element);
            if (!entry.exists()) {
                return Display.getCurrent().getSystemColor(18);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            IFileRevision entry = GenericHistoryTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return null;
            }
            String revision = entry.getContentIdentifier();
            String tempCurrentRevision = GenericHistoryTableProvider.this.getCurrentRevision();
            if (tempCurrentRevision != null && tempCurrentRevision.equals(revision)) {
                if (GenericHistoryTableProvider.this.currentRevisionFont == null) {
                    FontData[] data;
                    Font defaultFont = JFaceResources.getDefaultFont();
                    FontData[] fontDataArray = data = defaultFont.getFontData();
                    int n = data.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FontData d = fontDataArray[n2];
                        d.setStyle(1);
                        ++n2;
                    }
                    GenericHistoryTableProvider.this.currentRevisionFont = new Font((Device)GenericHistoryTableProvider.this.viewer.getTable().getDisplay(), data);
                }
                return GenericHistoryTableProvider.this.currentRevisionFont;
            }
            return null;
        }
    }
}

