/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2ViewBase;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableRefreshMode;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2MaterializedQueryTable
extends DB2ViewBase
implements DB2SourceObject {
    private DB2TableRefreshMode refreshMode;
    private Timestamp refreshTime;

    public DB2MaterializedQueryTable(DBRProgressMonitor monitor, DB2Schema schema, ResultSet dbResult) {
        super(monitor, schema, dbResult);
        this.refreshTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"REFRESH_TIME");
        this.refreshMode = (DB2TableRefreshMode)CommonUtils.valueOf(DB2TableRefreshMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REFRESH"));
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((DB2Schema)this.getContainer()).getMaterializedQueryTableCache().clearChildrenCache(this);
        super.refreshObject(monitor);
        return ((DB2Schema)this.getContainer()).getMaterializedQueryTableCache().refreshObject(monitor, (DB2Schema)this.getContainer(), this);
    }

    @Override
    public DB2TableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DB2TableColumn)((DB2Schema)this.getContainer()).getMaterializedQueryTableCache().getChild(monitor, (DB2Schema)this.getContainer(), this, attributeName);
    }

    public List<DB2TableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getMaterializedQueryTableCache().getChildren(monitor, (DB2Schema)this.getContainer(), this);
    }

    public JDBCStructCache<DB2Schema, DB2MaterializedQueryTable, DB2TableColumn> getCache() {
        return ((DB2Schema)this.getContainer()).getMaterializedQueryTableCache();
    }

    @Property(viewable=true, editable=false, order=102)
    public DB2TableRefreshMode getRefreshMode() {
        return this.refreshMode;
    }

    @Property(viewable=true, editable=false, order=103)
    public Timestamp getRefreshTime() {
        return this.refreshTime;
    }
}

