/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.config;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.cubrid.ui.internal.CubridMessages;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.CreateProcedurePage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class CreateCubridProcedurePage
extends CreateProcedurePage {
    private DBSProcedure procedure;
    private String name;
    private DBSProcedureType type;

    public CreateCubridProcedurePage(DBSProcedure procedure) {
        super(procedure);
        this.procedure = procedure;
        this.type = procedure.getProcedureType();
    }

    public DBSProcedureType getProcedureType() {
        DBSProcedureType procedureType = this.getPredefinedProcedureType();
        return procedureType == null ? this.type : procedureType;
    }

    public String getProcedureName() {
        return this.name;
    }

    public boolean isPageComplete() {
        return !CommonUtils.isEmpty((String)this.name);
    }

    public Control createPageContents(Composite parent) {
        Composite propsGroup = new Composite(parent, 0);
        propsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        propsGroup.setLayoutData((Object)gd);
        Text containerText = UIUtils.createLabelText((Composite)propsGroup, (String)CubridMessages.dialog_struct_create_procedure_container, (String)DBUtils.getObjectFullName((DBPNamedObject)this.procedure.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.UI));
        containerText.setEditable(false);
        Text nameText = UIUtils.createLabelText((Composite)propsGroup, (String)CubridMessages.dialog_struct_create_procedure_label_name, null);
        nameText.addModifyListener(e -> {
            this.name = nameText.getText().trim();
            this.updatePageState();
        });
        Text procType = UIUtils.createLabelText((Composite)propsGroup, (String)CubridMessages.dialog_struct_create_procedure_combo_type, (String)this.type.name());
        procType.setEditable(false);
        propsGroup.setTabList((Control[])ArrayUtils.remove(Control.class, (Object[])propsGroup.getTabList(), (Object)containerText));
        return propsGroup;
    }
}

