// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/aiplatform/v1beta1/data_labeling_job.proto

package aiplatform

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	money "google.golang.org/genproto/googleapis/type/money"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Sample strategy decides which subset of DataItems should be selected for
// human labeling in every batch.
type SampleConfig_SampleStrategy int32

const (
	// Default will be treated as UNCERTAINTY.
	SampleConfig_SAMPLE_STRATEGY_UNSPECIFIED SampleConfig_SampleStrategy = 0
	// Sample the most uncertain data to label.
	SampleConfig_UNCERTAINTY SampleConfig_SampleStrategy = 1
)

// Enum value maps for SampleConfig_SampleStrategy.
var (
	SampleConfig_SampleStrategy_name = map[int32]string{
		0: "SAMPLE_STRATEGY_UNSPECIFIED",
		1: "UNCERTAINTY",
	}
	SampleConfig_SampleStrategy_value = map[string]int32{
		"SAMPLE_STRATEGY_UNSPECIFIED": 0,
		"UNCERTAINTY":                 1,
	}
)

func (x SampleConfig_SampleStrategy) Enum() *SampleConfig_SampleStrategy {
	p := new(SampleConfig_SampleStrategy)
	*p = x
	return p
}

func (x SampleConfig_SampleStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SampleConfig_SampleStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_enumTypes[0].Descriptor()
}

func (SampleConfig_SampleStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_enumTypes[0]
}

func (x SampleConfig_SampleStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SampleConfig_SampleStrategy.Descriptor instead.
func (SampleConfig_SampleStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescGZIP(), []int{2, 0}
}

// DataLabelingJob is used to trigger a human labeling job on unlabeled data
// from the following Dataset:
type DataLabelingJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the DataLabelingJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user-defined name of the DataLabelingJob.
	// The name can be up to 128 characters long and can be consist of any UTF-8
	// characters.
	// Display name of a DataLabelingJob.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Dataset resource names. Right now we only support labeling from a single
	// Dataset.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Datasets []string `protobuf:"bytes,3,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// Labels to assign to annotations generated by this DataLabelingJob.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable.
	AnnotationLabels map[string]string `protobuf:"bytes,12,rep,name=annotation_labels,json=annotationLabels,proto3" json:"annotation_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Number of labelers to work on each DataItem.
	LabelerCount int32 `protobuf:"varint,4,opt,name=labeler_count,json=labelerCount,proto3" json:"labeler_count,omitempty"`
	// Required. The Google Cloud Storage location of the instruction pdf. This pdf is
	// shared with labelers, and provides detailed description on how to label
	// DataItems in Datasets.
	InstructionUri string `protobuf:"bytes,5,opt,name=instruction_uri,json=instructionUri,proto3" json:"instruction_uri,omitempty"`
	// Required. Points to a YAML file stored on Google Cloud Storage describing the
	// config for a specific type of DataLabelingJob.
	// The schema files that can be used here are found in the
	// https://storage.googleapis.com/google-cloud-aiplatform bucket in the
	// /schema/datalabelingjob/inputs/ folder.
	InputsSchemaUri string `protobuf:"bytes,6,opt,name=inputs_schema_uri,json=inputsSchemaUri,proto3" json:"inputs_schema_uri,omitempty"`
	// Required. Input config parameters for the DataLabelingJob.
	Inputs *structpb.Value `protobuf:"bytes,7,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// Output only. The detailed state of the job.
	State JobState `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.JobState" json:"state,omitempty"`
	// Output only. Current labeling job progress percentage scaled in interval [0, 100],
	// indicating the percentage of DataItems that has been finished.
	LabelingProgress int32 `protobuf:"varint,13,opt,name=labeling_progress,json=labelingProgress,proto3" json:"labeling_progress,omitempty"`
	// Output only. Estimated cost(in US dollars) that the DataLabelingJob has incurred to
	// date.
	CurrentSpend *money.Money `protobuf:"bytes,14,opt,name=current_spend,json=currentSpend,proto3" json:"current_spend,omitempty"`
	// Output only. Timestamp when this DataLabelingJob was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this DataLabelingJob was updated most recently.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. DataLabelingJob errors. It is only populated when job's state is
	// `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	Error *status.Status `protobuf:"bytes,22,opt,name=error,proto3" json:"error,omitempty"`
	// The labels with user-defined metadata to organize your DataLabelingJobs.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable. Following system labels exist for each DataLabelingJob:
	//
	// * "aiplatform.googleapis.com/schema": output only, its value is the
	//   [inputs_schema][google.cloud.aiplatform.v1beta1.DataLabelingJob.inputs_schema_uri]'s title.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The SpecialistPools' resource names associated with this job.
	SpecialistPools []string `protobuf:"bytes,16,rep,name=specialist_pools,json=specialistPools,proto3" json:"specialist_pools,omitempty"`
	// Customer-managed encryption key spec for a DataLabelingJob. If set, this
	// DataLabelingJob will be secured by this key.
	//
	// Note: Annotations created in the DataLabelingJob are associated with
	// the EncryptionSpec of the Dataset they are exported to.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,20,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Parameters that configure active learning pipeline. Active learning will
	// label the data incrementally via several iterations. For every iteration,
	// it will select a batch of data based on the sampling strategy.
	ActiveLearningConfig *ActiveLearningConfig `protobuf:"bytes,21,opt,name=active_learning_config,json=activeLearningConfig,proto3" json:"active_learning_config,omitempty"`
}

func (x *DataLabelingJob) Reset() {
	*x = DataLabelingJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataLabelingJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataLabelingJob) ProtoMessage() {}

func (x *DataLabelingJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataLabelingJob.ProtoReflect.Descriptor instead.
func (*DataLabelingJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescGZIP(), []int{0}
}

func (x *DataLabelingJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataLabelingJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataLabelingJob) GetDatasets() []string {
	if x != nil {
		return x.Datasets
	}
	return nil
}

func (x *DataLabelingJob) GetAnnotationLabels() map[string]string {
	if x != nil {
		return x.AnnotationLabels
	}
	return nil
}

func (x *DataLabelingJob) GetLabelerCount() int32 {
	if x != nil {
		return x.LabelerCount
	}
	return 0
}

func (x *DataLabelingJob) GetInstructionUri() string {
	if x != nil {
		return x.InstructionUri
	}
	return ""
}

func (x *DataLabelingJob) GetInputsSchemaUri() string {
	if x != nil {
		return x.InputsSchemaUri
	}
	return ""
}

func (x *DataLabelingJob) GetInputs() *structpb.Value {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *DataLabelingJob) GetState() JobState {
	if x != nil {
		return x.State
	}
	return JobState_JOB_STATE_UNSPECIFIED
}

func (x *DataLabelingJob) GetLabelingProgress() int32 {
	if x != nil {
		return x.LabelingProgress
	}
	return 0
}

func (x *DataLabelingJob) GetCurrentSpend() *money.Money {
	if x != nil {
		return x.CurrentSpend
	}
	return nil
}

func (x *DataLabelingJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DataLabelingJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DataLabelingJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DataLabelingJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DataLabelingJob) GetSpecialistPools() []string {
	if x != nil {
		return x.SpecialistPools
	}
	return nil
}

func (x *DataLabelingJob) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *DataLabelingJob) GetActiveLearningConfig() *ActiveLearningConfig {
	if x != nil {
		return x.ActiveLearningConfig
	}
	return nil
}

// Parameters that configure active learning pipeline. Active learning will
//  label the data incrementally by several iterations. For every iteration, it
//  will select a batch of data based on the sampling strategy.
type ActiveLearningConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Max human labeling DataItems. The rest part will be labeled by
	// machine.
	//
	// Types that are assignable to HumanLabelingBudget:
	//	*ActiveLearningConfig_MaxDataItemCount
	//	*ActiveLearningConfig_MaxDataItemPercentage
	HumanLabelingBudget isActiveLearningConfig_HumanLabelingBudget `protobuf_oneof:"human_labeling_budget"`
	// Active learning data sampling config. For every active learning labeling
	// iteration, it will select a batch of data based on the sampling strategy.
	SampleConfig *SampleConfig `protobuf:"bytes,3,opt,name=sample_config,json=sampleConfig,proto3" json:"sample_config,omitempty"`
	// CMLE training config. For every active learning labeling iteration, system
	// will train a machine learning model on CMLE. The trained model will be used
	// by data sampling algorithm to select DataItems.
	TrainingConfig *TrainingConfig `protobuf:"bytes,4,opt,name=training_config,json=trainingConfig,proto3" json:"training_config,omitempty"`
}

func (x *ActiveLearningConfig) Reset() {
	*x = ActiveLearningConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActiveLearningConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActiveLearningConfig) ProtoMessage() {}

func (x *ActiveLearningConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActiveLearningConfig.ProtoReflect.Descriptor instead.
func (*ActiveLearningConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescGZIP(), []int{1}
}

func (m *ActiveLearningConfig) GetHumanLabelingBudget() isActiveLearningConfig_HumanLabelingBudget {
	if m != nil {
		return m.HumanLabelingBudget
	}
	return nil
}

func (x *ActiveLearningConfig) GetMaxDataItemCount() int64 {
	if x, ok := x.GetHumanLabelingBudget().(*ActiveLearningConfig_MaxDataItemCount); ok {
		return x.MaxDataItemCount
	}
	return 0
}

func (x *ActiveLearningConfig) GetMaxDataItemPercentage() int32 {
	if x, ok := x.GetHumanLabelingBudget().(*ActiveLearningConfig_MaxDataItemPercentage); ok {
		return x.MaxDataItemPercentage
	}
	return 0
}

func (x *ActiveLearningConfig) GetSampleConfig() *SampleConfig {
	if x != nil {
		return x.SampleConfig
	}
	return nil
}

func (x *ActiveLearningConfig) GetTrainingConfig() *TrainingConfig {
	if x != nil {
		return x.TrainingConfig
	}
	return nil
}

type isActiveLearningConfig_HumanLabelingBudget interface {
	isActiveLearningConfig_HumanLabelingBudget()
}

type ActiveLearningConfig_MaxDataItemCount struct {
	// Max number of human labeled DataItems.
	MaxDataItemCount int64 `protobuf:"varint,1,opt,name=max_data_item_count,json=maxDataItemCount,proto3,oneof"`
}

type ActiveLearningConfig_MaxDataItemPercentage struct {
	// Max percent of total DataItems for human labeling.
	MaxDataItemPercentage int32 `protobuf:"varint,2,opt,name=max_data_item_percentage,json=maxDataItemPercentage,proto3,oneof"`
}

func (*ActiveLearningConfig_MaxDataItemCount) isActiveLearningConfig_HumanLabelingBudget() {}

func (*ActiveLearningConfig_MaxDataItemPercentage) isActiveLearningConfig_HumanLabelingBudget() {}

// Active learning data sampling config. For every active learning labeling
// iteration, it will select a batch of data based on the sampling strategy.
type SampleConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Decides sample size for the initial batch. initial_batch_sample_percentage
	// is used by default.
	//
	// Types that are assignable to InitialBatchSampleSize:
	//	*SampleConfig_InitialBatchSamplePercentage
	InitialBatchSampleSize isSampleConfig_InitialBatchSampleSize `protobuf_oneof:"initial_batch_sample_size"`
	// Decides sample size for the following batches.
	// following_batch_sample_percentage is used by default.
	//
	// Types that are assignable to FollowingBatchSampleSize:
	//	*SampleConfig_FollowingBatchSamplePercentage
	FollowingBatchSampleSize isSampleConfig_FollowingBatchSampleSize `protobuf_oneof:"following_batch_sample_size"`
	// Field to chose sampling strategy. Sampling strategy will decide which data
	// should be selected for human labeling in every batch.
	SampleStrategy SampleConfig_SampleStrategy `protobuf:"varint,5,opt,name=sample_strategy,json=sampleStrategy,proto3,enum=google.cloud.aiplatform.v1beta1.SampleConfig_SampleStrategy" json:"sample_strategy,omitempty"`
}

func (x *SampleConfig) Reset() {
	*x = SampleConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SampleConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampleConfig) ProtoMessage() {}

func (x *SampleConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampleConfig.ProtoReflect.Descriptor instead.
func (*SampleConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescGZIP(), []int{2}
}

func (m *SampleConfig) GetInitialBatchSampleSize() isSampleConfig_InitialBatchSampleSize {
	if m != nil {
		return m.InitialBatchSampleSize
	}
	return nil
}

func (x *SampleConfig) GetInitialBatchSamplePercentage() int32 {
	if x, ok := x.GetInitialBatchSampleSize().(*SampleConfig_InitialBatchSamplePercentage); ok {
		return x.InitialBatchSamplePercentage
	}
	return 0
}

func (m *SampleConfig) GetFollowingBatchSampleSize() isSampleConfig_FollowingBatchSampleSize {
	if m != nil {
		return m.FollowingBatchSampleSize
	}
	return nil
}

func (x *SampleConfig) GetFollowingBatchSamplePercentage() int32 {
	if x, ok := x.GetFollowingBatchSampleSize().(*SampleConfig_FollowingBatchSamplePercentage); ok {
		return x.FollowingBatchSamplePercentage
	}
	return 0
}

func (x *SampleConfig) GetSampleStrategy() SampleConfig_SampleStrategy {
	if x != nil {
		return x.SampleStrategy
	}
	return SampleConfig_SAMPLE_STRATEGY_UNSPECIFIED
}

type isSampleConfig_InitialBatchSampleSize interface {
	isSampleConfig_InitialBatchSampleSize()
}

type SampleConfig_InitialBatchSamplePercentage struct {
	// The percentage of data needed to be labeled in the first batch.
	InitialBatchSamplePercentage int32 `protobuf:"varint,1,opt,name=initial_batch_sample_percentage,json=initialBatchSamplePercentage,proto3,oneof"`
}

func (*SampleConfig_InitialBatchSamplePercentage) isSampleConfig_InitialBatchSampleSize() {}

type isSampleConfig_FollowingBatchSampleSize interface {
	isSampleConfig_FollowingBatchSampleSize()
}

type SampleConfig_FollowingBatchSamplePercentage struct {
	// The percentage of data needed to be labeled in each following batch
	// (except the first batch).
	FollowingBatchSamplePercentage int32 `protobuf:"varint,3,opt,name=following_batch_sample_percentage,json=followingBatchSamplePercentage,proto3,oneof"`
}

func (*SampleConfig_FollowingBatchSamplePercentage) isSampleConfig_FollowingBatchSampleSize() {}

// CMLE training config. For every active learning labeling iteration, system
// will train a machine learning model on CMLE. The trained model will be used
// by data sampling algorithm to select DataItems.
type TrainingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timeout hours for the CMLE training job, expressed in milli hours
	// i.e. 1,000 value in this field means 1 hour.
	TimeoutTrainingMilliHours int64 `protobuf:"varint,1,opt,name=timeout_training_milli_hours,json=timeoutTrainingMilliHours,proto3" json:"timeout_training_milli_hours,omitempty"`
}

func (x *TrainingConfig) Reset() {
	*x = TrainingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainingConfig) ProtoMessage() {}

func (x *TrainingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainingConfig.ProtoReflect.Descriptor instead.
func (*TrainingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescGZIP(), []int{3}
}

func (x *TrainingConfig) GetTimeoutTrainingMilliHours() int64 {
	if x != nil {
		return x.TimeoutTrainingMilliHours
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_data_labeling_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfb, 0x0a, 0x0a,
	0x0f, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x45, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x73, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x28, 0x0a,
	0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x55, 0x72, 0x69, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x12, 0x33, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x30, 0x0a, 0x11, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x3c, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73,
	0x70, 0x65, 0x6e, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x6e,
	0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x54, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x10,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x6b, 0x0a, 0x16, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x65,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x43, 0x0a, 0x15,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7c, 0xea, 0x41,
	0x79, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x4c, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x22, 0xc9, 0x02, 0x0a, 0x14, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x2f, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x69, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x00, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74,
	0x61, 0x49, 0x74, 0x65, 0x6d, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x52, 0x0a, 0x0d, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x17, 0x0a,
	0x15, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x22, 0x8b, 0x03, 0x0a, 0x0c, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x1f, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x1c, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65,
	0x12, 0x4b, 0x0a, 0x21, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x1e, 0x66,
	0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x65, 0x0a,
	0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x52, 0x0e, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x22, 0x42, 0x0a, 0x0e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x41, 0x4d, 0x50, 0x4c, 0x45,
	0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x43, 0x45, 0x52,
	0x54, 0x41, 0x49, 0x4e, 0x54, 0x59, 0x10, 0x01, 0x42, 0x1b, 0x0a, 0x19, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x1d, 0x0a, 0x1b, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69,
	0x6e, 0x67, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x22, 0x51, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x1c, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x5f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69,
	0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x69, 0x6c,
	0x6c, 0x69, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x42, 0x88, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42,
	0x14, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_goTypes = []interface{}{
	(SampleConfig_SampleStrategy)(0), // 0: google.cloud.aiplatform.v1beta1.SampleConfig.SampleStrategy
	(*DataLabelingJob)(nil),          // 1: google.cloud.aiplatform.v1beta1.DataLabelingJob
	(*ActiveLearningConfig)(nil),     // 2: google.cloud.aiplatform.v1beta1.ActiveLearningConfig
	(*SampleConfig)(nil),             // 3: google.cloud.aiplatform.v1beta1.SampleConfig
	(*TrainingConfig)(nil),           // 4: google.cloud.aiplatform.v1beta1.TrainingConfig
	nil,                              // 5: google.cloud.aiplatform.v1beta1.DataLabelingJob.AnnotationLabelsEntry
	nil,                              // 6: google.cloud.aiplatform.v1beta1.DataLabelingJob.LabelsEntry
	(*structpb.Value)(nil),           // 7: google.protobuf.Value
	(JobState)(0),                    // 8: google.cloud.aiplatform.v1beta1.JobState
	(*money.Money)(nil),              // 9: google.type.Money
	(*timestamppb.Timestamp)(nil),    // 10: google.protobuf.Timestamp
	(*status.Status)(nil),            // 11: google.rpc.Status
	(*EncryptionSpec)(nil),           // 12: google.cloud.aiplatform.v1beta1.EncryptionSpec
}
var file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_depIdxs = []int32{
	5,  // 0: google.cloud.aiplatform.v1beta1.DataLabelingJob.annotation_labels:type_name -> google.cloud.aiplatform.v1beta1.DataLabelingJob.AnnotationLabelsEntry
	7,  // 1: google.cloud.aiplatform.v1beta1.DataLabelingJob.inputs:type_name -> google.protobuf.Value
	8,  // 2: google.cloud.aiplatform.v1beta1.DataLabelingJob.state:type_name -> google.cloud.aiplatform.v1beta1.JobState
	9,  // 3: google.cloud.aiplatform.v1beta1.DataLabelingJob.current_spend:type_name -> google.type.Money
	10, // 4: google.cloud.aiplatform.v1beta1.DataLabelingJob.create_time:type_name -> google.protobuf.Timestamp
	10, // 5: google.cloud.aiplatform.v1beta1.DataLabelingJob.update_time:type_name -> google.protobuf.Timestamp
	11, // 6: google.cloud.aiplatform.v1beta1.DataLabelingJob.error:type_name -> google.rpc.Status
	6,  // 7: google.cloud.aiplatform.v1beta1.DataLabelingJob.labels:type_name -> google.cloud.aiplatform.v1beta1.DataLabelingJob.LabelsEntry
	12, // 8: google.cloud.aiplatform.v1beta1.DataLabelingJob.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	2,  // 9: google.cloud.aiplatform.v1beta1.DataLabelingJob.active_learning_config:type_name -> google.cloud.aiplatform.v1beta1.ActiveLearningConfig
	3,  // 10: google.cloud.aiplatform.v1beta1.ActiveLearningConfig.sample_config:type_name -> google.cloud.aiplatform.v1beta1.SampleConfig
	4,  // 11: google.cloud.aiplatform.v1beta1.ActiveLearningConfig.training_config:type_name -> google.cloud.aiplatform.v1beta1.TrainingConfig
	0,  // 12: google.cloud.aiplatform.v1beta1.SampleConfig.sample_strategy:type_name -> google.cloud.aiplatform.v1beta1.SampleConfig.SampleStrategy
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_init() }
func file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_data_labeling_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_accelerator_type_proto_init()
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_job_state_proto_init()
	file_google_cloud_aiplatform_v1beta1_specialist_pool_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataLabelingJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActiveLearningConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SampleConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ActiveLearningConfig_MaxDataItemCount)(nil),
		(*ActiveLearningConfig_MaxDataItemPercentage)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*SampleConfig_InitialBatchSamplePercentage)(nil),
		(*SampleConfig_FollowingBatchSamplePercentage)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_data_labeling_job_proto = out.File
	file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_data_labeling_job_proto_depIdxs = nil
}
