// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/analytics/data/v1beta/analytics_data_api.proto

package data

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The dimensions and metrics currently accepted in reporting methods.
type Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of this metadata.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The dimension descriptions.
	Dimensions []*DimensionMetadata `protobuf:"bytes,1,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The metric descriptions.
	Metrics []*MetricMetadata `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{0}
}

func (x *Metadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Metadata) GetDimensions() []*DimensionMetadata {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *Metadata) GetMetrics() []*MetricMetadata {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// The request to generate a report.
type RunReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Google Analytics GA4 property identifier whose events are tracked.
	// Specified in the URL path and not the body. To learn more, see [where to
	// find your Property
	// ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
	// Within a batch request, this property should either be unspecified or
	// consistent with the batch-level property.
	//
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The dimensions requested and displayed.
	Dimensions []*Dimension `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The metrics requested and displayed.
	Metrics []*Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Date ranges of data to read. If multiple date ranges are requested, each
	// response row will contain a zero based date range index. If two date
	// ranges overlap, the event data for the overlapping days is included in the
	// response rows for both date ranges. In a cohort request, this `dateRanges`
	// must be unspecified.
	DateRanges []*DateRange `protobuf:"bytes,4,rep,name=date_ranges,json=dateRanges,proto3" json:"date_ranges,omitempty"`
	// The filter clause of dimensions. Dimensions must be requested to be used in
	// this filter. Metrics cannot be used in this filter.
	DimensionFilter *FilterExpression `protobuf:"bytes,5,opt,name=dimension_filter,json=dimensionFilter,proto3" json:"dimension_filter,omitempty"`
	// The filter clause of metrics. Applied at post aggregation phase, similar to
	// SQL having-clause. Metrics must be requested to be used in this filter.
	// Dimensions cannot be used in this filter.
	MetricFilter *FilterExpression `protobuf:"bytes,6,opt,name=metric_filter,json=metricFilter,proto3" json:"metric_filter,omitempty"`
	// Page size is for paging and specifies maximum number of rows to return. The
	// API returns a maximum of 200,000 rows per request, no matter how many you
	// ask for. Page size must be positive.
	//
	// The API can also return fewer rows than the requested `pageSize`, if there
	// aren't as many dimension values as the `pageSize`. For instance, there are
	// fewer than 300 possible values for the dimension `country`, so when
	// reporting on only `country`, you can't get more than 300 rows, even if you
	// set `pageSize` to a higher value.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A continuation token to get the next page of the results. Adding this to
	// the request will return the next page of rows after the `pageToken`. The
	// `pageToken` should be the value returned in the `nextPageToken` parameter
	// in the response.
	//
	// When paginating, all other parameters specified in `RunReportRequest` must
	// match the call that provided the page token.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Aggregation of metrics. Aggregated metric values will be shown in rows
	// where the dimension_values are set to "RESERVED_(MetricAggregation)".
	MetricAggregations []MetricAggregation `protobuf:"varint,9,rep,packed,name=metric_aggregations,json=metricAggregations,proto3,enum=google.analytics.data.v1beta.MetricAggregation" json:"metric_aggregations,omitempty"`
	// Specifies how rows are ordered in the response.
	OrderBys []*OrderBy `protobuf:"bytes,10,rep,name=order_bys,json=orderBys,proto3" json:"order_bys,omitempty"`
	// A currency code in ISO4217 format, such as "AED", "USD", "JPY".
	// If the field is empty, the report uses the property's default currency.
	CurrencyCode string `protobuf:"bytes,11,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Cohort group associated with this request. If there is a cohort group
	// in the request the 'cohort' dimension must be present.
	CohortSpec *CohortSpec `protobuf:"bytes,12,opt,name=cohort_spec,json=cohortSpec,proto3" json:"cohort_spec,omitempty"`
	// If false or unspecified, each row with all metrics equal to 0 will not be
	// returned. If true, these rows will be returned if they are not separately
	// removed by a filter.
	KeepEmptyRows bool `protobuf:"varint,13,opt,name=keep_empty_rows,json=keepEmptyRows,proto3" json:"keep_empty_rows,omitempty"`
	// Toggles whether to return the current state of this Analytics Property's
	// quota. Quota is returned in [PropertyQuota](#PropertyQuota).
	ReturnPropertyQuota bool `protobuf:"varint,14,opt,name=return_property_quota,json=returnPropertyQuota,proto3" json:"return_property_quota,omitempty"`
}

func (x *RunReportRequest) Reset() {
	*x = RunReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunReportRequest) ProtoMessage() {}

func (x *RunReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunReportRequest.ProtoReflect.Descriptor instead.
func (*RunReportRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{1}
}

func (x *RunReportRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *RunReportRequest) GetDimensions() []*Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *RunReportRequest) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *RunReportRequest) GetDateRanges() []*DateRange {
	if x != nil {
		return x.DateRanges
	}
	return nil
}

func (x *RunReportRequest) GetDimensionFilter() *FilterExpression {
	if x != nil {
		return x.DimensionFilter
	}
	return nil
}

func (x *RunReportRequest) GetMetricFilter() *FilterExpression {
	if x != nil {
		return x.MetricFilter
	}
	return nil
}

func (x *RunReportRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *RunReportRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *RunReportRequest) GetMetricAggregations() []MetricAggregation {
	if x != nil {
		return x.MetricAggregations
	}
	return nil
}

func (x *RunReportRequest) GetOrderBys() []*OrderBy {
	if x != nil {
		return x.OrderBys
	}
	return nil
}

func (x *RunReportRequest) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *RunReportRequest) GetCohortSpec() *CohortSpec {
	if x != nil {
		return x.CohortSpec
	}
	return nil
}

func (x *RunReportRequest) GetKeepEmptyRows() bool {
	if x != nil {
		return x.KeepEmptyRows
	}
	return false
}

func (x *RunReportRequest) GetReturnPropertyQuota() bool {
	if x != nil {
		return x.ReturnPropertyQuota
	}
	return false
}

// The response report table corresponding to a request.
type RunReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes dimension columns. The number of DimensionHeaders and ordering of
	// DimensionHeaders matches the dimensions present in rows.
	DimensionHeaders []*DimensionHeader `protobuf:"bytes,1,rep,name=dimension_headers,json=dimensionHeaders,proto3" json:"dimension_headers,omitempty"`
	// Describes metric columns. The number of MetricHeaders and ordering of
	// MetricHeaders matches the metrics present in rows.
	MetricHeaders []*MetricHeader `protobuf:"bytes,2,rep,name=metric_headers,json=metricHeaders,proto3" json:"metric_headers,omitempty"`
	// Rows of dimension value combinations and metric values in the report.
	Rows []*Row `protobuf:"bytes,3,rep,name=rows,proto3" json:"rows,omitempty"`
	// If requested, the totaled values of metrics.
	Totals []*Row `protobuf:"bytes,4,rep,name=totals,proto3" json:"totals,omitempty"`
	// If requested, the maximum values of metrics.
	Maximums []*Row `protobuf:"bytes,5,rep,name=maximums,proto3" json:"maximums,omitempty"`
	// If requested, the minimum values of metrics.
	Minimums []*Row `protobuf:"bytes,6,rep,name=minimums,proto3" json:"minimums,omitempty"`
	// A token that can be sent as `pageToken` in a subsequent `RunReportRequest`
	// call to retrieve the next page of report rows. If this field is omitted,
	// there are no subsequent pages of report rows.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	NextPageToken string `protobuf:"bytes,7,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of rows in the query result. `totalSize` is independent of
	// the number of rows returned in the response, the `pageSize` request
	// parameter, and the `pageToken` request parameter. For example if a query
	// returns 175 rows and includes `pageSize` of 50 in the API request, the
	// response will contain `totalSize` of 175 but only 50 rows.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	TotalSize int32 `protobuf:"varint,8,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// Metadata for the report.
	Metadata *ResponseMetaData `protobuf:"bytes,9,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// This Analytics Property's quota state including this request.
	PropertyQuota *PropertyQuota `protobuf:"bytes,10,opt,name=property_quota,json=propertyQuota,proto3" json:"property_quota,omitempty"`
}

func (x *RunReportResponse) Reset() {
	*x = RunReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunReportResponse) ProtoMessage() {}

func (x *RunReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunReportResponse.ProtoReflect.Descriptor instead.
func (*RunReportResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{2}
}

func (x *RunReportResponse) GetDimensionHeaders() []*DimensionHeader {
	if x != nil {
		return x.DimensionHeaders
	}
	return nil
}

func (x *RunReportResponse) GetMetricHeaders() []*MetricHeader {
	if x != nil {
		return x.MetricHeaders
	}
	return nil
}

func (x *RunReportResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *RunReportResponse) GetTotals() []*Row {
	if x != nil {
		return x.Totals
	}
	return nil
}

func (x *RunReportResponse) GetMaximums() []*Row {
	if x != nil {
		return x.Maximums
	}
	return nil
}

func (x *RunReportResponse) GetMinimums() []*Row {
	if x != nil {
		return x.Minimums
	}
	return nil
}

func (x *RunReportResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *RunReportResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *RunReportResponse) GetMetadata() *ResponseMetaData {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *RunReportResponse) GetPropertyQuota() *PropertyQuota {
	if x != nil {
		return x.PropertyQuota
	}
	return nil
}

// The request to generate a pivot report.
type RunPivotReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Google Analytics GA4 property identifier whose events are tracked.
	// Specified in the URL path and not the body. To learn more, see [where to
	// find your Property
	// ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
	// Within a batch request, this property should either be unspecified or
	// consistent with the batch-level property.
	//
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The dimensions requested. All defined dimensions must be used by one of the
	// following: dimension_expression, dimension_filter, pivots, order_bys.
	Dimensions []*Dimension `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The metrics requested, at least one metric needs to be specified. All
	// defined metrics must be used by one of the following: metric_expression,
	// metric_filter, order_bys.
	Metrics []*Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// The date range to retrieve event data for the report. If multiple date
	// ranges are specified, event data from each date range is used in the
	// report. A special dimension with field name "dateRange" can be included in
	// a Pivot's field names; if included, the report compares between date
	// ranges. In a cohort request, this `dateRanges` must be unspecified.
	DateRanges []*DateRange `protobuf:"bytes,4,rep,name=date_ranges,json=dateRanges,proto3" json:"date_ranges,omitempty"`
	// Describes the visual format of the report's dimensions in columns or rows.
	// The union of the fieldNames (dimension names) in all pivots must be a
	// subset of dimension names defined in Dimensions. No two pivots can share a
	// dimension. A dimension is only visible if it appears in a pivot.
	Pivots []*Pivot `protobuf:"bytes,5,rep,name=pivots,proto3" json:"pivots,omitempty"`
	// The filter clause of dimensions. Dimensions must be requested to be used in
	// this filter. Metrics cannot be used in this filter.
	DimensionFilter *FilterExpression `protobuf:"bytes,6,opt,name=dimension_filter,json=dimensionFilter,proto3" json:"dimension_filter,omitempty"`
	// The filter clause of metrics. Applied at post aggregation phase, similar to
	// SQL having-clause. Metrics must be requested to be used in this filter.
	// Dimensions cannot be used in this filter.
	MetricFilter *FilterExpression `protobuf:"bytes,7,opt,name=metric_filter,json=metricFilter,proto3" json:"metric_filter,omitempty"`
	// A currency code in ISO4217 format, such as "AED", "USD", "JPY".
	// If the field is empty, the report uses the property's default currency.
	CurrencyCode string `protobuf:"bytes,8,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Cohort group associated with this request. If there is a cohort group
	// in the request the 'cohort' dimension must be present.
	CohortSpec *CohortSpec `protobuf:"bytes,9,opt,name=cohort_spec,json=cohortSpec,proto3" json:"cohort_spec,omitempty"`
	// If false or unspecified, each row with all metrics equal to 0 will not be
	// returned. If true, these rows will be returned if they are not separately
	// removed by a filter.
	KeepEmptyRows bool `protobuf:"varint,10,opt,name=keep_empty_rows,json=keepEmptyRows,proto3" json:"keep_empty_rows,omitempty"`
	// Toggles whether to return the current state of this Analytics Property's
	// quota. Quota is returned in [PropertyQuota](#PropertyQuota).
	ReturnPropertyQuota bool `protobuf:"varint,11,opt,name=return_property_quota,json=returnPropertyQuota,proto3" json:"return_property_quota,omitempty"`
}

func (x *RunPivotReportRequest) Reset() {
	*x = RunPivotReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPivotReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPivotReportRequest) ProtoMessage() {}

func (x *RunPivotReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPivotReportRequest.ProtoReflect.Descriptor instead.
func (*RunPivotReportRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{3}
}

func (x *RunPivotReportRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *RunPivotReportRequest) GetDimensions() []*Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *RunPivotReportRequest) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *RunPivotReportRequest) GetDateRanges() []*DateRange {
	if x != nil {
		return x.DateRanges
	}
	return nil
}

func (x *RunPivotReportRequest) GetPivots() []*Pivot {
	if x != nil {
		return x.Pivots
	}
	return nil
}

func (x *RunPivotReportRequest) GetDimensionFilter() *FilterExpression {
	if x != nil {
		return x.DimensionFilter
	}
	return nil
}

func (x *RunPivotReportRequest) GetMetricFilter() *FilterExpression {
	if x != nil {
		return x.MetricFilter
	}
	return nil
}

func (x *RunPivotReportRequest) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *RunPivotReportRequest) GetCohortSpec() *CohortSpec {
	if x != nil {
		return x.CohortSpec
	}
	return nil
}

func (x *RunPivotReportRequest) GetKeepEmptyRows() bool {
	if x != nil {
		return x.KeepEmptyRows
	}
	return false
}

func (x *RunPivotReportRequest) GetReturnPropertyQuota() bool {
	if x != nil {
		return x.ReturnPropertyQuota
	}
	return false
}

// The response pivot report table corresponding to a pivot request.
type RunPivotReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Summarizes the columns and rows created by a pivot. Each pivot in the
	// request produces one header in the response. If we have a request like
	// this:
	//
	//     "pivots": [{
	//       "fieldNames": ["country",
	//         "city"]
	//     },
	//     {
	//       "fieldNames": "eventName"
	//     }]
	//
	// We will have the following `pivotHeaders` in the response:
	//
	//     "pivotHeaders" : [{
	//       "dimensionHeaders": [{
	//         "dimensionValues": [
	//            { "value": "United Kingdom" },
	//            { "value": "London" }
	//          ]
	//       },
	//       {
	//         "dimensionValues": [
	//         { "value": "Japan" },
	//         { "value": "Osaka" }
	//         ]
	//       }]
	//     },
	//     {
	//       "dimensionHeaders": [{
	//         "dimensionValues": [{ "value": "session_start" }]
	//       },
	//       {
	//         "dimensionValues": [{ "value": "scroll" }]
	//       }]
	//     }]
	PivotHeaders []*PivotHeader `protobuf:"bytes,1,rep,name=pivot_headers,json=pivotHeaders,proto3" json:"pivot_headers,omitempty"`
	// Describes dimension columns. The number of DimensionHeaders and ordering of
	// DimensionHeaders matches the dimensions present in rows.
	DimensionHeaders []*DimensionHeader `protobuf:"bytes,2,rep,name=dimension_headers,json=dimensionHeaders,proto3" json:"dimension_headers,omitempty"`
	// Describes metric columns. The number of MetricHeaders and ordering of
	// MetricHeaders matches the metrics present in rows.
	MetricHeaders []*MetricHeader `protobuf:"bytes,3,rep,name=metric_headers,json=metricHeaders,proto3" json:"metric_headers,omitempty"`
	// Rows of dimension value combinations and metric values in the report.
	Rows []*Row `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
	// Aggregation of metric values. Can be totals, minimums, or maximums. The
	// returned aggregations are controlled by the metric_aggregations in the
	// pivot. The type of aggregation returned in each row is shown by the
	// dimension_values which are set to "RESERVED_<MetricAggregation>".
	Aggregates []*Row `protobuf:"bytes,5,rep,name=aggregates,proto3" json:"aggregates,omitempty"`
	// Metadata for the report.
	Metadata *ResponseMetaData `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// This Analytics Property's quota state including this request.
	PropertyQuota *PropertyQuota `protobuf:"bytes,7,opt,name=property_quota,json=propertyQuota,proto3" json:"property_quota,omitempty"`
}

func (x *RunPivotReportResponse) Reset() {
	*x = RunPivotReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPivotReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPivotReportResponse) ProtoMessage() {}

func (x *RunPivotReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPivotReportResponse.ProtoReflect.Descriptor instead.
func (*RunPivotReportResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{4}
}

func (x *RunPivotReportResponse) GetPivotHeaders() []*PivotHeader {
	if x != nil {
		return x.PivotHeaders
	}
	return nil
}

func (x *RunPivotReportResponse) GetDimensionHeaders() []*DimensionHeader {
	if x != nil {
		return x.DimensionHeaders
	}
	return nil
}

func (x *RunPivotReportResponse) GetMetricHeaders() []*MetricHeader {
	if x != nil {
		return x.MetricHeaders
	}
	return nil
}

func (x *RunPivotReportResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *RunPivotReportResponse) GetAggregates() []*Row {
	if x != nil {
		return x.Aggregates
	}
	return nil
}

func (x *RunPivotReportResponse) GetMetadata() *ResponseMetaData {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *RunPivotReportResponse) GetPropertyQuota() *PropertyQuota {
	if x != nil {
		return x.PropertyQuota
	}
	return nil
}

// The batch request containing multiple report requests.
type BatchRunReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Google Analytics GA4 property identifier whose events are tracked.
	// Specified in the URL path and not the body. To learn more, see [where to
	// find your Property
	// ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
	// This property must be specified for the batch. The property within
	// RunReportRequest may either be unspecified or consistent with this
	// property.
	//
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Individual requests. Each request has a separate report response. Each
	// batch request is allowed up to 5 requests.
	Requests []*RunReportRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchRunReportsRequest) Reset() {
	*x = BatchRunReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunReportsRequest) ProtoMessage() {}

func (x *BatchRunReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunReportsRequest.ProtoReflect.Descriptor instead.
func (*BatchRunReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{5}
}

func (x *BatchRunReportsRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *BatchRunReportsRequest) GetRequests() []*RunReportRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// The batch response containing multiple reports.
type BatchRunReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Individual responses. Each response has a separate report request.
	Reports []*RunReportResponse `protobuf:"bytes,1,rep,name=reports,proto3" json:"reports,omitempty"`
}

func (x *BatchRunReportsResponse) Reset() {
	*x = BatchRunReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunReportsResponse) ProtoMessage() {}

func (x *BatchRunReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunReportsResponse.ProtoReflect.Descriptor instead.
func (*BatchRunReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{6}
}

func (x *BatchRunReportsResponse) GetReports() []*RunReportResponse {
	if x != nil {
		return x.Reports
	}
	return nil
}

// The batch request containing multiple pivot report requests.
type BatchRunPivotReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Google Analytics GA4 property identifier whose events are tracked.
	// Specified in the URL path and not the body. To learn more, see [where to
	// find your Property
	// ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
	// This property must be specified for the batch. The property within
	// RunPivotReportRequest may either be unspecified or consistent with this
	// property.
	//
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Individual requests. Each request has a separate pivot report response.
	// Each batch request is allowed up to 5 requests.
	Requests []*RunPivotReportRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchRunPivotReportsRequest) Reset() {
	*x = BatchRunPivotReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunPivotReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunPivotReportsRequest) ProtoMessage() {}

func (x *BatchRunPivotReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunPivotReportsRequest.ProtoReflect.Descriptor instead.
func (*BatchRunPivotReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{7}
}

func (x *BatchRunPivotReportsRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *BatchRunPivotReportsRequest) GetRequests() []*RunPivotReportRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// The batch response containing multiple pivot reports.
type BatchRunPivotReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Individual responses. Each response has a separate pivot report request.
	PivotReports []*RunPivotReportResponse `protobuf:"bytes,1,rep,name=pivot_reports,json=pivotReports,proto3" json:"pivot_reports,omitempty"`
}

func (x *BatchRunPivotReportsResponse) Reset() {
	*x = BatchRunPivotReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunPivotReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunPivotReportsResponse) ProtoMessage() {}

func (x *BatchRunPivotReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunPivotReportsResponse.ProtoReflect.Descriptor instead.
func (*BatchRunPivotReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{8}
}

func (x *BatchRunPivotReportsResponse) GetPivotReports() []*RunPivotReportResponse {
	if x != nil {
		return x.PivotReports
	}
	return nil
}

// Request for a property's dimension and metric metadata.
type GetMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the metadata to retrieve. This name field is
	// specified in the URL path and not URL parameters. Property is a numeric
	// Google Analytics GA4 Property identifier. To learn more, see [where to find
	// your Property
	// ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
	//
	// Example: properties/1234/metadata
	//
	// Set the Property ID to 0 for dimensions and metrics common to all
	// properties. In this special mode, this method will not return custom
	// dimensions and metrics.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMetadataRequest) Reset() {
	*x = GetMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadataRequest) ProtoMessage() {}

func (x *GetMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadataRequest.ProtoReflect.Descriptor instead.
func (*GetMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{9}
}

func (x *GetMetadataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to generate a realtime report.
type RunRealtimeReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Google Analytics GA4 property identifier whose events are tracked.
	// Specified in the URL path and not the body. To learn more, see [where to
	// find your Property
	// ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
	//
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The dimensions requested and displayed.
	Dimensions []*Dimension `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The metrics requested and displayed.
	Metrics []*Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// The filter clause of dimensions. Dimensions must be requested to be used in
	// this filter. Metrics cannot be used in this filter.
	DimensionFilter *FilterExpression `protobuf:"bytes,4,opt,name=dimension_filter,json=dimensionFilter,proto3" json:"dimension_filter,omitempty"`
	// The filter clause of metrics. Applied at post aggregation phase, similar to
	// SQL having-clause. Metrics must be requested to be used in this filter.
	// Dimensions cannot be used in this filter.
	MetricFilter *FilterExpression `protobuf:"bytes,5,opt,name=metric_filter,json=metricFilter,proto3" json:"metric_filter,omitempty"`
	// Page size specifies maximum number of rows to return. If unspecified, up to
	// 10,000 rows are returned. The API returns a maximum of 100,000 rows per
	// request, no matter how many you ask for. Page size must be positive.
	//
	// The API can also return fewer rows than the requested `pageSize`, if there
	// aren't as many dimension values as the `pageSize`. For instance, there are
	// fewer than 300 possible values for the dimension `country`, so when
	// reporting on only `country`, you can't get more than 300 rows, even if you
	// set `pageSize` to a higher value.
	//
	// To learn more about this pagination parameter, see
	// [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/realtime-basics#pagination).
	PageSize int32 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Aggregation of metrics. Aggregated metric values will be shown in rows
	// where the dimension_values are set to "RESERVED_(MetricAggregation)".
	MetricAggregations []MetricAggregation `protobuf:"varint,7,rep,packed,name=metric_aggregations,json=metricAggregations,proto3,enum=google.analytics.data.v1beta.MetricAggregation" json:"metric_aggregations,omitempty"`
	// Specifies how rows are ordered in the response.
	OrderBys []*OrderBy `protobuf:"bytes,8,rep,name=order_bys,json=orderBys,proto3" json:"order_bys,omitempty"`
	// Toggles whether to return the current state of this Analytics Property's
	// Realtime quota. Quota is returned in [PropertyQuota](#PropertyQuota).
	ReturnPropertyQuota bool `protobuf:"varint,9,opt,name=return_property_quota,json=returnPropertyQuota,proto3" json:"return_property_quota,omitempty"`
}

func (x *RunRealtimeReportRequest) Reset() {
	*x = RunRealtimeReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunRealtimeReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunRealtimeReportRequest) ProtoMessage() {}

func (x *RunRealtimeReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunRealtimeReportRequest.ProtoReflect.Descriptor instead.
func (*RunRealtimeReportRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{10}
}

func (x *RunRealtimeReportRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *RunRealtimeReportRequest) GetDimensions() []*Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *RunRealtimeReportRequest) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *RunRealtimeReportRequest) GetDimensionFilter() *FilterExpression {
	if x != nil {
		return x.DimensionFilter
	}
	return nil
}

func (x *RunRealtimeReportRequest) GetMetricFilter() *FilterExpression {
	if x != nil {
		return x.MetricFilter
	}
	return nil
}

func (x *RunRealtimeReportRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *RunRealtimeReportRequest) GetMetricAggregations() []MetricAggregation {
	if x != nil {
		return x.MetricAggregations
	}
	return nil
}

func (x *RunRealtimeReportRequest) GetOrderBys() []*OrderBy {
	if x != nil {
		return x.OrderBys
	}
	return nil
}

func (x *RunRealtimeReportRequest) GetReturnPropertyQuota() bool {
	if x != nil {
		return x.ReturnPropertyQuota
	}
	return false
}

// The response realtime report table corresponding to a request.
type RunRealtimeReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes dimension columns. The number of DimensionHeaders and ordering of
	// DimensionHeaders matches the dimensions present in rows.
	DimensionHeaders []*DimensionHeader `protobuf:"bytes,1,rep,name=dimension_headers,json=dimensionHeaders,proto3" json:"dimension_headers,omitempty"`
	// Describes metric columns. The number of MetricHeaders and ordering of
	// MetricHeaders matches the metrics present in rows.
	MetricHeaders []*MetricHeader `protobuf:"bytes,2,rep,name=metric_headers,json=metricHeaders,proto3" json:"metric_headers,omitempty"`
	// Rows of dimension value combinations and metric values in the report.
	Rows []*Row `protobuf:"bytes,3,rep,name=rows,proto3" json:"rows,omitempty"`
	// If requested, the totaled values of metrics.
	Totals []*Row `protobuf:"bytes,4,rep,name=totals,proto3" json:"totals,omitempty"`
	// If requested, the maximum values of metrics.
	Maximums []*Row `protobuf:"bytes,5,rep,name=maximums,proto3" json:"maximums,omitempty"`
	// If requested, the minimum values of metrics.
	Minimums []*Row `protobuf:"bytes,6,rep,name=minimums,proto3" json:"minimums,omitempty"`
	// The total number of rows in the query result. `totalSize` is independent of
	// the number of rows returned in the response and the `pageSize` request
	// parameter. For example if a query returns 175 rows and includes `pageSize`
	// of 50 in the API request, the response will contain `totalSize` of 175 but
	// only 50 rows.
	TotalSize int32 `protobuf:"varint,7,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// This Analytics Property's Realtime quota state including this request.
	PropertyQuota *PropertyQuota `protobuf:"bytes,8,opt,name=property_quota,json=propertyQuota,proto3" json:"property_quota,omitempty"`
}

func (x *RunRealtimeReportResponse) Reset() {
	*x = RunRealtimeReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunRealtimeReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunRealtimeReportResponse) ProtoMessage() {}

func (x *RunRealtimeReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunRealtimeReportResponse.ProtoReflect.Descriptor instead.
func (*RunRealtimeReportResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP(), []int{11}
}

func (x *RunRealtimeReportResponse) GetDimensionHeaders() []*DimensionHeader {
	if x != nil {
		return x.DimensionHeaders
	}
	return nil
}

func (x *RunRealtimeReportResponse) GetMetricHeaders() []*MetricHeader {
	if x != nil {
		return x.MetricHeaders
	}
	return nil
}

func (x *RunRealtimeReportResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *RunRealtimeReportResponse) GetTotals() []*Row {
	if x != nil {
		return x.Totals
	}
	return nil
}

func (x *RunRealtimeReportResponse) GetMaximums() []*Row {
	if x != nil {
		return x.Maximums
	}
	return nil
}

func (x *RunRealtimeReportResponse) GetMinimums() []*Row {
	if x != nil {
		return x.Minimums
	}
	return nil
}

func (x *RunRealtimeReportResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *RunRealtimeReportResponse) GetPropertyQuota() *PropertyQuota {
	if x != nil {
		return x.PropertyQuota
	}
	return nil
}

var File_google_analytics_data_v1beta_analytics_data_api_proto protoreflect.FileDescriptor

var file_google_analytics_data_v1beta_analytics_data_api_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x61, 0x70,
	0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x83, 0x02, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x4a, 0xea, 0x41, 0x47,
	0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xdf, 0x06, 0x0a, 0x10, 0x52, 0x75, 0x6e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x3e, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x48, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x0a, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x10, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x60, 0x0a, 0x13, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x09, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x52, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x49, 0x0a, 0x0b, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x0a, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a,
	0x0f, 0x6b, 0x65, 0x65, 0x70, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x73,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x6b, 0x65, 0x65, 0x70, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x22, 0x99, 0x05, 0x0a, 0x11, 0x52, 0x75,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5a, 0x0a, 0x11, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x35,
	0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52,
	0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x06, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x73,
	0x12, 0x3d, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x73, 0x12,
	0x3d, 0x0a, 0x08, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x52, 0x6f, 0x77, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x52, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x22, 0xbf, 0x05, 0x0a, 0x15, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76,
	0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x47, 0x0a, 0x0a, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x48, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x3b,
	0x0a, 0x06, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x69,
	0x76, 0x6f, 0x74, 0x52, 0x06, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x10, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x49, 0x0a, 0x0b, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0a, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0f, 0x6b,
	0x65, 0x65, 0x70, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x6b, 0x65, 0x65, 0x70, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x52,
	0x6f, 0x77, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x22, 0xb1, 0x04, 0x0a, 0x16, 0x52, 0x75, 0x6e, 0x50,
	0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x0c, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x12, 0x5a, 0x0a, 0x11, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x10, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x51,
	0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x35, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52,
	0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x41, 0x0a, 0x0a, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52,
	0x0a, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x52, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x0d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x22, 0x80, 0x01, 0x0a, 0x16,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x4a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x64,
	0x0a, 0x17, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x07, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x07, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x22, 0x8a, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75,
	0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x12, 0x4f, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x22, 0x79, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76,
	0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x59, 0x0a, 0x0d, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0c,
	0x70, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x22, 0x57, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe6, 0x04, 0x0a, 0x18, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x61,
	0x6c, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x47,
	0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x59, 0x0a, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x53, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x60, 0x0a, 0x13, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x61,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x12, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x09, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x52, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65,
	0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72,
	0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x22, 0xad,
	0x04, 0x0a, 0x19, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x11,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x0d, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x04, 0x72,
	0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f,
	0x77, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x06, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x73, 0x12, 0x3d, 0x0a,
	0x08, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52,
	0x6f, 0x77, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x73, 0x12, 0x3d, 0x0a, 0x08,
	0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x6f,
	0x77, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52,
	0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x32, 0xe3,
	0x09, 0x0a, 0x11, 0x42, 0x65, 0x74, 0x61, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x12, 0xa2, 0x01, 0x0a, 0x09, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x22, 0x29, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xb6, 0x01, 0x0a, 0x0e, 0x52, 0x75,
	0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x50,
	0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x22,
	0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x3a,
	0x01, 0x2a, 0x12, 0xba, 0x01, 0x0a, 0x0f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x22, 0x2f, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0x12,
	0xce, 0x01, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e,
	0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75,
	0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x3a, 0x01, 0x2a,
	0x12, 0x9c, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xc2, 0x01, 0x0a, 0x11, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x75, 0x6e,
	0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x31,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x75, 0x6e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x3a, 0x01, 0x2a, 0x1a, 0x7e, 0xca, 0x41, 0x1c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x72, 0x65, 0x61, 0x64,
	0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x7d, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x41, 0x70, 0x69, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x3b, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescOnce sync.Once
	file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescData = file_google_analytics_data_v1beta_analytics_data_api_proto_rawDesc
)

func file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescGZIP() []byte {
	file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescOnce.Do(func() {
		file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescData)
	})
	return file_google_analytics_data_v1beta_analytics_data_api_proto_rawDescData
}

var file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_analytics_data_v1beta_analytics_data_api_proto_goTypes = []interface{}{
	(*Metadata)(nil),                     // 0: google.analytics.data.v1beta.Metadata
	(*RunReportRequest)(nil),             // 1: google.analytics.data.v1beta.RunReportRequest
	(*RunReportResponse)(nil),            // 2: google.analytics.data.v1beta.RunReportResponse
	(*RunPivotReportRequest)(nil),        // 3: google.analytics.data.v1beta.RunPivotReportRequest
	(*RunPivotReportResponse)(nil),       // 4: google.analytics.data.v1beta.RunPivotReportResponse
	(*BatchRunReportsRequest)(nil),       // 5: google.analytics.data.v1beta.BatchRunReportsRequest
	(*BatchRunReportsResponse)(nil),      // 6: google.analytics.data.v1beta.BatchRunReportsResponse
	(*BatchRunPivotReportsRequest)(nil),  // 7: google.analytics.data.v1beta.BatchRunPivotReportsRequest
	(*BatchRunPivotReportsResponse)(nil), // 8: google.analytics.data.v1beta.BatchRunPivotReportsResponse
	(*GetMetadataRequest)(nil),           // 9: google.analytics.data.v1beta.GetMetadataRequest
	(*RunRealtimeReportRequest)(nil),     // 10: google.analytics.data.v1beta.RunRealtimeReportRequest
	(*RunRealtimeReportResponse)(nil),    // 11: google.analytics.data.v1beta.RunRealtimeReportResponse
	(*DimensionMetadata)(nil),            // 12: google.analytics.data.v1beta.DimensionMetadata
	(*MetricMetadata)(nil),               // 13: google.analytics.data.v1beta.MetricMetadata
	(*Dimension)(nil),                    // 14: google.analytics.data.v1beta.Dimension
	(*Metric)(nil),                       // 15: google.analytics.data.v1beta.Metric
	(*DateRange)(nil),                    // 16: google.analytics.data.v1beta.DateRange
	(*FilterExpression)(nil),             // 17: google.analytics.data.v1beta.FilterExpression
	(MetricAggregation)(0),               // 18: google.analytics.data.v1beta.MetricAggregation
	(*OrderBy)(nil),                      // 19: google.analytics.data.v1beta.OrderBy
	(*CohortSpec)(nil),                   // 20: google.analytics.data.v1beta.CohortSpec
	(*DimensionHeader)(nil),              // 21: google.analytics.data.v1beta.DimensionHeader
	(*MetricHeader)(nil),                 // 22: google.analytics.data.v1beta.MetricHeader
	(*Row)(nil),                          // 23: google.analytics.data.v1beta.Row
	(*ResponseMetaData)(nil),             // 24: google.analytics.data.v1beta.ResponseMetaData
	(*PropertyQuota)(nil),                // 25: google.analytics.data.v1beta.PropertyQuota
	(*Pivot)(nil),                        // 26: google.analytics.data.v1beta.Pivot
	(*PivotHeader)(nil),                  // 27: google.analytics.data.v1beta.PivotHeader
}
var file_google_analytics_data_v1beta_analytics_data_api_proto_depIdxs = []int32{
	12, // 0: google.analytics.data.v1beta.Metadata.dimensions:type_name -> google.analytics.data.v1beta.DimensionMetadata
	13, // 1: google.analytics.data.v1beta.Metadata.metrics:type_name -> google.analytics.data.v1beta.MetricMetadata
	14, // 2: google.analytics.data.v1beta.RunReportRequest.dimensions:type_name -> google.analytics.data.v1beta.Dimension
	15, // 3: google.analytics.data.v1beta.RunReportRequest.metrics:type_name -> google.analytics.data.v1beta.Metric
	16, // 4: google.analytics.data.v1beta.RunReportRequest.date_ranges:type_name -> google.analytics.data.v1beta.DateRange
	17, // 5: google.analytics.data.v1beta.RunReportRequest.dimension_filter:type_name -> google.analytics.data.v1beta.FilterExpression
	17, // 6: google.analytics.data.v1beta.RunReportRequest.metric_filter:type_name -> google.analytics.data.v1beta.FilterExpression
	18, // 7: google.analytics.data.v1beta.RunReportRequest.metric_aggregations:type_name -> google.analytics.data.v1beta.MetricAggregation
	19, // 8: google.analytics.data.v1beta.RunReportRequest.order_bys:type_name -> google.analytics.data.v1beta.OrderBy
	20, // 9: google.analytics.data.v1beta.RunReportRequest.cohort_spec:type_name -> google.analytics.data.v1beta.CohortSpec
	21, // 10: google.analytics.data.v1beta.RunReportResponse.dimension_headers:type_name -> google.analytics.data.v1beta.DimensionHeader
	22, // 11: google.analytics.data.v1beta.RunReportResponse.metric_headers:type_name -> google.analytics.data.v1beta.MetricHeader
	23, // 12: google.analytics.data.v1beta.RunReportResponse.rows:type_name -> google.analytics.data.v1beta.Row
	23, // 13: google.analytics.data.v1beta.RunReportResponse.totals:type_name -> google.analytics.data.v1beta.Row
	23, // 14: google.analytics.data.v1beta.RunReportResponse.maximums:type_name -> google.analytics.data.v1beta.Row
	23, // 15: google.analytics.data.v1beta.RunReportResponse.minimums:type_name -> google.analytics.data.v1beta.Row
	24, // 16: google.analytics.data.v1beta.RunReportResponse.metadata:type_name -> google.analytics.data.v1beta.ResponseMetaData
	25, // 17: google.analytics.data.v1beta.RunReportResponse.property_quota:type_name -> google.analytics.data.v1beta.PropertyQuota
	14, // 18: google.analytics.data.v1beta.RunPivotReportRequest.dimensions:type_name -> google.analytics.data.v1beta.Dimension
	15, // 19: google.analytics.data.v1beta.RunPivotReportRequest.metrics:type_name -> google.analytics.data.v1beta.Metric
	16, // 20: google.analytics.data.v1beta.RunPivotReportRequest.date_ranges:type_name -> google.analytics.data.v1beta.DateRange
	26, // 21: google.analytics.data.v1beta.RunPivotReportRequest.pivots:type_name -> google.analytics.data.v1beta.Pivot
	17, // 22: google.analytics.data.v1beta.RunPivotReportRequest.dimension_filter:type_name -> google.analytics.data.v1beta.FilterExpression
	17, // 23: google.analytics.data.v1beta.RunPivotReportRequest.metric_filter:type_name -> google.analytics.data.v1beta.FilterExpression
	20, // 24: google.analytics.data.v1beta.RunPivotReportRequest.cohort_spec:type_name -> google.analytics.data.v1beta.CohortSpec
	27, // 25: google.analytics.data.v1beta.RunPivotReportResponse.pivot_headers:type_name -> google.analytics.data.v1beta.PivotHeader
	21, // 26: google.analytics.data.v1beta.RunPivotReportResponse.dimension_headers:type_name -> google.analytics.data.v1beta.DimensionHeader
	22, // 27: google.analytics.data.v1beta.RunPivotReportResponse.metric_headers:type_name -> google.analytics.data.v1beta.MetricHeader
	23, // 28: google.analytics.data.v1beta.RunPivotReportResponse.rows:type_name -> google.analytics.data.v1beta.Row
	23, // 29: google.analytics.data.v1beta.RunPivotReportResponse.aggregates:type_name -> google.analytics.data.v1beta.Row
	24, // 30: google.analytics.data.v1beta.RunPivotReportResponse.metadata:type_name -> google.analytics.data.v1beta.ResponseMetaData
	25, // 31: google.analytics.data.v1beta.RunPivotReportResponse.property_quota:type_name -> google.analytics.data.v1beta.PropertyQuota
	1,  // 32: google.analytics.data.v1beta.BatchRunReportsRequest.requests:type_name -> google.analytics.data.v1beta.RunReportRequest
	2,  // 33: google.analytics.data.v1beta.BatchRunReportsResponse.reports:type_name -> google.analytics.data.v1beta.RunReportResponse
	3,  // 34: google.analytics.data.v1beta.BatchRunPivotReportsRequest.requests:type_name -> google.analytics.data.v1beta.RunPivotReportRequest
	4,  // 35: google.analytics.data.v1beta.BatchRunPivotReportsResponse.pivot_reports:type_name -> google.analytics.data.v1beta.RunPivotReportResponse
	14, // 36: google.analytics.data.v1beta.RunRealtimeReportRequest.dimensions:type_name -> google.analytics.data.v1beta.Dimension
	15, // 37: google.analytics.data.v1beta.RunRealtimeReportRequest.metrics:type_name -> google.analytics.data.v1beta.Metric
	17, // 38: google.analytics.data.v1beta.RunRealtimeReportRequest.dimension_filter:type_name -> google.analytics.data.v1beta.FilterExpression
	17, // 39: google.analytics.data.v1beta.RunRealtimeReportRequest.metric_filter:type_name -> google.analytics.data.v1beta.FilterExpression
	18, // 40: google.analytics.data.v1beta.RunRealtimeReportRequest.metric_aggregations:type_name -> google.analytics.data.v1beta.MetricAggregation
	19, // 41: google.analytics.data.v1beta.RunRealtimeReportRequest.order_bys:type_name -> google.analytics.data.v1beta.OrderBy
	21, // 42: google.analytics.data.v1beta.RunRealtimeReportResponse.dimension_headers:type_name -> google.analytics.data.v1beta.DimensionHeader
	22, // 43: google.analytics.data.v1beta.RunRealtimeReportResponse.metric_headers:type_name -> google.analytics.data.v1beta.MetricHeader
	23, // 44: google.analytics.data.v1beta.RunRealtimeReportResponse.rows:type_name -> google.analytics.data.v1beta.Row
	23, // 45: google.analytics.data.v1beta.RunRealtimeReportResponse.totals:type_name -> google.analytics.data.v1beta.Row
	23, // 46: google.analytics.data.v1beta.RunRealtimeReportResponse.maximums:type_name -> google.analytics.data.v1beta.Row
	23, // 47: google.analytics.data.v1beta.RunRealtimeReportResponse.minimums:type_name -> google.analytics.data.v1beta.Row
	25, // 48: google.analytics.data.v1beta.RunRealtimeReportResponse.property_quota:type_name -> google.analytics.data.v1beta.PropertyQuota
	1,  // 49: google.analytics.data.v1beta.BetaAnalyticsData.RunReport:input_type -> google.analytics.data.v1beta.RunReportRequest
	3,  // 50: google.analytics.data.v1beta.BetaAnalyticsData.RunPivotReport:input_type -> google.analytics.data.v1beta.RunPivotReportRequest
	5,  // 51: google.analytics.data.v1beta.BetaAnalyticsData.BatchRunReports:input_type -> google.analytics.data.v1beta.BatchRunReportsRequest
	7,  // 52: google.analytics.data.v1beta.BetaAnalyticsData.BatchRunPivotReports:input_type -> google.analytics.data.v1beta.BatchRunPivotReportsRequest
	9,  // 53: google.analytics.data.v1beta.BetaAnalyticsData.GetMetadata:input_type -> google.analytics.data.v1beta.GetMetadataRequest
	10, // 54: google.analytics.data.v1beta.BetaAnalyticsData.RunRealtimeReport:input_type -> google.analytics.data.v1beta.RunRealtimeReportRequest
	2,  // 55: google.analytics.data.v1beta.BetaAnalyticsData.RunReport:output_type -> google.analytics.data.v1beta.RunReportResponse
	4,  // 56: google.analytics.data.v1beta.BetaAnalyticsData.RunPivotReport:output_type -> google.analytics.data.v1beta.RunPivotReportResponse
	6,  // 57: google.analytics.data.v1beta.BetaAnalyticsData.BatchRunReports:output_type -> google.analytics.data.v1beta.BatchRunReportsResponse
	8,  // 58: google.analytics.data.v1beta.BetaAnalyticsData.BatchRunPivotReports:output_type -> google.analytics.data.v1beta.BatchRunPivotReportsResponse
	0,  // 59: google.analytics.data.v1beta.BetaAnalyticsData.GetMetadata:output_type -> google.analytics.data.v1beta.Metadata
	11, // 60: google.analytics.data.v1beta.BetaAnalyticsData.RunRealtimeReport:output_type -> google.analytics.data.v1beta.RunRealtimeReportResponse
	55, // [55:61] is the sub-list for method output_type
	49, // [49:55] is the sub-list for method input_type
	49, // [49:49] is the sub-list for extension type_name
	49, // [49:49] is the sub-list for extension extendee
	0,  // [0:49] is the sub-list for field type_name
}

func init() { file_google_analytics_data_v1beta_analytics_data_api_proto_init() }
func file_google_analytics_data_v1beta_analytics_data_api_proto_init() {
	if File_google_analytics_data_v1beta_analytics_data_api_proto != nil {
		return
	}
	file_google_analytics_data_v1beta_data_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPivotReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPivotReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunPivotReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunPivotReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunRealtimeReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunRealtimeReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_data_v1beta_analytics_data_api_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_analytics_data_v1beta_analytics_data_api_proto_goTypes,
		DependencyIndexes: file_google_analytics_data_v1beta_analytics_data_api_proto_depIdxs,
		MessageInfos:      file_google_analytics_data_v1beta_analytics_data_api_proto_msgTypes,
	}.Build()
	File_google_analytics_data_v1beta_analytics_data_api_proto = out.File
	file_google_analytics_data_v1beta_analytics_data_api_proto_rawDesc = nil
	file_google_analytics_data_v1beta_analytics_data_api_proto_goTypes = nil
	file_google_analytics_data_v1beta_analytics_data_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BetaAnalyticsDataClient is the client API for BetaAnalyticsData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BetaAnalyticsDataClient interface {
	// Returns a customized report of your Google Analytics event data. Reports
	// contain statistics derived from data collected by the Google Analytics
	// tracking code. The data returned from the API is as a table with columns
	// for the requested dimensions and metrics. Metrics are individual
	// measurements of user activity on your property, such as active users or
	// event count. Dimensions break down metrics across some common criteria,
	// such as country or event name.
	RunReport(ctx context.Context, in *RunReportRequest, opts ...grpc.CallOption) (*RunReportResponse, error)
	// Returns a customized pivot report of your Google Analytics event data.
	// Pivot reports are more advanced and expressive formats than regular
	// reports. In a pivot report, dimensions are only visible if they are
	// included in a pivot. Multiple pivots can be specified to further dissect
	// your data.
	RunPivotReport(ctx context.Context, in *RunPivotReportRequest, opts ...grpc.CallOption) (*RunPivotReportResponse, error)
	// Returns multiple reports in a batch. All reports must be for the same
	// GA4 Property.
	BatchRunReports(ctx context.Context, in *BatchRunReportsRequest, opts ...grpc.CallOption) (*BatchRunReportsResponse, error)
	// Returns multiple pivot reports in a batch. All reports must be for the same
	// GA4 Property.
	BatchRunPivotReports(ctx context.Context, in *BatchRunPivotReportsRequest, opts ...grpc.CallOption) (*BatchRunPivotReportsResponse, error)
	// Returns metadata for dimensions and metrics available in reporting methods.
	// Used to explore the dimensions and metrics. In this method, a Google
	// Analytics GA4 Property Identifier is specified in the request, and
	// the metadata response includes Custom dimensions and metrics as well as
	// Universal metadata.
	//
	// For example if a custom metric with parameter name `levels_unlocked` is
	// registered to a property, the Metadata response will contain
	// `customEvent:levels_unlocked`. Universal metadata are dimensions and
	// metrics applicable to any property such as `country` and `totalUsers`.
	GetMetadata(ctx context.Context, in *GetMetadataRequest, opts ...grpc.CallOption) (*Metadata, error)
	// The Google Analytics Realtime API returns a customized report of realtime
	// event data for your property. These reports show events and usage from the
	// last 30 minutes.
	RunRealtimeReport(ctx context.Context, in *RunRealtimeReportRequest, opts ...grpc.CallOption) (*RunRealtimeReportResponse, error)
}

type betaAnalyticsDataClient struct {
	cc grpc.ClientConnInterface
}

func NewBetaAnalyticsDataClient(cc grpc.ClientConnInterface) BetaAnalyticsDataClient {
	return &betaAnalyticsDataClient{cc}
}

func (c *betaAnalyticsDataClient) RunReport(ctx context.Context, in *RunReportRequest, opts ...grpc.CallOption) (*RunReportResponse, error) {
	out := new(RunReportResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1beta.BetaAnalyticsData/RunReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *betaAnalyticsDataClient) RunPivotReport(ctx context.Context, in *RunPivotReportRequest, opts ...grpc.CallOption) (*RunPivotReportResponse, error) {
	out := new(RunPivotReportResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1beta.BetaAnalyticsData/RunPivotReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *betaAnalyticsDataClient) BatchRunReports(ctx context.Context, in *BatchRunReportsRequest, opts ...grpc.CallOption) (*BatchRunReportsResponse, error) {
	out := new(BatchRunReportsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1beta.BetaAnalyticsData/BatchRunReports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *betaAnalyticsDataClient) BatchRunPivotReports(ctx context.Context, in *BatchRunPivotReportsRequest, opts ...grpc.CallOption) (*BatchRunPivotReportsResponse, error) {
	out := new(BatchRunPivotReportsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1beta.BetaAnalyticsData/BatchRunPivotReports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *betaAnalyticsDataClient) GetMetadata(ctx context.Context, in *GetMetadataRequest, opts ...grpc.CallOption) (*Metadata, error) {
	out := new(Metadata)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1beta.BetaAnalyticsData/GetMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *betaAnalyticsDataClient) RunRealtimeReport(ctx context.Context, in *RunRealtimeReportRequest, opts ...grpc.CallOption) (*RunRealtimeReportResponse, error) {
	out := new(RunRealtimeReportResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1beta.BetaAnalyticsData/RunRealtimeReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BetaAnalyticsDataServer is the server API for BetaAnalyticsData service.
type BetaAnalyticsDataServer interface {
	// Returns a customized report of your Google Analytics event data. Reports
	// contain statistics derived from data collected by the Google Analytics
	// tracking code. The data returned from the API is as a table with columns
	// for the requested dimensions and metrics. Metrics are individual
	// measurements of user activity on your property, such as active users or
	// event count. Dimensions break down metrics across some common criteria,
	// such as country or event name.
	RunReport(context.Context, *RunReportRequest) (*RunReportResponse, error)
	// Returns a customized pivot report of your Google Analytics event data.
	// Pivot reports are more advanced and expressive formats than regular
	// reports. In a pivot report, dimensions are only visible if they are
	// included in a pivot. Multiple pivots can be specified to further dissect
	// your data.
	RunPivotReport(context.Context, *RunPivotReportRequest) (*RunPivotReportResponse, error)
	// Returns multiple reports in a batch. All reports must be for the same
	// GA4 Property.
	BatchRunReports(context.Context, *BatchRunReportsRequest) (*BatchRunReportsResponse, error)
	// Returns multiple pivot reports in a batch. All reports must be for the same
	// GA4 Property.
	BatchRunPivotReports(context.Context, *BatchRunPivotReportsRequest) (*BatchRunPivotReportsResponse, error)
	// Returns metadata for dimensions and metrics available in reporting methods.
	// Used to explore the dimensions and metrics. In this method, a Google
	// Analytics GA4 Property Identifier is specified in the request, and
	// the metadata response includes Custom dimensions and metrics as well as
	// Universal metadata.
	//
	// For example if a custom metric with parameter name `levels_unlocked` is
	// registered to a property, the Metadata response will contain
	// `customEvent:levels_unlocked`. Universal metadata are dimensions and
	// metrics applicable to any property such as `country` and `totalUsers`.
	GetMetadata(context.Context, *GetMetadataRequest) (*Metadata, error)
	// The Google Analytics Realtime API returns a customized report of realtime
	// event data for your property. These reports show events and usage from the
	// last 30 minutes.
	RunRealtimeReport(context.Context, *RunRealtimeReportRequest) (*RunRealtimeReportResponse, error)
}

// UnimplementedBetaAnalyticsDataServer can be embedded to have forward compatible implementations.
type UnimplementedBetaAnalyticsDataServer struct {
}

func (*UnimplementedBetaAnalyticsDataServer) RunReport(context.Context, *RunReportRequest) (*RunReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunReport not implemented")
}
func (*UnimplementedBetaAnalyticsDataServer) RunPivotReport(context.Context, *RunPivotReportRequest) (*RunPivotReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunPivotReport not implemented")
}
func (*UnimplementedBetaAnalyticsDataServer) BatchRunReports(context.Context, *BatchRunReportsRequest) (*BatchRunReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRunReports not implemented")
}
func (*UnimplementedBetaAnalyticsDataServer) BatchRunPivotReports(context.Context, *BatchRunPivotReportsRequest) (*BatchRunPivotReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRunPivotReports not implemented")
}
func (*UnimplementedBetaAnalyticsDataServer) GetMetadata(context.Context, *GetMetadataRequest) (*Metadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadata not implemented")
}
func (*UnimplementedBetaAnalyticsDataServer) RunRealtimeReport(context.Context, *RunRealtimeReportRequest) (*RunRealtimeReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunRealtimeReport not implemented")
}

func RegisterBetaAnalyticsDataServer(s *grpc.Server, srv BetaAnalyticsDataServer) {
	s.RegisterService(&_BetaAnalyticsData_serviceDesc, srv)
}

func _BetaAnalyticsData_RunReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BetaAnalyticsDataServer).RunReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1beta.BetaAnalyticsData/RunReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BetaAnalyticsDataServer).RunReport(ctx, req.(*RunReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BetaAnalyticsData_RunPivotReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPivotReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BetaAnalyticsDataServer).RunPivotReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1beta.BetaAnalyticsData/RunPivotReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BetaAnalyticsDataServer).RunPivotReport(ctx, req.(*RunPivotReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BetaAnalyticsData_BatchRunReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRunReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BetaAnalyticsDataServer).BatchRunReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1beta.BetaAnalyticsData/BatchRunReports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BetaAnalyticsDataServer).BatchRunReports(ctx, req.(*BatchRunReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BetaAnalyticsData_BatchRunPivotReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRunPivotReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BetaAnalyticsDataServer).BatchRunPivotReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1beta.BetaAnalyticsData/BatchRunPivotReports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BetaAnalyticsDataServer).BatchRunPivotReports(ctx, req.(*BatchRunPivotReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BetaAnalyticsData_GetMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BetaAnalyticsDataServer).GetMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1beta.BetaAnalyticsData/GetMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BetaAnalyticsDataServer).GetMetadata(ctx, req.(*GetMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BetaAnalyticsData_RunRealtimeReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunRealtimeReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BetaAnalyticsDataServer).RunRealtimeReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1beta.BetaAnalyticsData/RunRealtimeReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BetaAnalyticsDataServer).RunRealtimeReport(ctx, req.(*RunRealtimeReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BetaAnalyticsData_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.analytics.data.v1beta.BetaAnalyticsData",
	HandlerType: (*BetaAnalyticsDataServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RunReport",
			Handler:    _BetaAnalyticsData_RunReport_Handler,
		},
		{
			MethodName: "RunPivotReport",
			Handler:    _BetaAnalyticsData_RunPivotReport_Handler,
		},
		{
			MethodName: "BatchRunReports",
			Handler:    _BetaAnalyticsData_BatchRunReports_Handler,
		},
		{
			MethodName: "BatchRunPivotReports",
			Handler:    _BetaAnalyticsData_BatchRunPivotReports_Handler,
		},
		{
			MethodName: "GetMetadata",
			Handler:    _BetaAnalyticsData_GetMetadata_Handler,
		},
		{
			MethodName: "RunRealtimeReport",
			Handler:    _BetaAnalyticsData_RunRealtimeReport_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/analytics/data/v1beta/analytics_data_api.proto",
}
