
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <gtk/gtk.h>

#include "gamepick.h"
#include "read_line.h"
#include "icons.h"


void game_snap (gamepick_info *info, const game_struct *game)
{
  gtk_combo_box_set_active (GTK_COMBO_BOX (info->fsaa_combo), game->fsaa);
  gtk_combo_box_set_active (GTK_COMBO_BOX (info->aitf_combo), game->aitf);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (info->vsync_check),
    game->syncvblank);
}  


void play_game (GtkWidget *widget, gamepick_info *info)
{
  GString *string;
 
  if (!info->current_game)
  {
    g_print ("Selecting a game would help.\n");
    return;
  }

  string = g_string_new (NULL);
  
  if (text_here (info->current_game->start_dir))
  {
    if (chdir (info->current_game->start_dir->str))
      g_print ("invalid directory: %s\n", info->current_game->start_dir->str);
  }

  g_string_sprintf (string, "%d",
    gtk_combo_box_get_active (GTK_COMBO_BOX (info->fsaa_combo)));
  setenv ("__GL_FSAA_MODE", string->str, 1);
  
  g_string_sprintf (string, "%d",
    gtk_combo_box_get_active (GTK_COMBO_BOX (info->aitf_combo)));
  setenv ("__GL_DEFAULT_LOG_ANISO", string->str, 1);

  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (info->vsync_check)))
    g_string_assign (string, "1");
  else
    g_string_assign (string, "0");
  setenv ("__GL_SYNC_TO_VBLANK", string->str, 1);

  system (info->current_game->cmd->str);

  if (text_here (info->pwd))
  {
    if (chdir (info->pwd->str))
      g_print ("invalid directory: %s\n", info->pwd->str);
  }
}


void reflect_game (gamepick_info *info, game_struct *game)
{
  GtkWidget *hbox, *label, *icon_image;
  gint column;
  
  if (info->current_game)
  {
    gtk_button_set_relief (GTK_BUTTON (info->current_game->button),
      GTK_RELIEF_NONE);
    gtk_widget_destroy (info->play_button);
  }

  info->current_game = game;
  gtk_button_set_relief (GTK_BUTTON (game->button), GTK_RELIEF_NORMAL);
  game_snap (info, game);
  
  hbox = gtk_hbox_new (FALSE, info->button_spacing);
  
  label = gtk_label_new ("Play");
  gtk_box_pack_start_defaults (GTK_BOX (hbox), label);
  gtk_widget_show (label);
  
  if (text_here (game->icon))
  {
    icon_image = scaled_icon (game->icon->str, 14, 14);
    if (icon_image)
    {
      gtk_box_pack_start_defaults (GTK_BOX (hbox), icon_image);
      gtk_widget_show (icon_image);
    }
  }

  gtk_widget_show (hbox);
  column = info->options_enabled == 0 ? 0 : 2;
  
  info->play_button = gtk_button_new();
  gtk_container_add (GTK_CONTAINER (info->play_button), hbox);
  gtk_widget_show (info->play_button);
  gtk_table_attach (GTK_TABLE (info->play_table), info->play_button,
    column, column+1, 0, 1, GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 0);
  g_signal_connect (G_OBJECT (info->play_button), "clicked",
    G_CALLBACK (play_game), info);
}


void click_on_game (GtkWidget *button, game_struct *game)
{
  reflect_game (game->info, game);
}


