## RabbitMQ 4.2.1

RabbitMQ `4.2.1` is a maintenance release in the `4.2.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.2.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.2.0)
in detail if upgrading from a version prior to `4.2.0`.

### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.2.x/release-notes).

### Core Server

#### Bug Fixes

 * Quorum queue at-most-once dead lettering for the overflow behaviour `drop-head` now happens in the correct order.

   GitHub issue: [#14926](https://github.com/rabbitmq/rabbitmq-server/pull/14926)

 * Feature flag state in the registry and on disk were not consistent for a period of time during node boot.

  GitHub issue: [#14943](https://github.com/rabbitmq/rabbitmq-server/pull/14943)


### Stream Plugin

#### Bug Fixes

 * `stream.read_ahead` is a new setting that controls how much data is prefetched from disk
   for stream reads (consumption).

   GitHub issue: [#14948/](https://github.com/rabbitmq/rabbitmq-server/pull/14948)

 * Stream deletion is now more resilient and can handle certain mid-deletion failure scenarios.

   GitHub issue: [#14852](https://github.com/rabbitmq/rabbitmq-server/issues/14852)


### Grafana Dashboards

#### Enhancements

 * The [dashboards](https://grafana.com/orgs/rabbitmq) were updated for RabbitMQ `4.2.x`.

   GitHub issue: [#14849](https://github.com/rabbitmq/rabbitmq-server/pull/14849)


### Management Plugin

#### Enhancements

 * `GET /api/queues/{vhost}` requests no longer perform unnecessary virtual host permission checks
   and log less (at `debug` level) as a result.

   GitHub issue: [#14923](https://github.com/rabbitmq/rabbitmq-server/discussions/14923)


### Shovel Plugin

#### Bug Fixes

 * Improved target node resource alarm handling for AMQP 1.0 and local shovels.

   GitHub issue: [#14886](https://github.com/rabbitmq/rabbitmq-server/pull/14886)

 * Local shovels could run into an exception that would cause a shovel restart.

   GitHub issue: [#14872](https://github.com/rabbitmq/rabbitmq-server/pull/14872)

 * AMQP 1.0 shovels ignored the `sasl` URI parameter.

   GitHub issue: [#14867](https://github.com/rabbitmq/rabbitmq-server/pull/14867)


### OAuth 2 Plugin

#### Bug Fixes

 * A usability improvement allows the plugin to automatically load the trusted system x.509 (TLS) certificates.

   GitHub issue: [#14927](https://github.com/rabbitmq/rabbitmq-server/pull/14927)


### LDAP Plugin

#### Bug Fixes

 * A usability improvement allows the plugin to automatically load the trusted system certificates
   when the user only enables TLS for the LDAP client but does not configure any other settings.

   GitHub issue: [#14937](https://github.com/rabbitmq/rabbitmq-server/pull/14937)


### Dependency Changes

 * `cuttlefish` was upgraded to [`3.6.0`](https://github.com/kyorai/cuttlefish/releases)
