from typing import Any, Protocol
from uuid import UUID

class _Converter(Protocol):
    regex: str
    def __init__(self) -> None: ...
    def to_python(self, value: str) -> Any: ...
    def to_url(self, value: Any) -> str: ...

class IntConverter:
    regex: str
    def to_python(self, value: str) -> int: ...
    def to_url(self, value: str | int) -> str: ...

class StringConverter:
    regex: str
    def to_python(self, value: str) -> str: ...
    def to_url(self, value: str) -> str: ...

class UUIDConverter:
    regex: str
    def to_python(self, value: str) -> UUID: ...
    def to_url(self, value: str | UUID) -> str: ...

class SlugConverter(StringConverter): ...
class PathConverter(StringConverter): ...

DEFAULT_CONVERTERS: dict[str, _Converter]
REGISTERED_CONVERTERS: dict[str, _Converter]

def register_converter(converter: type[_Converter], type_name: str) -> None: ...
def get_converters() -> dict[str, _Converter]: ...
def get_converter(raw_converter: str) -> _Converter: ...
