/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.server;

import com.intellij.station.comms.common.ServicesServerHostApplication;
import com.intellij.station.comms.common.netty.server.RootHandler;
import com.intellij.station.comms.common.netty.util.ExtensionsKt;
import com.intellij.station.comms.common.netty.util.NettyThreadFactory;
import com.intellij.station.comms.common.utils.Logging;
import com.intellij.station.comms.common.utils.StationConstants;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerDomainSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/station/comms/common/netty/server/NettyServicesServerBase;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "hostApplication", "Lcom/intellij/station/comms/common/ServicesServerHostApplication;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/station/comms/common/ServicesServerHostApplication;)V", "runningStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "isRunning", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "eventLoop", "Lio/netty/channel/MultiThreadIoEventLoopGroup;", "Companion", "intellij.station.comms.common"})
@SourceDebugExtension(value={"SMAP\nNettyServicesServerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyServicesServerBase.kt\ncom/intellij/station/comms/common/netty/server/NettyServicesServerBase\n+ 2 Logging.kt\ncom/intellij/station/comms/common/utils/Logging\n*L\n1#1,104:1\n7#2:105\n*S KotlinDebug\n*F\n+ 1 NettyServicesServerBase.kt\ncom/intellij/station/comms/common/netty/server/NettyServicesServerBase\n*L\n28#1:105\n*E\n"})
public final class NettyServicesServerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ServicesServerHostApplication hostApplication;
    @NotNull
    private final MutableStateFlow<Boolean> runningStateFlow;
    @NotNull
    private final StateFlow<Boolean> isRunning;
    @NotNull
    private final MultiThreadIoEventLoopGroup eventLoop;
    public static final int MAX_CONTENT_LENGTH_BYTES = 0xA00000;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final AttributeKey<ChannelHandler> DEFAULT_HANDLER;
    @NotNull
    private static final AtomicInteger serversCounter;

    public NettyServicesServerBase(@NotNull CoroutineScope scope, @NotNull ServicesServerHostApplication hostApplication) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)hostApplication, (String)"hostApplication");
        this.scope = scope;
        this.hostApplication = hostApplication;
        this.runningStateFlow = StateFlowKt.MutableStateFlow((Object)false);
        this.isRunning = (StateFlow)this.runningStateFlow;
        this.eventLoop = new MultiThreadIoEventLoopGroup(3, (ThreadFactory)new NettyThreadFactory("Netty Station Server", serversCounter), NioIoHandler.newFactory((SelectorProvider)SelectorProvider.provider()));
        UnixDomainSocketAddress endpoint = this.hostApplication.getBindAddress();
        UnixDomainSocketAddress linkAddress = this.hostApplication.getAdditionalLinkAddress();
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwx------");
        logger.info("Starting services server on " + endpoint.getPath());
        Files.deleteIfExists(endpoint.getPath());
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, endpoint, permissions, linkAddress, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NettyServicesServerBase this$0;
            final /* synthetic */ UnixDomainSocketAddress $endpoint;
            final /* synthetic */ Set<PosixFilePermission> $permissions;
            final /* synthetic */ UnixDomainSocketAddress $linkAddress;
            {
                this.this$0 = $receiver;
                this.$endpoint = $endpoint;
                this.$permissions = $permissions;
                this.$linkAddress = $linkAddress;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)NettyServicesServerBase.access$getEventLoop$p(this.this$0)).channel(NioServerDomainSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(NettyServicesServerBase.class, LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<NioDomainSocketChannel>(this.this$0){
                            final /* synthetic */ NettyServicesServerBase this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            protected void initChannel(NioDomainSocketChannel ch) {
                                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                                ChannelPipeline pipeline = ch.pipeline();
                                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpServerCodec()};
                                pipeline.addLast(channelHandlerArray);
                                channelHandlerArray = new ChannelHandler[]{new HttpObjectAggregator(0xA00000)};
                                pipeline.addLast(channelHandlerArray);
                                RootHandler defaultHandler = new RootHandler(NettyServicesServerBase.access$getScope$p(this.this$0), NettyServicesServerBase.access$getHostApplication$p(this.this$0));
                                ChannelHandler[] channelHandlerArray2 = new ChannelHandler[]{defaultHandler};
                                pipeline.addLast(channelHandlerArray2);
                                pipeline.channel().attr(NettyServicesServerBase.Companion.getDEFAULT_HANDLER()).set((Object)((Object)defaultHandler));
                            }
                        });
                        channel = null;
                        var5_6 = bootstrap.bind((SocketAddress)this.$endpoint);
                        Intrinsics.checkNotNullExpressionValue((Object)var5_6, (String)"bind(...)");
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = ExtensionsKt.awaitSuspend(var5_6, (Continuation<? super Channel>)((Continuation)this));
                        ** if (v0 != var9_2) goto lbl17
lbl16:
                        // 1 sources

                        return var9_2;
lbl17:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        channel = null;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        channel = (Channel)v0;
                        if (StationConstants.INSTANCE.isLinux()) {
                            try {
                                Files.setPosixFilePermissions(this.$endpoint.getPath(), this.$permissions);
                            }
                            catch (UnsupportedOperationException ex) {
                                NettyServicesServerBase.access$getLogger$cp().debug("POSIX permissions are not supported", (Throwable)ex);
                            }
                            catch (Exception ex) {
                                CoroutineScopeKt.ensureActive((CoroutineScope)$this$launch);
                                NettyServicesServerBase.access$getLogger$cp().error("Unable to set station socket permissions:", (Throwable)ex);
                            }
                        }
                        NettyServicesServerBase.access$getLogger$cp().info("Services server started");
                        NettyServicesServerBase.access$getRunningStateFlow$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                        channel.closeFuture().addListener((GenericFutureListener)LambdaMetafactory.metafactory(null, null, null, (Lio/netty/util/concurrent/Future;)V, invokeSuspend$lambda$0(com.intellij.station.comms.common.netty.server.NettyServicesServerBase io.netty.util.concurrent.Future ), (Lio/netty/util/concurrent/Future;)V)((NettyServicesServerBase)this.this$0));
                        if (this.$linkAddress != null) {
                            try {
                                Files.deleteIfExists(this.$linkAddress.getPath());
                                Files.createSymbolicLink(this.$linkAddress.getPath(), this.$endpoint.getPath(), new FileAttribute[0]);
                            }
                            catch (Exception ex) {
                                NettyServicesServerBase.access$getLogger$cp().warn("Unable to create link " + this.$linkAddress.getPath() + " -> " + this.$endpoint.getPath(), (Throwable)ex);
                            }
                        }
                        this.L$0 = channel;
                        this.label = 2;
                        v1 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                        ** if (v1 != var9_2) goto lbl57
lbl56:
                        // 1 sources

                        return var9_2;
lbl57:
                        // 1 sources

                        ** GOTO lbl64
                    }
                    case 2: {
                        channel = (Channel)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl64:
                            // 2 sources

                            throw new KotlinNothingValueException();
                        }
                        catch (Throwable var5_7) {
                            NettyServicesServerBase.access$getLogger$cp().info("Shutting down services server");
                            v2 = channel;
                            if (v2 != null) {
                                v2.close();
                            }
                            NettyServicesServerBase.access$getEventLoop$p(this.this$0).shutdownGracefully().await();
                            Files.deleteIfExists(this.$endpoint.getPath());
                            v3 = this.$linkAddress;
                            if (v3 != null) {
                                it = v3;
                                $i$a$-let-NettyServicesServerBase$1$2 = false;
                                Boxing.boxBoolean((boolean)Files.deleteIfExists(it.getPath()));
                            }
                            throw var5_7;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(NettyServicesServerBase this$0, Future it) {
                logger.info("Services server shut down");
                this$0.runningStateFlow.setValue((Object)false);
            }
        }), (int)3, null);
    }

    @NotNull
    public final StateFlow<Boolean> isRunning() {
        return this.isRunning;
    }

    public static final /* synthetic */ MultiThreadIoEventLoopGroup access$getEventLoop$p(NettyServicesServerBase $this) {
        return $this.eventLoop;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(NettyServicesServerBase $this) {
        return $this.scope;
    }

    public static final /* synthetic */ ServicesServerHostApplication access$getHostApplication$p(NettyServicesServerBase $this) {
        return $this.hostApplication;
    }

    static {
        Logging logging = Logging.INSTANCE;
        Companion $this$myLogger$iv = Companion;
        boolean $i$f$myLogger = false;
        Logger logger = LoggerFactory.getLogger(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        NettyServicesServerBase.logger = logger;
        AttributeKey attributeKey = AttributeKey.valueOf((String)"default.channel.handler");
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"valueOf(...)");
        DEFAULT_HANDLER = attributeKey;
        serversCounter = new AtomicInteger();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/station/comms/common/netty/server/NettyServicesServerBase$Companion;", "", "<init>", "()V", "MAX_CONTENT_LENGTH_BYTES", "", "logger", "Lorg/slf4j/Logger;", "DEFAULT_HANDLER", "Lio/netty/util/AttributeKey;", "Lio/netty/channel/ChannelHandler;", "getDEFAULT_HANDLER", "()Lio/netty/util/AttributeKey;", "serversCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "intellij.station.comms.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeKey<ChannelHandler> getDEFAULT_HANDLER() {
            return DEFAULT_HANDLER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

