/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.providers.execution;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.utils.JupyterEditorCellExtensionsKt;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListeners;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.EditorNotebookExtension;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.time.ZonedDateTime;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/providers/execution/NotebookEditorCellExecutionDetector;", "Lcom/intellij/notebooks/visualization/EditorNotebookExtension;", "Lcom/intellij/openapi/Disposable$Default;", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;)V", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "onCellCreated", "", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "recalculateStatus", "updateInterval", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "Companion", "intellij.jupyter.core"})
public final class NotebookEditorCellExecutionDetector
implements EditorNotebookExtension,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotebookCellInlayManager manager;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Project project;

    public NotebookEditorCellExecutionDetector(@NotNull NotebookCellInlayManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.editor = this.manager.getEditor();
        Project project = this.editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        this.project = project;
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)this.editor);
        Intrinsics.checkNotNull((Object)jupyterNotebook);
        JupyterListeners listeners = jupyterNotebook.getListeners();
        CellExecutionListener listener2 = new CellExecutionListener(this){
            final /* synthetic */ NotebookEditorCellExecutionDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public void cellExecuted(JupyterNotebook notebook, NotebookIntervalPointer cell) {
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cell);
            }

            public void executionSubmitted(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cellPointer);
            }

            public void executionStarted(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, ZonedDateTime startTime) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cellPointer);
            }

            public void executionStopped(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, JupyterExecutionStatus jupyterStatus, ZonedDateTime endTime) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
                Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cellPointer);
            }

            public void executionStatusReset(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cellPointer);
            }
        };
        listeners.getCellExecutionListeners().addListener((EventListener)listener2, (Disposable)this);
    }

    public void onCellCreated(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.recalculateStatus(cell);
    }

    private final void recalculateStatus(EditorCell cell) {
        JupyterCell jupyterCell = JupyterEditorCellExtensionsKt.getJupyterCell(cell);
        if (jupyterCell == null) {
            return;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        ProgressStatus progressStatus = JupyterInlayProgressStatusManager.Companion.getInstance(this.project).getProgressStatus(cell.getIntervalPointer());
        ZonedDateTime executionStartTime = jupyterCell2.getExecutionStartTime();
        ZonedDateTime executionEndTime = jupyterCell2.getExecutionEndTime();
        Integer n = jupyterCell2.getExecutionCount();
        EditorCell.ExecutionStatus status = new EditorCell.ExecutionStatus(progressStatus, n, executionStartTime, executionEndTime);
        cell.getExecutionStatus().set((Object)status);
    }

    private final void updateInterval(NotebookIntervalPointer cellPointer) {
        EditorCell editorCell = this.manager.getCell(cellPointer);
        this.recalculateStatus(editorCell);
    }

    public static final /* synthetic */ void access$updateInterval(NotebookEditorCellExecutionDetector $this, NotebookIntervalPointer cellPointer) {
        $this.updateInterval(cellPointer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/providers/execution/NotebookEditorCellExecutionDetector$Companion;", "", "<init>", "()V", "install", "", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull NotebookCellInlayManager manager) {
            NotebookEditorCellExecutionDetector notebookEditorCellExecutionDetector;
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            NotebookEditorCellExecutionDetector it = notebookEditorCellExecutionDetector = new NotebookEditorCellExecutionDetector(manager);
            boolean bl = false;
            Disposer.register((Disposable)((Disposable)manager), (Disposable)((Disposable)it));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

