/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.impl.statistics.RunConfigurationTypeUsagesCollector;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class RunDashboardUsagesCollector
extends ProjectUsagesCollector {
    public static final EventLogGroup GROUP = new EventLogGroup("run.dashboard", 5);
    public static final EventId1<Boolean> RUN_DASHBOARD = GROUP.registerEvent("run.dashboard", (EventField)EventFields.Boolean((String)"enabled"));
    public static final VarargEventId ADDED_RUN_CONFIGURATION = GROUP.registerVarargEvent("added.run.configuration", new EventField[]{RunConfigurationTypeUsagesCollector.ID_FIELD});
    public static final VarargEventId REMOVED_RUN_CONFIGURATION = GROUP.registerVarargEvent("removed.run.configuration", new EventField[]{RunConfigurationTypeUsagesCollector.ID_FIELD});

    RunDashboardUsagesCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        List data;
        ConfigurationType configurationType;
        List configurationTypes;
        if (project == null) {
            RunDashboardUsagesCollector.$$$reportNull$$$0(0);
        }
        HashSet<MetricEvent> metricEvents = new HashSet<MetricEvent>();
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
        HashSet<String> dashboardTypes = new HashSet<String>(runDashboardManager.getTypes());
        HashSet<String> removedDefaultType = new HashSet<String>(runDashboardManager.getEnableByDefaultTypes());
        dashboardTypes.removeAll(removedDefaultType);
        removedDefaultType.removeAll(runDashboardManager.getTypes());
        metricEvents.add(RUN_DASHBOARD.metric((Object)(!dashboardTypes.isEmpty() ? 1 : 0)));
        if (!dashboardTypes.isEmpty()) {
            configurationTypes = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
            for (String dashboardType : dashboardTypes) {
                configurationType = (ConfigurationType)ContainerUtil.find((Iterable)configurationTypes, type -> type.getId().equals(dashboardType));
                if (configurationType == null) continue;
                data = RunConfigurationTypeUsagesCollector.createFeatureUsageData((ConfigurationType)configurationType, null);
                metricEvents.add(ADDED_RUN_CONFIGURATION.metric(data));
            }
        }
        if (!removedDefaultType.isEmpty()) {
            configurationTypes = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
            for (String removedType : removedDefaultType) {
                configurationType = (ConfigurationType)ContainerUtil.find((Iterable)configurationTypes, type -> type.getId().equals(removedType));
                if (configurationType == null) continue;
                data = RunConfigurationTypeUsagesCollector.createFeatureUsageData((ConfigurationType)configurationType, null);
                metricEvents.add(REMOVED_RUN_CONFIGURATION.metric(data));
            }
        }
        HashSet<MetricEvent> hashSet = metricEvents;
        if (hashSet == null) {
            RunDashboardUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class RunConfigurationTypeValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "run_config";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                RunConfigurationTypeValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RunConfigurationTypeValidator.$$$reportNull$$$0(1);
            }
            if (RunConfigurationTypeValidator.isThirdPartyValue((String)data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    RunConfigurationTypeValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ConfigurationType configurationType = RunConfigurationTypeValidator.findConfigurationTypeById(data);
            if (configurationType == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    RunConfigurationTypeValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = PluginInfoDetectorKt.getPluginInfo(configurationType.getClass()).isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                RunConfigurationTypeValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static ConfigurationType findConfigurationTypeById(@NotNull String data) {
            if (data == null) {
                RunConfigurationTypeValidator.$$$reportNull$$$0(5);
            }
            return (ConfigurationType)ContainerUtil.find((Iterable)ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList(), type -> type.getId().equals(data));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardUsagesCollector$RunConfigurationTypeValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardUsagesCollector$RunConfigurationTypeValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findConfigurationTypeById";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

