/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.BundleBase;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.IdeValidationHost;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.PsiReferenceWithUnresolvedQuickFixes;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.markup.UnmodifiableTextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.AnchorReference;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlHighlightVisitor
extends XmlElementVisitor
implements HighlightVisitor,
IdeValidationHost {
    private static final Logger LOG = Logger.getInstance(XmlHighlightVisitor.class);
    private static boolean ourDoJaxpTesting;
    private boolean myHasError;
    private HighlightInfoHolder myHolder;

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(0);
        }
        this.myHasError = false;
        element.accept((PsiElementVisitor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (file == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(2);
        }
        if (action == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(3);
        }
        this.myHolder = holder;
        try {
            action.run();
        }
        finally {
            this.myHolder = null;
        }
        return true;
    }

    private boolean add(@Nullable HighlightInfo info) {
        if (info != null) {
            if (info.getSeverity().compareTo(HighlightSeverity.ERROR) >= 0) {
                this.myHasError = true;
            }
            return this.myHolder.add(info);
        }
        return false;
    }

    @Contract(pure=true)
    private boolean hasErrorResults() {
        return this.myHasError;
    }

    private void addElementsForTagWithManyQuickFixes(XmlTag tag, @NotNull @InspectionMessage String localizedMessage, HighlightInfoType type, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(4);
        }
        XmlToken childByRole = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        this.bindMessageToAstNode((PsiElement)childByRole, type, localizedMessage, quickFixActions);
        childByRole = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
        this.bindMessageToAstNode((PsiElement)childByRole, type, localizedMessage, quickFixActions);
    }

    public void visitXmlToken(@NotNull XmlToken token) {
        XmlTag tag;
        String marker;
        String s;
        int i;
        IElementType tokenType;
        if (token == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(5);
        }
        if ((tokenType = token.getTokenType()) == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME) {
            PsiElement element = token.getPrevSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getPrevSibling();
            }
            if (element instanceof XmlToken) {
                PsiElement parent;
                if (((XmlToken)element).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element.getParent()) instanceof XmlTag && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkTag((XmlTag)parent);
                }
            } else {
                PsiElement parent = token.getParent();
                if (parent instanceof XmlAttribute && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkAttribute((XmlAttribute)parent);
                }
            }
        } else if (tokenType == XmlTokenType.XML_DATA_CHARACTERS && token.getParent() instanceof XmlText && token.textContains(']') && token.textContains('>') && (i = (s = token.getText()).indexOf(marker = "]]>")) != -1 && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)token, XmlTag.class)) != null && XmlExtension.getExtensionByElement((PsiElement)tag).shouldBeHighlightedAsTag(tag) && !XmlHighlightVisitor.skipValidation((PsiElement)tag) && !(tag instanceof HtmlTag)) {
            TextRange textRange = token.getTextRange();
            int start2 = textRange.getStartOffset() + i;
            HighlightInfoType type = HighlightInfoType.ERROR;
            String description = XmlAnalysisBundle.message((String)"xml.inspections.cdata.end.should.not.appear.in.content", (Object[])new Object[0]);
            this.add(HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(start2, start2 + marker.length()).descriptionAndTooltip(description).create());
        }
    }

    private void checkTag(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(6);
        }
        if (ourDoJaxpTesting) {
            return;
        }
        if (!this.hasErrorResults()) {
            this.checkTagByDescriptor(tag);
        }
        if (!this.hasErrorResults() && !XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (tag instanceof HtmlTag && (descriptor instanceof AnyXmlElementDescriptor || descriptor == null)) {
                return;
            }
            this.checkReferences((PsiElement)tag);
        }
    }

    public void visitXmlProcessingInstruction(@NotNull XmlProcessingInstruction processingInstruction) {
        if (processingInstruction == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(7);
        }
        super.visitXmlProcessingInstruction(processingInstruction);
        PsiElement parent = processingInstruction.getParent();
        if (parent instanceof XmlProlog && processingInstruction.getText().startsWith("<?xml ")) {
            PsiElement e = PsiTreeUtil.prevLeaf((PsiElement)processingInstruction);
            while (e != null) {
                if (!(e instanceof PsiWhiteSpace && PsiTreeUtil.prevLeaf((PsiElement)e) != null || e instanceof OuterLanguageElement)) {
                    PsiElement eParent = e.getParent();
                    if (eParent instanceof PsiComment) {
                        e = eParent;
                    }
                    if (eParent instanceof XmlProcessingInstruction) break;
                    String description = XmlAnalysisBundle.message((String)"xml.inspections.xml.declaration.should.precede.all.document.content", (Object[])new Object[0]);
                    this.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(e).descriptionAndTooltip(description).create());
                }
                e = PsiTreeUtil.prevLeaf((PsiElement)e);
            }
        }
        this.checkReferences((PsiElement)processingInstruction);
    }

    private void bindMessageToAstNode(PsiElement childByRole, HighlightInfoType warning, @NotNull @InspectionMessage String localizedMessage, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(8);
        }
        if (childByRole != null) {
            TextRange textRange = childByRole.getTextRange();
            int length = textRange.getLength();
            int startOffset = textRange.getStartOffset();
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)warning).range(childByRole, startOffset, startOffset + length).descriptionAndTooltip(localizedMessage);
            for (IntentionAction quickFixAction : quickFixActions) {
                builder2.registerFix(quickFixAction, null, null, textRange, null);
            }
            HighlightInfo highlightInfo = builder2.create();
            if (highlightInfo == null) {
                builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)warning).range(new TextRange(startOffset, startOffset + length)).textAttributes(Holder.NONEMPTY_TEXT_ATTRIBUTES);
                for (IntentionAction quickFixAction : quickFixActions) {
                    builder2.registerFix(quickFixAction, null, null, textRange, null);
                }
                highlightInfo = builder2.descriptionAndTooltip(localizedMessage).create();
            }
            this.add(highlightInfo);
        }
    }

    private void checkTagByDescriptor(XmlTag tag) {
        XmlElementDescriptor elementDescriptor;
        String name = tag.getName();
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)parent;
            elementDescriptor = XmlUtil.getDescriptorFromContext(tag);
            XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
            if (parentDescriptor != null && elementDescriptor == null && XmlHighlightVisitor.shouldBeValidated(tag)) {
                if (tag instanceof HtmlTag) {
                    return;
                }
                HighlightInfoType type = XmlHighlightVisitor.getTagProblemInfoType(tag);
                this.addElementsForTagWithManyQuickFixes(tag, XmlAnalysisBundle.message((String)"xml.inspections.element.is.not.allowed.here", (Object[])new Object[]{name}), type, new IntentionAction[0]);
                return;
            }
            if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
                elementDescriptor = tag.getDescriptor();
            }
            if (elementDescriptor == null) {
                return;
            }
        } else {
            elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null) {
                this.addElementsForTagWithManyQuickFixes(tag, XmlAnalysisBundle.message((String)"xml.inspections.element.must.be.declared", (Object[])new Object[]{name}), HighlightInfoType.WRONG_REF, new IntentionAction[0]);
                return;
            }
        }
        if (elementDescriptor instanceof Validator) {
            ((Validator)elementDescriptor).validate((PsiElement)tag, (Validator.ValidationHost)this);
        }
    }

    private static HighlightInfoType getTagProblemInfoType(XmlTag tag) {
        if (tag instanceof HtmlTag && "http://www.w3.org/1999/html".equals(tag.getNamespace())) {
            if (XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)tag)) {
                return HighlightInfoType.INFORMATION;
            }
            return HighlightInfoType.WARNING;
        }
        return HighlightInfoType.WRONG_REF;
    }

    public static boolean isInjectedWithoutValidation(PsiElement element) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        return injectedLanguageManager.isFrankensteinInjection(element) || injectedLanguageManager.shouldInspectionsBeLenient(element);
    }

    public static boolean skipValidation(PsiElement context) {
        return context instanceof XmlElement && ((XmlElement)context).skipValidation();
    }

    public static void setSkipValidation(@NotNull PsiElement element) {
        if (element == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(9);
        }
        element.putUserData(XmlElement.DO_NOT_VALIDATE, (Object)Boolean.TRUE);
    }

    public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(10);
        }
    }

    private void checkAttribute(XmlAttribute attribute) {
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            return;
        }
        String name = attribute.getName();
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)attribute);
        if (!(prevLeaf instanceof PsiWhiteSpace || tag instanceof HtmlTag && XmlUtil.hasNonEditableInjectionFragmentAt(attribute, attribute.getTextOffset()))) {
            TextRange textRange = attribute.getTextRange();
            HighlightInfoType type = tag instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            String description = XmlAnalysisBundle.message((String)"xml.inspections.attribute.should.be.preceded.with.space", (Object[])new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(textRange.getStartOffset(), textRange.getStartOffset()).descriptionAndTooltip(description).create();
            this.add(info);
        }
        if (attribute.isNamespaceDeclaration() || "http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespace())) {
            return;
        }
        XmlElementDescriptor elementDescriptor = tag.getDescriptor();
        if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor || ourDoJaxpTesting) {
            return;
        }
        XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
        if (attributeDescriptor == null) {
            if (!XmlUtil.attributeFromTemplateFramework(name, tag)) {
                String localizedMessage = XmlAnalysisBundle.message((String)"xml.inspections.attribute.is.not.allowed.here", (Object[])new Object[]{name});
                this.reportAttributeProblem(tag, name, attribute, localizedMessage);
            }
        } else {
            this.checkDuplicateAttribute(tag, attribute);
            PsiReference[] attrRefs = attribute.getReferences();
            this.doCheckRefs((PsiElement)attribute, attrRefs, !attribute.getNamespacePrefix().isEmpty() ? 2 : 1);
        }
    }

    private void reportAttributeProblem(XmlTag tag, String localName, XmlAttribute attribute, @NotNull @InspectionMessage String localizedMessage) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(11);
        }
        RemoveAttributeIntentionFix removeAttributeIntention = new RemoveAttributeIntentionFix(localName);
        if (tag instanceof HtmlTag) {
            return;
        }
        HighlightInfoType tagProblemInfoType = HighlightInfoType.WRONG_REF;
        ASTNode node = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
        assert (node != null);
        ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
        assert (child != null);
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)tagProblemInfoType).range(child).descriptionAndTooltip(localizedMessage).registerFix((IntentionAction)removeAttributeIntention, List.of(), null, null, null);
        PsiFile file = tag.getContainingFile();
        if (file != null) {
            for (XmlUndefinedElementFixProvider fixProvider : XmlUndefinedElementFixProvider.EP_NAME.getExtensionList()) {
                IntentionAction[] fixes = fixProvider.createFixes(attribute);
                if (fixes == null) continue;
                for (IntentionAction action : fixes) {
                    builder2.registerFix(action, null, null, null, null);
                }
            }
        }
        HighlightInfo highlightInfo = builder2.create();
        this.add(highlightInfo);
    }

    private void checkDuplicateAttribute(XmlTag tag, XmlAttribute attribute) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            return;
        }
        XmlAttribute[] attributes = tag.getAttributes();
        PsiFile containingFile = tag.getContainingFile();
        XmlExtension extension = containingFile instanceof XmlFile ? XmlExtension.getExtension(containingFile) : DefaultXmlExtension.DEFAULT_EXTENSION;
        for (XmlAttribute tagAttribute : attributes) {
            ProgressManager.checkCanceled();
            if (attribute == tagAttribute || !Comparing.strEqual((String)attribute.getName(), (String)tagAttribute.getName())) continue;
            String localName = attribute.getLocalName();
            if (extension.canBeDuplicated(tagAttribute)) continue;
            ASTNode attributeNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
            assert (attributeNode != null);
            ASTNode attributeNameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attributeNode);
            assert (attributeNameNode != null);
            RemoveAttributeIntentionFix intentionAction = new RemoveAttributeIntentionFix(localName);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)XmlHighlightVisitor.getTagProblemInfoType(tag)).range(attributeNameNode).registerFix((IntentionAction)intentionAction, List.of(), null, null, null).descriptionAndTooltip(XmlAnalysisBundle.message((String)"xml.inspections.duplicate.attribute", (Object[])new Object[]{localName})).create();
            this.add(highlightInfo);
        }
    }

    public void visitXmlDocument(@NotNull XmlDocument document) {
        PsiMetaData psiMetaData;
        if (document == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(12);
        }
        if (document.getLanguage() == DTDLanguage.INSTANCE && (psiMetaData = document.getMetaData()) instanceof Validator) {
            ((Validator)psiMetaData).validate((PsiElement)document, (Validator.ValidationHost)this);
        }
    }

    public void visitXmlTag(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(13);
        }
    }

    public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
        String error;
        if (value == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(14);
        }
        this.checkReferences((PsiElement)value);
        PsiElement parent = value.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return;
        }
        XmlAttribute attribute = (XmlAttribute)parent;
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            LOG.error("Missing tag for attribute: " + attribute.getName(), new Attachment[]{new Attachment(this.myHolder.getContextFile().getName(), this.myHolder.getContextFile().getText())});
            return;
        }
        XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
        if (attributeDescriptor != null && !XmlHighlightVisitor.skipValidation((PsiElement)value) && (error = attributeDescriptor.validateValue((XmlElement)value, attribute.getValue())) != null) {
            HighlightInfoType type = XmlHighlightVisitor.getTagProblemInfoType(tag);
            if (error.startsWith("<html>")) {
                this.add(HighlightInfo.newHighlightInfo((HighlightInfoType)type).range((PsiElement)value).description(StringUtil.removeHtmlTags((String)error).replace("\n", " ")).escapedToolTip(error).create());
            } else {
                this.add(HighlightInfo.newHighlightInfo((HighlightInfoType)type).range((PsiElement)value).descriptionAndTooltip(error).create());
            }
        }
    }

    private void checkReferences(PsiElement value) {
        if (value == null) {
            return;
        }
        this.doCheckRefs(value, value.getReferences(), 0);
    }

    private void doCheckRefs(@NotNull PsiElement value, PsiReference @NotNull [] references, int start2) {
        if (value == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(15);
        }
        if (references == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(16);
        }
        for (int i = start2; i < references.length; ++i) {
            LocalQuickFix[] fixes;
            PsiElement parent;
            PsiReference reference = references[i];
            ProgressManager.checkCanceled();
            if (!XmlHighlightVisitor.shouldCheckResolve(reference) || !XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
            String description = XmlHighlightVisitor.getErrorDescription(reference);
            int startOffset = reference.getElement().getTextRange().getStartOffset();
            TextRange referenceRange = reference.getRangeInElement();
            if (referenceRange.getStartOffset() > referenceRange.getEndOffset()) {
                LOG.error("Reference range start offset > end offset:  " + String.valueOf(reference) + ", start offset: " + referenceRange.getStartOffset() + ", end offset: " + referenceRange.getEndOffset());
            }
            HighlightInfoType type = XmlHighlightVisitor.getTagProblemInfoType((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class));
            if (value instanceof XmlAttributeValue && (parent = value.getParent()) instanceof XmlAttribute) {
                String name = StringUtil.toLowerCase((String)((XmlAttribute)parent).getName());
                if (type.getSeverity(null).compareTo(HighlightInfoType.WARNING.getSeverity(null)) > 0 && name.endsWith("stylename")) {
                    type = HighlightInfoType.WARNING;
                }
            }
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(startOffset + referenceRange.getStartOffset(), startOffset + referenceRange.getEndOffset()).descriptionAndTooltip(description);
            if (reference instanceof LocalQuickFixProvider && (fixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
                InspectionManager manager = InspectionManager.getInstance((Project)reference.getElement().getProject());
                for (LocalQuickFix fix : fixes) {
                    ProblemDescriptor descriptor = manager.createProblemDescriptor(value, description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true);
                    builder2.registerFix(QuickFixWrapper.wrap((ProblemDescriptor)descriptor, (LocalQuickFix)fix), null, null, null, null);
                }
            }
            UnresolvedReferenceQuickFixProvider.registerUnresolvedReferenceLazyQuickFixes((PsiReference)reference, (HighlightInfo.Builder)builder2);
            this.add(builder2.create());
        }
    }

    static boolean shouldCheckResolve(PsiReference reference) {
        return reference instanceof TypeOrElementOrAttributeReference || reference instanceof DependentNSReference || reference instanceof URLReference || reference instanceof TagNameReference || reference instanceof PsiReferenceWithUnresolvedQuickFixes;
    }

    static boolean isUrlReference(PsiReference reference) {
        return reference instanceof FileReferenceOwner || reference instanceof AnchorReference || reference instanceof PsiFileReference;
    }

    @NotNull
    @InspectionMessage
    public static String getErrorDescription(@NotNull PsiReference reference) {
        String description;
        if (reference == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(17);
        }
        @InspectionMessage String message = reference instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern() : AnalysisBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
        try {
            description = BundleBase.format((String)message, (Object[])new Object[]{reference.getCanonicalText()});
        }
        catch (IllegalArgumentException ex) {
            description = message;
        }
        String string = description;
        if (string == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static boolean hasBadResolve(PsiReference reference, boolean checkSoft) {
        if (!checkSoft && reference.isSoft()) {
            return false;
        }
        if (reference instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference).multiResolve(false).length == 0;
        }
        return reference.resolve() == null;
    }

    public void visitXmlDoctype(@NotNull XmlDoctype xmlDoctype) {
        if (xmlDoctype == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(19);
        }
        if (XmlHighlightVisitor.skipValidation((PsiElement)xmlDoctype)) {
            return;
        }
        this.checkReferences((PsiElement)xmlDoctype);
    }

    public static void setDoJaxpTesting(boolean doJaxpTesting) {
        ourDoJaxpTesting = doJaxpTesting;
    }

    public void addMessage(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type) {
        if (type == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(20);
        }
        this.addMessageWithFixes(context, message, type, new IntentionAction[0]);
    }

    public void addMessageWithFixes(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type, IntentionAction ... fixes) {
        if (type == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(21);
        }
        if (fixes == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(22);
        }
        if (message != null && !message.isEmpty()) {
            HighlightInfoType defaultInfoType;
            PsiFile containingFile = context.getContainingFile();
            HighlightInfoType highlightInfoType = type == Validator.ValidationHost.ErrorType.ERROR ? HighlightInfoType.ERROR : (defaultInfoType = type == Validator.ValidationHost.ErrorType.WARNING ? HighlightInfoType.WARNING : HighlightInfoType.WEAK_WARNING);
            if (context instanceof XmlTag && XmlExtension.getExtension(containingFile).shouldBeHighlightedAsTag((XmlTag)context)) {
                this.addElementsForTagWithManyQuickFixes((XmlTag)context, message, defaultInfoType, fixes);
            } else {
                HighlightInfo.Builder builder2;
                PsiLanguageInjectionHost contextOfFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
                if (contextOfFile != null) {
                    TextRange range = InjectedLanguageManager.getInstance((Project)context.getProject()).injectedToHost(context, context.getTextRange());
                    builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)defaultInfoType).range(range).descriptionAndTooltip(message);
                } else {
                    builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(context).descriptionAndTooltip(message);
                }
                for (IntentionAction quickFixAction : fixes) {
                    if (quickFixAction == null) continue;
                    builder2.registerFix(quickFixAction, null, null, null, null);
                }
                this.add(builder2.create());
            }
        }
    }

    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(23);
        }
        return file instanceof XmlFile || XmlTagTreeHighlightingUtil.hasXmlViewProvider(file);
    }

    @NotNull
    public HighlightVisitor clone() {
        return new XmlHighlightVisitor();
    }

    public static String getUnquotedValue(XmlAttributeValue value, XmlTag tag) {
        String unquotedValue = value.getValue();
        if (tag instanceof HtmlTag) {
            unquotedValue = StringUtil.toLowerCase((String)unquotedValue);
        }
        return unquotedValue;
    }

    public static boolean shouldBeValidated(@NotNull XmlTag tag) {
        PsiElement parent;
        if (tag == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(24);
        }
        if ((parent = tag.getParent()) instanceof XmlTag) {
            return !XmlHighlightVisitor.skipValidation(parent) && !XmlUtil.tagFromTemplateFramework(tag);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 6: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingInstruction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDoctype";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addElementsForTagWithManyQuickFixes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitXmlToken";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitXmlProcessingInstruction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindMessageToAstNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSkipValidation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitXmlAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportAttributeProblem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitXmlDocument";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitXmlTag";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitXmlAttributeValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCheckRefs";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescription";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitXmlDoctype";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addMessageWithFixes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeValidated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }

    private static class Holder {
        private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES = new UnmodifiableTextAttributes(){

            public boolean isEmpty() {
                return false;
            }
        };

        private Holder() {
        }
    }
}

