---
name: Feature Request
about: Want us to add something to kv-log-macro?
---

# Feature Request
## Summary
One paragraph explanation of the feature.

## Motivation
Why are we doing this? What use cases does it support? What is the expected
outcome?

## Guide-level explanation
Explain the proposal as if it was already included in the project and you
were teaching it to another programmer. That generally means:

- Introducing new named concepts.
- Explaining the feature largely in terms of examples.
- If applicable, provide sample error messages, deprecation warnings, or
  migration guidance.

## Reference-level explanation
This is the technical portion of the feature request. Explain the design in
sufficient detail that:

- Its interaction with other features is clear.
- It is reasonably clear how the feature would be implemented.
- Corner cases are dissected by example.

## Drawbacks
Why should we _not_ do this?

## Rationale and alternatives
- Why is this design the best in the space of possible designs?
- What other designs have been considered and what is the rationale for not
  choosing them?
- What is the impact of not doing this?

## Unresolved Questions
What related issues do you consider out of scope for this feature that could be
addressed in the future independently of the solution that comes out of this
feature?
