## upterm host

Host a terminal session

### Synopsis

Host a terminal session via a reverse SSH tunnel to the Upterm server.

The session links the host and client IO to a command's IO. Authentication with the
Upterm server uses private keys in this order:
  1. Private key files: ~/.ssh/id_dsa, ~/.ssh/id_ecdsa, ~/.ssh/id_ed25519, ~/.ssh/id_rsa
  2. SSH Agent keys
  3. Auto-generated ephemeral key (if no keys found)

To authorize client connections, use --authorized-keys to specify an authorized_keys file
containing client public keys.

```
upterm host [flags]
```

### Examples

```
  # Host a terminal session running $SHELL, attaching client's IO to the host's:
  upterm host

  # Accept client connections automatically without prompts:
  upterm host --accept

  # Host a terminal session allowing only specified public key(s) to connect:
  upterm host --authorized-keys PATH_TO_AUTHORIZED_KEY_FILE

  # Host a session executing a custom command:
  upterm host -- docker run --rm -ti ubuntu bash

  # Host a 'tmux new -t pair-programming' session, forcing clients to join with 'tmux attach -t pair-programming':
  upterm host --force-command 'tmux attach -t pair-programming' -- tmux new -t pair-programming

  # Use a different Uptermd server, hosting a session via WebSocket:
  upterm host --server wss://YOUR_UPTERMD_SERVER -- YOUR_COMMAND
```

### Options

```
      --accept                   Automatically accept client connections without prompts.
      --authorized-keys string   Specify a authorize_keys file listing authorized public keys for connection.
      --codeberg-user strings    Authorize specified Codeberg users by allowing their public keys to connect.
  -f, --force-command string     Enforce a specified command for clients to join, and link the command's input/output to the client's terminal.
      --github-user strings      Authorize specified GitHub users by allowing their public keys to connect. Configure GitHub CLI environment variables as needed; see https://cli.github.com/manual/gh_help_environment for details.
      --gitlab-user strings      Authorize specified GitLab users by allowing their public keys to connect.
  -h, --help                     help for host
      --hide-client-ip           Hide client IP addresses from output (auto-enabled in CI environments).
      --known-hosts string       Specify a file containing known keys for remote hosts (required). (default "/Users/owen/.ssh/known_hosts")
  -i, --private-key strings      Specify private key files for public key authentication with the upterm server (required). (default [/Users/owen/.ssh/id_ed25519])
  -r, --read-only                Host a read-only session, preventing client interaction.
      --server string            Specify the upterm server address (required). Supported protocols: ssh, ws, wss. (default "ssh://uptermd.upterm.dev:22")
      --skip-host-key-check      Automatically accept unknown server host keys and add them to known_hosts (similar to SSH's StrictHostKeyChecking=accept-new). This bypasses host key verification for new connections.
      --srht-user strings        Authorize specified SourceHut users by allowing their public keys to connect.
```

### Options inherited from parent commands

```
      --debug   enable debug level logging (log file: /home/user/.local/state/upterm/upterm.log).
```

### SEE ALSO

* [upterm](upterm.md)	 - Instant Terminal Sharing

###### Auto generated by spf13/cobra on 21-Nov-2025
