//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckreferenceaction?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKReferenceAction(pub NSUInteger);
impl CKReferenceAction {
    #[doc(alias = "CKReferenceActionNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "CKReferenceActionDeleteSelf")]
    pub const DeleteSelf: Self = Self(1);
}

unsafe impl Encode for CKReferenceAction {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for CKReferenceAction {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckreference?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKReference;
);

unsafe impl Send for CKReference {}

unsafe impl Sync for CKReference {}

extern_conformance!(
    unsafe impl NSCoding for CKReference {}
);

extern_conformance!(
    unsafe impl NSCopying for CKReference {}
);

unsafe impl CopyingHelper for CKReference {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKReference {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKReference {}
);

impl CKReference {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[cfg(feature = "CKRecordID")]
        /// It is acceptable to relate two records that have not yet been uploaded to the server. Those records must be uploaded to the server in the same operation if using an action other than `CKReferenceActionNone`.
        ///
        /// If a record references a record that does not exist on the server and is not in the current save operation it will result in an error if using an action other than `CKReferenceActionNone`.
        #[unsafe(method(initWithRecordID:action:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRecordID_action(
            this: Allocated<Self>,
            record_id: &CKRecordID,
            action: CKReferenceAction,
        ) -> Retained<Self>;

        #[cfg(feature = "CKRecord")]
        #[unsafe(method(initWithRecord:action:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRecord_action(
            this: Allocated<Self>,
            record: &CKRecord,
            action: CKReferenceAction,
        ) -> Retained<Self>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(referenceAction))]
        #[unsafe(method_family = none)]
        pub unsafe fn referenceAction(&self) -> CKReferenceAction;

        #[cfg(feature = "CKRecordID")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(recordID))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordID(&self) -> Retained<CKRecordID>;
    );
}
