/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items.events;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemStateEvent;
import org.openhab.core.items.events.ItemTimeSeriesEvent;

@NonNullByDefault
public abstract class AbstractItemEventSubscriber
implements EventSubscriber {
    private final Set<String> subscribedEventTypes = Set.of(ItemStateEvent.TYPE, ItemCommandEvent.TYPE, ItemTimeSeriesEvent.TYPE);

    @Override
    public Set<String> getSubscribedEventTypes() {
        return this.subscribedEventTypes;
    }

    @Override
    public void receive(Event event) {
        if (event instanceof ItemStateEvent) {
            ItemStateEvent stateEvent = (ItemStateEvent)event;
            this.receiveUpdate(stateEvent);
        } else if (event instanceof ItemCommandEvent) {
            ItemCommandEvent commandEvent = (ItemCommandEvent)event;
            this.receiveCommand(commandEvent);
        } else if (event instanceof ItemTimeSeriesEvent) {
            ItemTimeSeriesEvent timeSeriesEvent = (ItemTimeSeriesEvent)event;
            this.receiveTimeSeries(timeSeriesEvent);
        }
    }

    protected void receiveCommand(ItemCommandEvent commandEvent) {
    }

    protected void receiveUpdate(ItemStateEvent updateEvent) {
    }

    protected void receiveTimeSeries(ItemTimeSeriesEvent timeSeriesEvent) {
    }
}

