"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useControlled;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
/**
 * Handle controlled & uncontrolled component state
 *
 * ```js
 *  const [uncontrolledState, setUncontrolledState] = useControlled(
 *    controlledValue,
 *    () => defaultValue,
 *  );
 * ```
 *
 * @param propValue
 * @param getDefaultPropValue
 */
function useControlled(propValue) {
  var getDefaultPropValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {
    return propValue;
  };
  var isControlled = propValue !== undefined;
  var _useState = (0, _react.useState)(getDefaultPropValue),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    valueState = _useState2[0],
    setValue = _useState2[1];
  var isControlledRef = (0, _react.useRef)(isControlled);
  (0, _react.useEffect)(function () {
    isControlledRef.current = isControlled;
  }, [isControlled]);
  var value = isControlled ? propValue : valueState;
  var setValueIfUncontrolled = (0, _react.useCallback)(function (newValue) {
    if (!isControlledRef.current) {
      setValue(newValue);
    }
  }, []);
  return [value, setValueIfUncontrolled];
}