<span id="news-2015"></span>
# Changelog - 2015

!!! note
    Please see [news](news.md) for the latest changes.


## 19.4.3 / 2015/12/30

- fix: don't check if a file is writable using os.stat with SELINUX ([Issue #1171](https://github.com/benoitc/gunicorn/issues/1171))

## 19.4.2 / 2015/12/29

### Core

- improvement: handle HaltServer in manage_workers ([Issue #1095](https://github.com/benoitc/gunicorn/issues/1095))
- fix: Do not rely on sendfile sending requested count ([Issue #1155](https://github.com/benoitc/gunicorn/issues/1155))
- fix: claridy --no-sendfile default ([Issue #1156](https://github.com/benoitc/gunicorn/issues/1156))
- fix: LoggingCatch sendfile failure from no file descriptor ([Issue #1160](https://github.com/benoitc/gunicorn/issues/1160))

### Logging

- fix: Always send access log to syslog if syslog is on
- fix: check auth before trying to own a file ([Issue #1157](https://github.com/benoitc/gunicorn/issues/1157))


### Documentation

- fix: Fix Slowloris broken link. ([Issue #1142](https://github.com/benoitc/gunicorn/issues/1142))
- Tweak markup in faq.rst

### Testing

- fix: gaiohttp test ([Issue #1164](https://github.com/benoitc/gunicorn/issues/1164))

## 19.4.1 / 2015/11/25

- fix tornado worker ([Issue #1154](https://github.com/benoitc/gunicorn/issues/1154))

## 19.4.0 / 2015/11/20

### Core

- fix: make sure that a user is able to access to the logs after dropping a
  privilege ([Issue #1116](https://github.com/benoitc/gunicorn/issues/1116))
- improvement: inherit the `Exception` class where it needs to be ([Issue #997](https://github.com/benoitc/gunicorn/issues/997))
- fix: make sure headers are always encoded as latin1 RFC 2616 ([Issue #1102](https://github.com/benoitc/gunicorn/issues/1102))
- improvement: reduce arbiter noise ([Issue #1078](https://github.com/benoitc/gunicorn/issues/1078))
- fix: don't close the unix socket when the worker exit ([Issue #1088](https://github.com/benoitc/gunicorn/issues/1088))
- improvement: Make last logged worker count an explicit instance var ([Issue #1078](https://github.com/benoitc/gunicorn/issues/1078))
- improvement: prefix config file with its type ([Issue #836](https://github.com/benoitc/gunicorn/issues/836))
- improvement: pidfile handing ([Issue #1042](https://github.com/benoitc/gunicorn/issues/1042))
- fix: catch OSError as well as ValueError on race condition ([Issue #1052](https://github.com/benoitc/gunicorn/issues/1052))
- improve support of ipv6 by backporting urlparse.urlsplit from Python 2.7 to
  Python 2.6.
- fix: raise InvalidRequestLine when the line contains malicious data
  ([Issue #1023](https://github.com/benoitc/gunicorn/issues/1023))
- fix: fix argument to disable sendfile
- fix: add gthread to the list of supported workers ([Issue #1011](https://github.com/benoitc/gunicorn/issues/1011))
- improvement: retry socket binding up to five times upon EADDRNOTAVAIL
  ([Issue #1004](https://github.com/benoitc/gunicorn/issues/1004))
- **breaking change**: only honor headers that can be encoded in ascii to comply to
  the RFC 7230 (See [Issue #1151](https://github.com/benoitc/gunicorn/issues/1151)).

### Logging

- add new parameters to access log ([Issue #1132](https://github.com/benoitc/gunicorn/issues/1132))
- fix: make sure that files handles are correctly reopened on HUP
  ([Issue #627](https://github.com/benoitc/gunicorn/issues/627))
- include request URL in error message ([Issue #1071](https://github.com/benoitc/gunicorn/issues/1071))
- get username in access logs ([Issue #1069](https://github.com/benoitc/gunicorn/issues/1069))
- fix statsd logging support on Python 3 ([Issue #1010](https://github.com/benoitc/gunicorn/issues/1010))

### Testing

- use last version of mock.
- many fixes in Travis CI support
- miscellaneous improvements in tests

### Thread worker

- fix: Fix self.nr usage in ThreadedWorker so that auto restart works as
  expected ([Issue #1031](https://github.com/benoitc/gunicorn/issues/1031))

### Gevent worker

- fix quit signal handling ([Issue #1128](https://github.com/benoitc/gunicorn/issues/1128))
- add support for Python 3 ([Issue #1066](https://github.com/benoitc/gunicorn/issues/1066))
- fix: make graceful shutdown thread-safe ([Issue #1032](https://github.com/benoitc/gunicorn/issues/1032))

### Tornado worker

- fix ssl options ([Issue #1146](https://github.com/benoitc/gunicorn/issues/1146), [Issue #1135](https://github.com/benoitc/gunicorn/issues/1135))
- don't check timeout when stopping gracefully ([Issue #1106](https://github.com/benoitc/gunicorn/issues/1106))

### AIOHttp worker

- add SSL support ([Issue #1105](https://github.com/benoitc/gunicorn/issues/1105))

### Documentation

- fix link to proc name setting ([Issue #1144](https://github.com/benoitc/gunicorn/issues/1144))
- fix worker class documentation ([Issue #1141](https://github.com/benoitc/gunicorn/issues/1141), [Issue #1104](https://github.com/benoitc/gunicorn/issues/1104))
- clarify graceful timeout documentation ([Issue #1137](https://github.com/benoitc/gunicorn/issues/1137))
- don't duplicate NGINX config files examples ([Issue #1050](https://github.com/benoitc/gunicorn/issues/1050), [Issue #1048](https://github.com/benoitc/gunicorn/issues/1048))
- add `web.py` framework example ([Issue #1117](https://github.com/benoitc/gunicorn/issues/1117))
- update Debian/Ubuntu installations instructions ([Issue #1112](https://github.com/benoitc/gunicorn/issues/1112))
- clarify `pythonpath` setting description ([Issue #1080](https://github.com/benoitc/gunicorn/issues/1080))
- tweak some example for python3
- clarify `sendfile` documentation
- miscellaneous typos in source code comments (thanks!)
- clarify why REMOTE_ADD may not be the user's IP address ([Issue #1037](https://github.com/benoitc/gunicorn/issues/1037))


### Misc

- fix: reloader should survive SyntaxError ([Issue #994](https://github.com/benoitc/gunicorn/issues/994))
- fix: expose the reloader class to the worker.



## 19.3.0 / 2015/03/06

### Core

- fix: [Issue #978](https://github.com/benoitc/gunicorn/issues/978) make sure a listener is inheritable
- add `check_config` class method to workers
- fix: [Issue #983](https://github.com/benoitc/gunicorn/issues/983) fix select timeout in sync worker with multiple
  connections
- allows workers to access to the reloader. close [Issue #984](https://github.com/benoitc/gunicorn/issues/984)
- raise TypeError instead of AssertionError

### Logging

- make Logger.loglevel a class attribute

### Documentation

- fix: [Issue #988](https://github.com/benoitc/gunicorn/issues/988) fix syntax errors in examples/gunicorn_rc


## 19.2.1 / 2015/02/4

### Logging

- expose loglevel in the Logger class

### AsyncIO worker (gaiohttp.md)

- fix [Issue #977](https://github.com/benoitc/gunicorn/issues/977) fix initial crash

### Documentation

- document security mailing-list in the contributing page.

## 19.2 / 2015/01/30

### Core

- optimize the sync workers when listening on a single interface
- add `--sendfile` settings to enable/disable sendfile. fix [Issue #856](https://github.com/benoitc/gunicorn/issues/856) .
- add the selectors module to the code base. [Issue #886](https://github.com/benoitc/gunicorn/issues/886)
- add `--max-requests-jitter` setting to set the maximum jitter to add to the
  max-requests setting.
- fix [Issue #899](https://github.com/benoitc/gunicorn/issues/899) propagate proxy_protocol_info to keep-alive requests
- fix [Issue #863](https://github.com/benoitc/gunicorn/issues/863) worker timeout: dynamic timeout has been removed
- fix: Avoid world writable file

### Logging

- fix [Issue #941](https://github.com/benoitc/gunicorn/issues/941)  set logconfig default to paster more trivially
- add statsd-prefix config setting: set the prefix to use when emitting statsd
  metrics
- [Issue #832](https://github.com/benoitc/gunicorn/issues/832) log to console by default

### Thread Worker

- fix [Issue #908](https://github.com/benoitc/gunicorn/issues/908) make sure the worker can continue to accept requests

### Eventlet Worker

- fix [Issue #867](https://github.com/benoitc/gunicorn/issues/867) Fix eventlet shutdown to actively shut down the workers.

### Documentation

Many improvements and fixes have been done, see the detailed changelog for
more information.
