#       This code was generated by Berp (http://https://github.com/gasparnagy/berp/).
#
#       Changes to this file may cause incorrect behavior and will be lost if
#       the code is regenerated.

defmodule CucumberGherkin.TokenTypes do
  @moduledoc false
  @token_types [
    None,
EOF,Empty,Comment,TagLine,FeatureLine,RuleLine,BackgroundLine,ScenarioLine,ExamplesLine,StepLine,DocStringSeparator,TableRow,Language,Other,  ]
  def get_ordinal(type), do: Enum.find_index @token_types, &( &1 == type )
end

defmodule CucumberGherkin.RuleTypes do
  @moduledoc false
  @rule_types [
    None,
EOF,Empty,Comment,TagLine,FeatureLine,RuleLine,BackgroundLine,ScenarioLine,ExamplesLine,StepLine,DocStringSeparator,TableRow,Language,Other,GherkinDocument,Feature,FeatureHeader,Rule,RuleHeader,Background,ScenarioDefinition,Scenario,ExamplesDefinition,Examples,ExamplesTable,Step,StepArg,DataTable,DocString,Tags,DescriptionHelper,Description,  ]

  def get_ruletype_for_tokentype(type) do
    index = CucumberGherkin.TokenTypes.get_ordinal type
    Enum.at(@rule_types, index)
  end
end



defmodule CucumberGherkin.ParserContext do
  @enforce_keys [:lines, :lexicon]
  defstruct [
    :ast_builder,
    :lines,
    :current_token,
    language: "en",
    lexicon: nil,
    reverse_queue: [],
    errors: [],
    state: 0,
    tokens: [],
    docstring_sep: nil,
    docstring_indent: nil,
    forced_eof?: false
  ]
end

defmodule CucumberGherkin.Parser do
  @moduledoc false
  alias CucumberGherkin.{ParserContext, TokenMatcher, Token, Line, AstBuilder}

  def parse(text, opts) when is_binary(text), do: text |> String.split(~r/\R/) |> parse(opts)

  def parse(lines, opts) when is_list(lines) do
    {:ok, default_lexicon} = CucumberGherkin.Lexicon.load_lang("en")

    lines_structs =
      Enum.with_index(lines, 1)
      |> Enum.map(fn {text, index} -> struct!(Line, content: text, index: index) end)

    struct!(ParserContext, lines: lines_structs, lexicon: default_lexicon, ast_builder: AstBuilder.new(opts))
    |> AstBuilder.start_rule( GherkinDocument )
    |> parse_recursive()
  end

  defp finalize_context(%ParserContext{} = c) do
    ordened_tokens = Enum.reverse(c.reverse_queue)
    %{c | tokens: ordened_tokens, reverse_queue: []} |> AstBuilder.end_rule(GherkinDocument )  end

  defp parse_recursive(%ParserContext{forced_eof?: true} = c), do: finalize_context(c)

  defp parse_recursive(%ParserContext{reverse_queue: [%Token{matched_type: EOF} | _]} = c),
    do: finalize_context(c)

  defp parse_recursive(%ParserContext{lines: [], reverse_queue: [h | _]} = c) do
    l = struct!(Line, content: "", index: h.line.index)
    new_context = %{c | lines: [], forced_eof?: true}
    match_token(l, new_context) |> parse_recursive()
  end

  defp parse_recursive(%ParserContext{lines: [current_line | rem_lines]} = context) do
    new_context = %{context | lines: rem_lines}
    match_token(current_line, new_context) |> parse_recursive()
  end

  defp update_next_state(context, next) when is_integer(next), do: %{context | state: next}


  defp match_token(%Line{} = line, %ParserContext{state: 0} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Language , line, context) -> 
              TokenMatcher.parse(Language , line, context) |>
                          AstBuilder.start_rule(Feature) |>
                AstBuilder.start_rule(FeatureHeader) |>
                AstBuilder.build() |>

          update_next_state(1)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.start_rule(Feature) |>
                AstBuilder.start_rule(FeatureHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(2)
          TokenMatcher.match?(FeatureLine , line, context) -> 
              TokenMatcher.parse(FeatureLine , line, context) |>
                          AstBuilder.start_rule(Feature) |>
                AstBuilder.start_rule(FeatureHeader) |>
                AstBuilder.build() |>

          update_next_state(3)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(0)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(0)
                true -> 
    state_comment = "State: 0 - Start"
    expected_tokens = ["#EOF", "#Language", "#TagLine", "#FeatureLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 1} = context) do
    cond do
TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(2)
          TokenMatcher.match?(FeatureLine , line, context) -> 
              TokenMatcher.parse(FeatureLine , line, context) |>
                          AstBuilder.build() |>

          update_next_state(3)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(1)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(1)
                true -> 
    state_comment = "State: 1 - GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0"
    expected_tokens = ["#TagLine", "#FeatureLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 2} = context) do
    cond do
TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.build() |>

          update_next_state(2)
          TokenMatcher.match?(FeatureLine , line, context) -> 
              TokenMatcher.parse(FeatureLine , line, context) |>
                          AstBuilder.end_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(3)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(2)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(2)
                true -> 
    state_comment = "State: 2 - GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0"
    expected_tokens = ["#TagLine", "#FeatureLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 3} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(3)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(4)
          TokenMatcher.match?(BackgroundLine , line, context) -> 
              TokenMatcher.parse(BackgroundLine , line, context) |>
                          AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(Background) |>
                AstBuilder.build() |>

          update_next_state(5)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(4)
                true -> 
    state_comment = "State: 3 - GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0"
    expected_tokens = ["#EOF", "#Empty", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 4} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(4)
          TokenMatcher.match?(BackgroundLine , line, context) -> 
              TokenMatcher.parse(BackgroundLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(Background) |>
                AstBuilder.build() |>

          update_next_state(5)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(FeatureHeader) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(4)
                true -> 
    state_comment = "State: 4 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>__alt1:0>#Other:0"
    expected_tokens = ["#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 5} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(5)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(6)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(7)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(6)
                true -> 
    state_comment = "State: 5 - GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0"
    expected_tokens = ["#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 6} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(6)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(7)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(6)
                true -> 
    state_comment = "State: 6 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0"
    expected_tokens = ["#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 7} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.start_rule(DataTable) |>
                AstBuilder.build() |>

          update_next_state(8)
          TokenMatcher.match?(DocStringSeparator , line, context) -> 
              TokenMatcher.parse(DocStringSeparator , line, context) |>
                          AstBuilder.start_rule(DocString) |>
                AstBuilder.build() |>

          update_next_state(41)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(7)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(7)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(7)
                true -> 
    state_comment = "State: 7 - GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0"
    expected_tokens = ["#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 8} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.build() |>

          update_next_state(8)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(7)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(8)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(8)
                true -> 
    state_comment = "State: 8 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0"
    expected_tokens = ["#EOF", "#TableRow", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 9} = context) do
    cond do
TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Tags) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(9)
                true -> 
    state_comment = "State: 9 - GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0"
    expected_tokens = ["#TagLine", "#ScenarioLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 10} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(11)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(12)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(14)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(11)
                true -> 
    state_comment = "State: 10 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0"
    expected_tokens = ["#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 11} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(11)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(12)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(14)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(11)
                true -> 
    state_comment = "State: 11 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0"
    expected_tokens = ["#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 12} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.start_rule(DataTable) |>
                AstBuilder.build() |>

          update_next_state(13)
          TokenMatcher.match?(DocStringSeparator , line, context) -> 
              TokenMatcher.parse(DocStringSeparator , line, context) |>
                          AstBuilder.start_rule(DocString) |>
                AstBuilder.build() |>

          update_next_state(39)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(12)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(14)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(12)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(12)
                true -> 
    state_comment = "State: 12 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0"
    expected_tokens = ["#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 13} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.build() |>

          update_next_state(13)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(12)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(14)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(13)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(13)
                true -> 
    state_comment = "State: 13 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0"
    expected_tokens = ["#EOF", "#TableRow", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 14} = context) do
    cond do
TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.build() |>

          update_next_state(14)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Tags) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(14)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(14)
                true -> 
    state_comment = "State: 14 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0"
    expected_tokens = ["#TagLine", "#ExamplesLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 15} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(16)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.start_rule(ExamplesTable) |>
                AstBuilder.build() |>

          update_next_state(17)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(14)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(16)
                true -> 
    state_comment = "State: 15 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0"
    expected_tokens = ["#EOF", "#Empty", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 16} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(16)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(ExamplesTable) |>
                AstBuilder.build() |>

          update_next_state(17)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(14)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(16)
                true -> 
    state_comment = "State: 16 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0"
    expected_tokens = ["#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 17} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.build() |>

          update_next_state(17)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(14)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(17)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(17)
                true -> 
    state_comment = "State: 17 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0"
    expected_tokens = ["#EOF", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 18} = context) do
    cond do
TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(18)
                true -> 
    state_comment = "State: 18 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0"
    expected_tokens = ["#TagLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 19} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(20)
          TokenMatcher.match?(BackgroundLine , line, context) -> 
              TokenMatcher.parse(BackgroundLine , line, context) |>
                          AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.start_rule(Background) |>
                AstBuilder.build() |>

          update_next_state(21)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(20)
                true -> 
    state_comment = "State: 19 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0"
    expected_tokens = ["#EOF", "#Empty", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 20} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(20)
          TokenMatcher.match?(BackgroundLine , line, context) -> 
              TokenMatcher.parse(BackgroundLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.start_rule(Background) |>
                AstBuilder.build() |>

          update_next_state(21)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(RuleHeader) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(20)
                true -> 
    state_comment = "State: 20 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>__alt1:0>#Other:0"
    expected_tokens = ["#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 21} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(21)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(22)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(23)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(22)
                true -> 
    state_comment = "State: 21 - GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0"
    expected_tokens = ["#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 22} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(22)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(23)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(22)
                true -> 
    state_comment = "State: 22 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0"
    expected_tokens = ["#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 23} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.start_rule(DataTable) |>
                AstBuilder.build() |>

          update_next_state(24)
          TokenMatcher.match?(DocStringSeparator , line, context) -> 
              TokenMatcher.parse(DocStringSeparator , line, context) |>
                          AstBuilder.start_rule(DocString) |>
                AstBuilder.build() |>

          update_next_state(37)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(23)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(23)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(23)
                true -> 
    state_comment = "State: 23 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0"
    expected_tokens = ["#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 24} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.build() |>

          update_next_state(24)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(23)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(24)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(24)
                true -> 
    state_comment = "State: 24 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0"
    expected_tokens = ["#EOF", "#TableRow", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 25} = context) do
    cond do
TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Tags) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(25)
                true -> 
    state_comment = "State: 25 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0"
    expected_tokens = ["#TagLine", "#ScenarioLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 26} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(27)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(28)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(30)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(27)
                true -> 
    state_comment = "State: 26 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0"
    expected_tokens = ["#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 27} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(27)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(28)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(30)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(27)
                true -> 
    state_comment = "State: 27 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0"
    expected_tokens = ["#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 28} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.start_rule(DataTable) |>
                AstBuilder.build() |>

          update_next_state(29)
          TokenMatcher.match?(DocStringSeparator , line, context) -> 
              TokenMatcher.parse(DocStringSeparator , line, context) |>
                          AstBuilder.start_rule(DocString) |>
                AstBuilder.build() |>

          update_next_state(35)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(28)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(30)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(28)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(28)
                true -> 
    state_comment = "State: 28 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0"
    expected_tokens = ["#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 29} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.build() |>

          update_next_state(29)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(28)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(30)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(DataTable) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(29)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(29)
                true -> 
    state_comment = "State: 29 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0"
    expected_tokens = ["#EOF", "#TableRow", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 30} = context) do
    cond do
TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.build() |>

          update_next_state(30)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Tags) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(30)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(30)
                true -> 
    state_comment = "State: 30 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0"
    expected_tokens = ["#TagLine", "#ExamplesLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 31} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(32)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.start_rule(ExamplesTable) |>
                AstBuilder.build() |>

          update_next_state(33)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(30)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.start_rule(Description) |>
                AstBuilder.build() |>

          update_next_state(32)
                true -> 
    state_comment = "State: 31 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0"
    expected_tokens = ["#EOF", "#Empty", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 32} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(32)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.start_rule(ExamplesTable) |>
                AstBuilder.build() |>

          update_next_state(33)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(30)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(Description) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(32)
                true -> 
    state_comment = "State: 32 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0"
    expected_tokens = ["#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 33} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(TableRow , line, context) -> 
              TokenMatcher.parse(TableRow , line, context) |>
                          AstBuilder.build() |>

          update_next_state(33)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(30)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(ExamplesTable) |>
                AstBuilder.end_rule(Examples) |>
                AstBuilder.end_rule(ExamplesDefinition) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(33)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(33)
                true -> 
    state_comment = "State: 33 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0"
    expected_tokens = ["#EOF", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 35} = context) do
    cond do
TokenMatcher.match?(DocStringSeparator , line, context) -> 
              TokenMatcher.parse(DocStringSeparator , line, context) |>
                          AstBuilder.build() |>

          update_next_state(36)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(35)
                true -> 
    state_comment = "State: 35 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0"
    expected_tokens = ["#DocStringSeparator", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 36} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(28)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(30)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(31)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(36)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(36)
                true -> 
    state_comment = "State: 36 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0"
    expected_tokens = ["#EOF", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 37} = context) do
    cond do
TokenMatcher.match?(DocStringSeparator , line, context) -> 
              TokenMatcher.parse(DocStringSeparator , line, context) |>
                          AstBuilder.build() |>

          update_next_state(38)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(37)
                true -> 
    state_comment = "State: 37 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0"
    expected_tokens = ["#DocStringSeparator", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 38} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(23)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(25)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(26)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Rule) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(38)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(38)
                true -> 
    state_comment = "State: 38 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0"
    expected_tokens = ["#EOF", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 39} = context) do
    cond do
TokenMatcher.match?(DocStringSeparator , line, context) -> 
              TokenMatcher.parse(DocStringSeparator , line, context) |>
                          AstBuilder.build() |>

          update_next_state(40)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(39)
                true -> 
    state_comment = "State: 39 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0"
    expected_tokens = ["#DocStringSeparator", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 40} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(12)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(1, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(14)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ExamplesLine , line, context) -> 
              TokenMatcher.parse(ExamplesLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(ExamplesDefinition) |>
                AstBuilder.start_rule(Examples) |>
                AstBuilder.build() |>

          update_next_state(15)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Scenario) |>
                AstBuilder.end_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(40)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(40)
                true -> 
    state_comment = "State: 40 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0"
    expected_tokens = ["#EOF", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 41} = context) do
    cond do
TokenMatcher.match?(DocStringSeparator , line, context) -> 
              TokenMatcher.parse(DocStringSeparator , line, context) |>
                          AstBuilder.build() |>

          update_next_state(42)
          TokenMatcher.match?(Other , line, context) -> 
              TokenMatcher.parse(Other , line, context) |>
                          AstBuilder.build() |>

          update_next_state(41)
                true -> 
    state_comment = "State: 41 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0"
    expected_tokens = ["#DocStringSeparator", "#Other"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  defp match_token(%Line{} = line, %ParserContext{state: 42} = context) do
    cond do
TokenMatcher.match?(EOF , line, context) -> 
              TokenMatcher.parse(EOF , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.end_rule(Feature) |>
                AstBuilder.build() |>

          update_next_state(34)
          TokenMatcher.match?(StepLine , line, context) -> 
              TokenMatcher.parse(StepLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.start_rule(Step) |>
                AstBuilder.build() |>

          update_next_state(7)
          
              TokenMatcher.match?(TagLine , line, context) and (lookahead?(0, line, context) |> Map.fetch!(:match?) == true) ->
            
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(9)
          TokenMatcher.match?(TagLine , line, context) -> 
              TokenMatcher.parse(TagLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.start_rule(Tags) |>
                AstBuilder.build() |>

          update_next_state(18)
          TokenMatcher.match?(ScenarioLine , line, context) -> 
              TokenMatcher.parse(ScenarioLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(ScenarioDefinition) |>
                AstBuilder.start_rule(Scenario) |>
                AstBuilder.build() |>

          update_next_state(10)
          TokenMatcher.match?(RuleLine , line, context) -> 
              TokenMatcher.parse(RuleLine , line, context) |>
                          AstBuilder.end_rule(DocString) |>
                AstBuilder.end_rule(Step) |>
                AstBuilder.end_rule(Background) |>
                AstBuilder.start_rule(Rule) |>
                AstBuilder.start_rule(RuleHeader) |>
                AstBuilder.build() |>

          update_next_state(19)
          TokenMatcher.match?(Comment , line, context) -> 
              TokenMatcher.parse(Comment , line, context) |>
                          AstBuilder.build() |>

          update_next_state(42)
          TokenMatcher.match?(Empty , line, context) -> 
              TokenMatcher.parse(Empty , line, context) |>
                          AstBuilder.build() |>

          update_next_state(42)
                true -> 
    state_comment = "State: 42 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0"
    expected_tokens = ["#EOF", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty"]
    handle_error(context, line, expected_tokens, state_comment)
      end
  end

  # Will be called when theres an invalid state or unknown token in the code.
  defp match_token(line, context), do:
    raise "invalid state or unknown token. \n#{IO.inspect(line.content, label: LINE.CONTENT)}\n#{IO.inspect(context, label: CONTEXT)}"




  defp lookahead?(0, _line, %ParserContext{} = ctext) do
    expected_tokens = [ScenarioLine]
    skip_tokens = [Empty,Comment,TagLine]
    look_helper(expected_tokens, skip_tokens, %{context: ctext, match?: false, stop?: false})
  end

  defp lookahead?(1, _line, %ParserContext{} = ctext) do
    expected_tokens = [ExamplesLine]
    skip_tokens = [Empty,Comment,TagLine]
    look_helper(expected_tokens, skip_tokens, %{context: ctext, match?: false, stop?: false})
  end

  defp look_helper(_expected, _skip, %{stop?: true} = acc), do: acc
  defp look_helper(_expected, _skip, %{match?: true} = acc), do: acc
  defp look_helper(_expected, _skip, %{context: %{lines: []}} = acc), do: acc

  defp look_helper(expected, skip, %{context: %{lines: [nextl | rem]} = context} = acc) do
    updated_context = %{context | lines: rem}

    new_acc =
      case try_to_match_token_types(expected, nextl, updated_context) do
        {_new_context, true} ->
          %{acc | context: context, match?: true}

        {_new_context, false} ->
          case try_to_match_token_types(skip, nextl, updated_context) do
            {new_context, true} -> %{acc | context: new_context}
            {new_context, false} -> %{acc | context: new_context, stop?: true}
          end
      end

    look_helper(expected, skip, new_acc)
  end

  defp try_to_match_token_types(types, line, context) do
    case Enum.find(types, &TokenMatcher.match?(&1, line, context)) do
      nil -> {context, false}
      type -> {TokenMatcher.parse(type, line, context), true}
    end
  end


  defp handle_error(context, line, expected_tokens, state_comment) do
    general_opts = [line: line, expected_tokens: expected_tokens, comment: state_comment]

    error = case TokenMatcher.match?(EOF, line, context) do
      true -> struct!(CucumberGherkin.UnexpectedEOFError, general_opts)
      false -> struct!(CucumberGherkin.UnexpectedTokenError, general_opts)
    end
    new_errors = context.errors ++ [error]
    %{context | errors: new_errors}
  end
end
