//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `event!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn event() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3); // DEBUG:event,tp,-,-,-,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3); // DEBUG:event,tp,-,p,-,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3); // DEBUG:event,tp,-,f,-,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false); // DEBUG:event,tp,-,-,-,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false); // DEBUG:event,tp,-,p,-,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3); // DEBUG:event,tp,-,f,-,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3); // DEBUG:event,tp,-,-,-,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3); // DEBUG:event,tp,-,p,-,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3); // DEBUG:event,tp,-,f,-,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3); // DEBUG:event,tp,-,-,-,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3); // DEBUG:event,tp,-,p,-,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3); // DEBUG:event,tp,-,f,-,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb); // DEBUG:event,tp,-,-,-,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb); // DEBUG:event,tp,-,p,-,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3); // DEBUG:event,tp,-,f,-,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp); // DEBUG:event,tp,-,-,-,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp); // DEBUG:event,tp,-,p,-,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3); // DEBUG:event,tp,-,f,-,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field); // DEBUG:event,tp,-,-,-,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field); // DEBUG:event,tp,-,p,-,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field); // DEBUG:event,tp,-,-,-,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field); // DEBUG:event,tp,-,p,-,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb)); // DEBUG:event,tp,-,-,-,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb)); // DEBUG:event,tp,-,p,-,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3); // DEBUG:event,tp,-,f,-,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3); // DEBUG:event,tp,-,pf,-,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), "msg without args"); // DEBUG:event,tp,-,-,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:event,tp,-,p,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp)); // DEBUG:event,tp,-,-,-,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp)); // DEBUG:event,tp,-,p,-,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3); // DEBUG:event,tp,-,f,-,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3); // DEBUG:event,tp,-,pf,-,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), "msg without args"); // DEBUG:event,tp,-,-,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), "msg without args"); // DEBUG:event,tp,-,p,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty); // DEBUG:event,tp,-,-,-,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty); // DEBUG:event,tp,-,p,-,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,f,-,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,pf,-,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,-,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,p,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},-,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},p,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3); // DEBUG:event,tp,-,-,-,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3); // DEBUG:event,tp,-,p,-,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false); // DEBUG:event,tp,-,-,-,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false); // DEBUG:event,tp,-,p,-,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3); // DEBUG:event,tp,-,-,-,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3); // DEBUG:event,tp,-,p,-,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3); // DEBUG:event,tp,-,-,-,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3); // DEBUG:event,tp,-,p,-,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb); // DEBUG:event,tp,-,-,-,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb); // DEBUG:event,tp,-,p,-,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp); // DEBUG:event,tp,-,-,-,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp); // DEBUG:event,tp,-,p,-,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field); // DEBUG:event,tp,-,-,-,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field); // DEBUG:event,tp,-,p,-,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field); // DEBUG:event,tp,-,-,-,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field); // DEBUG:event,tp,-,p,-,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb)); // DEBUG:event,tp,-,-,-,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb)); // DEBUG:event,tp,-,p,-,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp)); // DEBUG:event,tp,-,-,-,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp)); // DEBUG:event,tp,-,p,-,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty); // DEBUG:event,tp,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:event,tp,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3); // DEBUG:event,tp,-,-,-,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3); // DEBUG:event,tp,-,p,-,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false); // DEBUG:event,tp,-,-,-,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false); // DEBUG:event,tp,-,p,-,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3); // DEBUG:event,tp,-,-,-,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3); // DEBUG:event,tp,-,p,-,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3); // DEBUG:event,tp,-,-,-,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3); // DEBUG:event,tp,-,p,-,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb); // DEBUG:event,tp,-,-,-,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb); // DEBUG:event,tp,-,p,-,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp); // DEBUG:event,tp,-,-,-,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp); // DEBUG:event,tp,-,p,-,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field); // DEBUG:event,tp,-,-,-,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field); // DEBUG:event,tp,-,p,-,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field); // DEBUG:event,tp,-,-,-,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field); // DEBUG:event,tp,-,p,-,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb)); // DEBUG:event,tp,-,-,-,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb)); // DEBUG:event,tp,-,p,-,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp)); // DEBUG:event,tp,-,-,-,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp)); // DEBUG:event,tp,-,p,-,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty); // DEBUG:event,tp,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty); // DEBUG:event,tp,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb)); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp)); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,tp,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,tp,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3); // DEBUG:event,tp,-,-,-,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3); // DEBUG:event,tp,-,p,-,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false); // DEBUG:event,tp,-,-,-,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false); // DEBUG:event,tp,-,p,-,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","false"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3); // DEBUG:event,tp,-,-,-,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3); // DEBUG:event,tp,-,p,-,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","?3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3); // DEBUG:event,tp,-,-,-,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3); // DEBUG:event,tp,-,p,-,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3 }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","%3"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb); // DEBUG:event,tp,-,-,-,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb); // DEBUG:event,tp,-,p,-,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp); // DEBUG:event,tp,-,-,-,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp); // DEBUG:event,tp,-,p,-,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field); // DEBUG:event,tp,-,-,-,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field); // DEBUG:event,tp,-,p,-,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field); // DEBUG:event,tp,-,-,-,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field); // DEBUG:event,tp,-,p,-,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb)); // DEBUG:event,tp,-,-,-,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb)); // DEBUG:event,tp,-,p,-,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3); // DEBUG:event,tp,-,f,-,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp)); // DEBUG:event,tp,-,-,-,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp)); // DEBUG:event,tp,-,p,-,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3); // DEBUG:event,tp,-,f,-,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty); // DEBUG:event,tp,-,-,-,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty); // DEBUG:event,tp,-,p,-,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,f,-,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,tp,-,pf,-,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,-,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,tp,-,p,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},-,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,tp,{},p,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var); // DEBUG:event,tp,-,-,-,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var); // DEBUG:event,tp,-,p,-,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3); // DEBUG:event,tp,-,f,-,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3); // DEBUG:event,tp,-,pf,-,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, "msg without args"); // DEBUG:event,tp,-,-,m,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, "msg without args"); // DEBUG:event,tp,-,p,m,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { var }, "msg without args"); // DEBUG:event,tp,{},-,m,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var }, "msg without args"); // DEBUG:event,tp,{},p,m,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { var, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { var }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,-,"var"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field); // DEBUG:event,tp,-,-,-,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field); // DEBUG:event,tp,-,p,-,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3); // DEBUG:event,tp,-,f,-,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,-,"sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp); // DEBUG:event,tp,-,-,-,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp); // DEBUG:event,tp,-,p,-,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3); // DEBUG:event,tp,-,f,-,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3); // DEBUG:event,tp,-,pf,-,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, "msg without args"); // DEBUG:event,tp,-,-,m,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, "msg without args"); // DEBUG:event,tp,-,p,m,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp }, "msg without args"); // DEBUG:event,tp,{},-,m,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp }, "msg without args"); // DEBUG:event,tp,{},p,m,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,-,"%disp"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb); // DEBUG:event,tp,-,-,-,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb); // DEBUG:event,tp,-,p,-,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3); // DEBUG:event,tp,-,f,-,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3); // DEBUG:event,tp,-,pf,-,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, "msg without args"); // DEBUG:event,tp,-,-,m,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, "msg without args"); // DEBUG:event,tp,-,p,m,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb }, "msg without args"); // DEBUG:event,tp,{},-,m,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb }, "msg without args"); // DEBUG:event,tp,{},p,m,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,-,"?deb"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field); // DEBUG:event,tp,-,-,-,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field); // DEBUG:event,tp,-,p,-,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3); // DEBUG:event,tp,-,f,-,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,-,"%sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field); // DEBUG:event,tp,-,-,-,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field); // DEBUG:event,tp,-,p,-,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3); // DEBUG:event,tp,-,f,-,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3); // DEBUG:event,tp,-,pf,-,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, "msg without args"); // DEBUG:event,tp,-,-,m,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, "msg without args"); // DEBUG:event,tp,-,p,m,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,f,m,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,tp,-,pf,m,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field }, "msg without args"); // DEBUG:event,tp,{},-,m,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field }, "msg without args"); // DEBUG:event,tp,{},p,m,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},f,m,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,tp,{},pf,m,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,-,ma,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,p,ma,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,f,ma,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,tp,-,pf,ma,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},-,ma,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},p,ma,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},f,ma,-,"?sub.field"
    tracing::event!(target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,tp,{},pf,ma,-,"?sub.field"
}
