// <copyright file="IRemoteReference.cs" company="Selenium Committers">
// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// </copyright>

namespace OpenQA.Selenium.BiDi.Script;

public interface IRemoteReference;

public interface ISharedReference : IRemoteReference
{
    public string SharedId { get; }

    public Handle? Handle { get; set; }
}

public sealed record SharedReference(string SharedId) : ISharedReference
{
    public Handle? Handle { get; set; }
}

public interface IRemoteObjectReference : IRemoteReference
{
    public Handle Handle { get; }

    public string? SharedId { get; set; }
}
