/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RentalZoneRestrictions {
    /// List of vehicle types (as indices into the provider's vehicle types array) to which these restrictions apply. If empty, the restrictions apply to all vehicle types of the provider. 
    #[serde(rename = "vehicleTypeIdxs")]
    pub vehicle_type_idxs: Vec<i32>,
    /// whether the ride is allowed to start in this zone
    #[serde(rename = "rideStartAllowed")]
    pub ride_start_allowed: bool,
    /// whether the ride is allowed to end in this zone
    #[serde(rename = "rideEndAllowed")]
    pub ride_end_allowed: bool,
    /// whether the ride is allowed to pass through this zone
    #[serde(rename = "rideThroughAllowed")]
    pub ride_through_allowed: bool,
    /// whether vehicles can only be parked at stations in this zone
    #[serde(rename = "stationParking", skip_serializing_if = "Option::is_none")]
    pub station_parking: Option<bool>,
}

impl RentalZoneRestrictions {
    pub fn new(vehicle_type_idxs: Vec<i32>, ride_start_allowed: bool, ride_end_allowed: bool, ride_through_allowed: bool) -> RentalZoneRestrictions {
        RentalZoneRestrictions {
            vehicle_type_idxs,
            ride_start_allowed,
            ride_end_allowed,
            ride_through_allowed,
            station_parking: None,
        }
    }
}

