/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool;

import java.util.HashMap;
import java.util.Map;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.format.FormattedOutput;
import org.rundeck.client.tool.format.NiceFormatter;
import org.rundeck.client.tool.format.OutputFormatter;
import org.rundeck.client.tool.output.ChannelOutput;
import org.rundeck.client.tool.output.SystemOutput;
import picocli.CommandLine;

public class RdBuilder {
    private final Map<Class<? extends Throwable>, ErrorHandler> errorHandlers = new HashMap<Class<? extends Throwable>, ErrorHandler>();
    private final ChannelOutput.Builder channels;
    private CommandOutput commandOutput;
    private OutputFormatter formatter;
    private final ANSIColorOutputBuilder ansiBuilder = new ANSIColorOutputBuilder().sink(new SystemOutput());
    private CommandOutput builtOutput;
    static final Map<String, String> DEFAULT_COLORS = new HashMap<String, String>();

    public RdBuilder() {
        this.channels = ChannelOutput.builder();
    }

    public void formatter(OutputFormatter formatter) {
        this.formatter = formatter;
    }

    public ChannelOutput.Builder channels() {
        return this.channels;
    }

    public CommandOutput defaultOutput() {
        return this.ansiBuilder.build();
    }

    public void printStackTrace(boolean b) {
    }

    public OutputFormatter defaultBaseFormatter() {
        return new NiceFormatter(this.ansiBuilder.build());
    }

    public RdBuilder finalOutput(CommandOutput output) {
        this.builtOutput = output;
        return this;
    }

    public CommandOutput finalOutput() {
        if (null == this.commandOutput) {
            this.commandOutput = this.defaultOutput();
        }
        OutputFormatter baseFormatter = this.defaultBaseFormatter();
        this.channels.fallback(this.commandOutput);
        ChannelOutput channel = this.channels.build();
        if (null == this.builtOutput) {
            this.builtOutput = new FormattedOutput(channel, null != this.formatter ? this.formatter.withBase(baseFormatter) : baseFormatter);
        }
        return this.builtOutput;
    }

    public <T extends Throwable> RdBuilder handles(Class<T> clazz, ErrorHandler handler) {
        this.errorHandlers.put(clazz, handler);
        return this;
    }

    static {
        DEFAULT_COLORS.put("info", "green");
        DEFAULT_COLORS.put("warning", "yellow");
        DEFAULT_COLORS.put("error", "red");
    }

    private static class ANSIColorOutput
    implements CommandOutput,
    OutputFormatter {
        private final SystemOutput sink;
        private final Map<String, String> config;

        public ANSIColorOutput(SystemOutput sink2, Map<String, String> config) {
            this.sink = sink2;
            this.config = config;
        }

        public static String toColors(Object object) {
            return ANSIColorOutput.toColors(object, null);
        }

        @Override
        public String format(Object o) {
            return ANSIColorOutput.toColors(o);
        }

        @Override
        public OutputFormatter withBase(OutputFormatter base) {
            return null;
        }

        public static String toColors(Object object, OutputFormatter base) {
            if (null == object) {
                return null;
            }
            return null != base ? base.format(object) : object.toString();
        }

        @Override
        public void info(Object output) {
            if (output instanceof String && null != this.config.get("info")) {
                this.sink.outPrint(this.toAnsi(output, this.config.get("info")) + "\n");
            } else {
                this.sink.info(ANSIColorOutput.toColors(output));
            }
        }

        private String toAnsi(Object output, String color) {
            boolean hasColor;
            String out = output.toString();
            boolean bl = hasColor = out.contains("@|") || out.contains("|@");
            if (hasColor) {
                return CommandLine.Help.Ansi.AUTO.string(out);
            }
            if (color != null) {
                return CommandLine.Help.Ansi.AUTO.string("@|" + color + " " + out + "|@");
            }
            return out;
        }

        @Override
        public void output(Object object) {
            if (object instanceof String && null != this.config.get("output")) {
                this.sink.outPrint(this.toAnsi(object, this.config.get("output")) + "\n");
            } else {
                this.sink.output(ANSIColorOutput.toColors(object));
            }
        }

        @Override
        public void error(Object error) {
            if (null != this.config.get("error")) {
                this.sink.errorPrint(this.toAnsi(error, this.config.get("error")) + "\n");
            } else {
                this.sink.error(error);
            }
        }

        @Override
        public void warning(Object error) {
            if (null != this.config.get("warning")) {
                this.sink.errorPrint(this.toAnsi(error, this.config.get("warning")) + "\n");
            } else {
                this.sink.error(error);
            }
        }
    }

    private static class ANSIColorOutputBuilder {
        private SystemOutput sink;
        private final Map<String, String> config = new HashMap<String, String>(DEFAULT_COLORS);

        private ANSIColorOutputBuilder() {
        }

        public ANSIColorOutputBuilder info(String color) {
            this.config.put("info", color);
            return this;
        }

        public ANSIColorOutputBuilder warning(String color) {
            this.config.put("warning", color);
            return this;
        }

        public ANSIColorOutputBuilder error(String color) {
            this.config.put("error", color);
            return this;
        }

        public ANSIColorOutputBuilder output(String color) {
            this.config.put("output", color);
            return this;
        }

        public ANSIColorOutputBuilder sink(SystemOutput systemOutput) {
            this.sink = systemOutput;
            return this;
        }

        public ANSIColorOutput build() {
            return new ANSIColorOutput(this.sink, this.config);
        }
    }

    public static interface ErrorHandler {
        public boolean handleError(Throwable var1);
    }
}

