/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.rundeck.client.util.Format;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DateInfo {
    public static final String ISO1 = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final String ISO2 = "yyyy-MM-dd'T'HH:mm:ssXX";
    public static final String ISO = "yyyy-MM-dd'T'HH:mm:ssX";
    public String date;
    public long unixtime;

    @JsonCreator
    public DateInfo(String date) {
        this.date = date;
        try {
            this.unixtime = this.toDate().getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public DateInfo() {
    }

    public Date toDate() throws ParseException {
        return this.toDate(ISO1, ISO2, ISO);
    }

    public String format(String format) {
        try {
            return Format.date(this.toDate(), format);
        }
        catch (ParseException e) {
            return "?";
        }
    }

    public Date toDate(String ... formats) throws ParseException {
        for (int i = 0; i < formats.length - 1; ++i) {
            String format = formats[i];
            try {
                SimpleDateFormat asdf = new SimpleDateFormat(format, Locale.US);
                return asdf.parse(this.date);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        SimpleDateFormat asdf = new SimpleDateFormat(formats[formats.length - 1], Locale.US);
        return asdf.parse(this.date);
    }

    public String toRelative() throws ParseException {
        Date now = new Date();
        return this.toRelative(now);
    }

    public String toRelative(Date time) throws ParseException {
        long diff = time.getTime() - this.toDate().getTime();
        return String.format("%dms ago", diff);
    }

    public static DateInfo withDate(Date input) {
        SimpleDateFormat asdf = new SimpleDateFormat(ISO, Locale.US);
        return new DateInfo(asdf.format(input));
    }

    public String toString() {
        return "{" + this.date + ", unixtime=" + this.unixtime + '}';
    }
}

