/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetCreateRabbitMq targetCreateRabbitMq is a command that creates a new rabbitmq target
type TargetCreateRabbitMq struct {
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	RabbitmqServerPassword *string `json:"rabbitmq-server-password,omitempty"`
	RabbitmqServerUri *string `json:"rabbitmq-server-uri,omitempty"`
	RabbitmqServerUser *string `json:"rabbitmq-server-user,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewTargetCreateRabbitMq instantiates a new TargetCreateRabbitMq object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetCreateRabbitMq(name string, ) *TargetCreateRabbitMq {
	this := TargetCreateRabbitMq{}
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewTargetCreateRabbitMqWithDefaults instantiates a new TargetCreateRabbitMq object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetCreateRabbitMqWithDefaults() *TargetCreateRabbitMq {
	this := TargetCreateRabbitMq{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetCreateRabbitMq) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetCreateRabbitMq) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetCreateRabbitMq) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetCreateRabbitMq) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetCreateRabbitMq) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetCreateRabbitMq) SetName(v string) {
	o.Name = v
}

// GetRabbitmqServerPassword returns the RabbitmqServerPassword field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetRabbitmqServerPassword() string {
	if o == nil || o.RabbitmqServerPassword == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqServerPassword
}

// GetRabbitmqServerPasswordOk returns a tuple with the RabbitmqServerPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetRabbitmqServerPasswordOk() (*string, bool) {
	if o == nil || o.RabbitmqServerPassword == nil {
		return nil, false
	}
	return o.RabbitmqServerPassword, true
}

// HasRabbitmqServerPassword returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasRabbitmqServerPassword() bool {
	if o != nil && o.RabbitmqServerPassword != nil {
		return true
	}

	return false
}

// SetRabbitmqServerPassword gets a reference to the given string and assigns it to the RabbitmqServerPassword field.
func (o *TargetCreateRabbitMq) SetRabbitmqServerPassword(v string) {
	o.RabbitmqServerPassword = &v
}

// GetRabbitmqServerUri returns the RabbitmqServerUri field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetRabbitmqServerUri() string {
	if o == nil || o.RabbitmqServerUri == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqServerUri
}

// GetRabbitmqServerUriOk returns a tuple with the RabbitmqServerUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetRabbitmqServerUriOk() (*string, bool) {
	if o == nil || o.RabbitmqServerUri == nil {
		return nil, false
	}
	return o.RabbitmqServerUri, true
}

// HasRabbitmqServerUri returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasRabbitmqServerUri() bool {
	if o != nil && o.RabbitmqServerUri != nil {
		return true
	}

	return false
}

// SetRabbitmqServerUri gets a reference to the given string and assigns it to the RabbitmqServerUri field.
func (o *TargetCreateRabbitMq) SetRabbitmqServerUri(v string) {
	o.RabbitmqServerUri = &v
}

// GetRabbitmqServerUser returns the RabbitmqServerUser field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetRabbitmqServerUser() string {
	if o == nil || o.RabbitmqServerUser == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqServerUser
}

// GetRabbitmqServerUserOk returns a tuple with the RabbitmqServerUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetRabbitmqServerUserOk() (*string, bool) {
	if o == nil || o.RabbitmqServerUser == nil {
		return nil, false
	}
	return o.RabbitmqServerUser, true
}

// HasRabbitmqServerUser returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasRabbitmqServerUser() bool {
	if o != nil && o.RabbitmqServerUser != nil {
		return true
	}

	return false
}

// SetRabbitmqServerUser gets a reference to the given string and assigns it to the RabbitmqServerUser field.
func (o *TargetCreateRabbitMq) SetRabbitmqServerUser(v string) {
	o.RabbitmqServerUser = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetCreateRabbitMq) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetCreateRabbitMq) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateRabbitMq) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetCreateRabbitMq) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetCreateRabbitMq) SetUidToken(v string) {
	o.UidToken = &v
}

func (o TargetCreateRabbitMq) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.RabbitmqServerPassword != nil {
		toSerialize["rabbitmq-server-password"] = o.RabbitmqServerPassword
	}
	if o.RabbitmqServerUri != nil {
		toSerialize["rabbitmq-server-uri"] = o.RabbitmqServerUri
	}
	if o.RabbitmqServerUser != nil {
		toSerialize["rabbitmq-server-user"] = o.RabbitmqServerUser
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetCreateRabbitMq struct {
	value *TargetCreateRabbitMq
	isSet bool
}

func (v NullableTargetCreateRabbitMq) Get() *TargetCreateRabbitMq {
	return v.value
}

func (v *NullableTargetCreateRabbitMq) Set(val *TargetCreateRabbitMq) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetCreateRabbitMq) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetCreateRabbitMq) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetCreateRabbitMq(val *TargetCreateRabbitMq) *NullableTargetCreateRabbitMq {
	return &NullableTargetCreateRabbitMq{value: val, isSet: true}
}

func (v NullableTargetCreateRabbitMq) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetCreateRabbitMq) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


