/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// SystemAccessCredentialsReplyObj struct for SystemAccessCredentialsReplyObj
type SystemAccessCredentialsReplyObj struct {
	// Temporary credentials for accessing Auth
	AuthCreds *string `json:"auth_creds,omitempty"`
	// Credentials expiration date
	Expiry *int64 `json:"expiry,omitempty"`
	// Temporary credentials for accessing the KFMs instances
	KfmCreds *string `json:"kfm_creds,omitempty"`
	RequiredMfa *string `json:"required_mfa,omitempty"`
	// Credentials tmp token
	Token *string `json:"token,omitempty"`
	// Temporary credentials for accessing the UAM service
	UamCreds *string `json:"uam_creds,omitempty"`
}

// NewSystemAccessCredentialsReplyObj instantiates a new SystemAccessCredentialsReplyObj object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSystemAccessCredentialsReplyObj() *SystemAccessCredentialsReplyObj {
	this := SystemAccessCredentialsReplyObj{}
	return &this
}

// NewSystemAccessCredentialsReplyObjWithDefaults instantiates a new SystemAccessCredentialsReplyObj object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSystemAccessCredentialsReplyObjWithDefaults() *SystemAccessCredentialsReplyObj {
	this := SystemAccessCredentialsReplyObj{}
	return &this
}

// GetAuthCreds returns the AuthCreds field value if set, zero value otherwise.
func (o *SystemAccessCredentialsReplyObj) GetAuthCreds() string {
	if o == nil || o.AuthCreds == nil {
		var ret string
		return ret
	}
	return *o.AuthCreds
}

// GetAuthCredsOk returns a tuple with the AuthCreds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SystemAccessCredentialsReplyObj) GetAuthCredsOk() (*string, bool) {
	if o == nil || o.AuthCreds == nil {
		return nil, false
	}
	return o.AuthCreds, true
}

// HasAuthCreds returns a boolean if a field has been set.
func (o *SystemAccessCredentialsReplyObj) HasAuthCreds() bool {
	if o != nil && o.AuthCreds != nil {
		return true
	}

	return false
}

// SetAuthCreds gets a reference to the given string and assigns it to the AuthCreds field.
func (o *SystemAccessCredentialsReplyObj) SetAuthCreds(v string) {
	o.AuthCreds = &v
}

// GetExpiry returns the Expiry field value if set, zero value otherwise.
func (o *SystemAccessCredentialsReplyObj) GetExpiry() int64 {
	if o == nil || o.Expiry == nil {
		var ret int64
		return ret
	}
	return *o.Expiry
}

// GetExpiryOk returns a tuple with the Expiry field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SystemAccessCredentialsReplyObj) GetExpiryOk() (*int64, bool) {
	if o == nil || o.Expiry == nil {
		return nil, false
	}
	return o.Expiry, true
}

// HasExpiry returns a boolean if a field has been set.
func (o *SystemAccessCredentialsReplyObj) HasExpiry() bool {
	if o != nil && o.Expiry != nil {
		return true
	}

	return false
}

// SetExpiry gets a reference to the given int64 and assigns it to the Expiry field.
func (o *SystemAccessCredentialsReplyObj) SetExpiry(v int64) {
	o.Expiry = &v
}

// GetKfmCreds returns the KfmCreds field value if set, zero value otherwise.
func (o *SystemAccessCredentialsReplyObj) GetKfmCreds() string {
	if o == nil || o.KfmCreds == nil {
		var ret string
		return ret
	}
	return *o.KfmCreds
}

// GetKfmCredsOk returns a tuple with the KfmCreds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SystemAccessCredentialsReplyObj) GetKfmCredsOk() (*string, bool) {
	if o == nil || o.KfmCreds == nil {
		return nil, false
	}
	return o.KfmCreds, true
}

// HasKfmCreds returns a boolean if a field has been set.
func (o *SystemAccessCredentialsReplyObj) HasKfmCreds() bool {
	if o != nil && o.KfmCreds != nil {
		return true
	}

	return false
}

// SetKfmCreds gets a reference to the given string and assigns it to the KfmCreds field.
func (o *SystemAccessCredentialsReplyObj) SetKfmCreds(v string) {
	o.KfmCreds = &v
}

// GetRequiredMfa returns the RequiredMfa field value if set, zero value otherwise.
func (o *SystemAccessCredentialsReplyObj) GetRequiredMfa() string {
	if o == nil || o.RequiredMfa == nil {
		var ret string
		return ret
	}
	return *o.RequiredMfa
}

// GetRequiredMfaOk returns a tuple with the RequiredMfa field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SystemAccessCredentialsReplyObj) GetRequiredMfaOk() (*string, bool) {
	if o == nil || o.RequiredMfa == nil {
		return nil, false
	}
	return o.RequiredMfa, true
}

// HasRequiredMfa returns a boolean if a field has been set.
func (o *SystemAccessCredentialsReplyObj) HasRequiredMfa() bool {
	if o != nil && o.RequiredMfa != nil {
		return true
	}

	return false
}

// SetRequiredMfa gets a reference to the given string and assigns it to the RequiredMfa field.
func (o *SystemAccessCredentialsReplyObj) SetRequiredMfa(v string) {
	o.RequiredMfa = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *SystemAccessCredentialsReplyObj) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SystemAccessCredentialsReplyObj) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *SystemAccessCredentialsReplyObj) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *SystemAccessCredentialsReplyObj) SetToken(v string) {
	o.Token = &v
}

// GetUamCreds returns the UamCreds field value if set, zero value otherwise.
func (o *SystemAccessCredentialsReplyObj) GetUamCreds() string {
	if o == nil || o.UamCreds == nil {
		var ret string
		return ret
	}
	return *o.UamCreds
}

// GetUamCredsOk returns a tuple with the UamCreds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SystemAccessCredentialsReplyObj) GetUamCredsOk() (*string, bool) {
	if o == nil || o.UamCreds == nil {
		return nil, false
	}
	return o.UamCreds, true
}

// HasUamCreds returns a boolean if a field has been set.
func (o *SystemAccessCredentialsReplyObj) HasUamCreds() bool {
	if o != nil && o.UamCreds != nil {
		return true
	}

	return false
}

// SetUamCreds gets a reference to the given string and assigns it to the UamCreds field.
func (o *SystemAccessCredentialsReplyObj) SetUamCreds(v string) {
	o.UamCreds = &v
}

func (o SystemAccessCredentialsReplyObj) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AuthCreds != nil {
		toSerialize["auth_creds"] = o.AuthCreds
	}
	if o.Expiry != nil {
		toSerialize["expiry"] = o.Expiry
	}
	if o.KfmCreds != nil {
		toSerialize["kfm_creds"] = o.KfmCreds
	}
	if o.RequiredMfa != nil {
		toSerialize["required_mfa"] = o.RequiredMfa
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UamCreds != nil {
		toSerialize["uam_creds"] = o.UamCreds
	}
	return json.Marshal(toSerialize)
}

type NullableSystemAccessCredentialsReplyObj struct {
	value *SystemAccessCredentialsReplyObj
	isSet bool
}

func (v NullableSystemAccessCredentialsReplyObj) Get() *SystemAccessCredentialsReplyObj {
	return v.value
}

func (v *NullableSystemAccessCredentialsReplyObj) Set(val *SystemAccessCredentialsReplyObj) {
	v.value = val
	v.isSet = true
}

func (v NullableSystemAccessCredentialsReplyObj) IsSet() bool {
	return v.isSet
}

func (v *NullableSystemAccessCredentialsReplyObj) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSystemAccessCredentialsReplyObj(val *SystemAccessCredentialsReplyObj) *NullableSystemAccessCredentialsReplyObj {
	return &NullableSystemAccessCredentialsReplyObj{value: val, isSet: true}
}

func (v NullableSystemAccessCredentialsReplyObj) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSystemAccessCredentialsReplyObj) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


