/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ListAuthMethodsOutput struct for ListAuthMethodsOutput
type ListAuthMethodsOutput struct {
	AuthMethods *[]AuthMethod `json:"auth_methods,omitempty"`
	NextPage *string `json:"next_page,omitempty"`
}

// NewListAuthMethodsOutput instantiates a new ListAuthMethodsOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListAuthMethodsOutput() *ListAuthMethodsOutput {
	this := ListAuthMethodsOutput{}
	return &this
}

// NewListAuthMethodsOutputWithDefaults instantiates a new ListAuthMethodsOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListAuthMethodsOutputWithDefaults() *ListAuthMethodsOutput {
	this := ListAuthMethodsOutput{}
	return &this
}

// GetAuthMethods returns the AuthMethods field value if set, zero value otherwise.
func (o *ListAuthMethodsOutput) GetAuthMethods() []AuthMethod {
	if o == nil || o.AuthMethods == nil {
		var ret []AuthMethod
		return ret
	}
	return *o.AuthMethods
}

// GetAuthMethodsOk returns a tuple with the AuthMethods field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListAuthMethodsOutput) GetAuthMethodsOk() (*[]AuthMethod, bool) {
	if o == nil || o.AuthMethods == nil {
		return nil, false
	}
	return o.AuthMethods, true
}

// HasAuthMethods returns a boolean if a field has been set.
func (o *ListAuthMethodsOutput) HasAuthMethods() bool {
	if o != nil && o.AuthMethods != nil {
		return true
	}

	return false
}

// SetAuthMethods gets a reference to the given []AuthMethod and assigns it to the AuthMethods field.
func (o *ListAuthMethodsOutput) SetAuthMethods(v []AuthMethod) {
	o.AuthMethods = &v
}

// GetNextPage returns the NextPage field value if set, zero value otherwise.
func (o *ListAuthMethodsOutput) GetNextPage() string {
	if o == nil || o.NextPage == nil {
		var ret string
		return ret
	}
	return *o.NextPage
}

// GetNextPageOk returns a tuple with the NextPage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListAuthMethodsOutput) GetNextPageOk() (*string, bool) {
	if o == nil || o.NextPage == nil {
		return nil, false
	}
	return o.NextPage, true
}

// HasNextPage returns a boolean if a field has been set.
func (o *ListAuthMethodsOutput) HasNextPage() bool {
	if o != nil && o.NextPage != nil {
		return true
	}

	return false
}

// SetNextPage gets a reference to the given string and assigns it to the NextPage field.
func (o *ListAuthMethodsOutput) SetNextPage(v string) {
	o.NextPage = &v
}

func (o ListAuthMethodsOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AuthMethods != nil {
		toSerialize["auth_methods"] = o.AuthMethods
	}
	if o.NextPage != nil {
		toSerialize["next_page"] = o.NextPage
	}
	return json.Marshal(toSerialize)
}

type NullableListAuthMethodsOutput struct {
	value *ListAuthMethodsOutput
	isSet bool
}

func (v NullableListAuthMethodsOutput) Get() *ListAuthMethodsOutput {
	return v.value
}

func (v *NullableListAuthMethodsOutput) Set(val *ListAuthMethodsOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableListAuthMethodsOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableListAuthMethodsOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListAuthMethodsOutput(val *ListAuthMethodsOutput) *NullableListAuthMethodsOutput {
	return &NullableListAuthMethodsOutput{value: val, isSet: true}
}

func (v NullableListAuthMethodsOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListAuthMethodsOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


