/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GetCertificateValue struct for GetCertificateValue
type GetCertificateValue struct {
	// The parent PKI Certificate Issuer's name of the certificate, required when used with display-id and token
	CertIssuerName *string `json:"cert-issuer-name,omitempty"`
	// Certificate display ID
	DisplayId *string `json:"display-id,omitempty"`
	// Retrieve the Secret value without checking the Gateway's cache [true/false]. This flag is only relevant when using the RestAPI
	IgnoreCache *string `json:"ignore-cache,omitempty"`
	// Token for getting the issued certificate
	IssuanceToken *string `json:"issuance-token,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Certificate name
	Name string `json:"name"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Certificate version
	Version *int32 `json:"version,omitempty"`
}

// NewGetCertificateValue instantiates a new GetCertificateValue object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGetCertificateValue(name string, ) *GetCertificateValue {
	this := GetCertificateValue{}
	var ignoreCache string = "false"
	this.IgnoreCache = &ignoreCache
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewGetCertificateValueWithDefaults instantiates a new GetCertificateValue object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGetCertificateValueWithDefaults() *GetCertificateValue {
	this := GetCertificateValue{}
	var ignoreCache string = "false"
	this.IgnoreCache = &ignoreCache
	var json bool = false
	this.Json = &json
	var name string = "dummy_certificate_name"
	this.Name = name
	return &this
}

// GetCertIssuerName returns the CertIssuerName field value if set, zero value otherwise.
func (o *GetCertificateValue) GetCertIssuerName() string {
	if o == nil || o.CertIssuerName == nil {
		var ret string
		return ret
	}
	return *o.CertIssuerName
}

// GetCertIssuerNameOk returns a tuple with the CertIssuerName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetCertIssuerNameOk() (*string, bool) {
	if o == nil || o.CertIssuerName == nil {
		return nil, false
	}
	return o.CertIssuerName, true
}

// HasCertIssuerName returns a boolean if a field has been set.
func (o *GetCertificateValue) HasCertIssuerName() bool {
	if o != nil && o.CertIssuerName != nil {
		return true
	}

	return false
}

// SetCertIssuerName gets a reference to the given string and assigns it to the CertIssuerName field.
func (o *GetCertificateValue) SetCertIssuerName(v string) {
	o.CertIssuerName = &v
}

// GetDisplayId returns the DisplayId field value if set, zero value otherwise.
func (o *GetCertificateValue) GetDisplayId() string {
	if o == nil || o.DisplayId == nil {
		var ret string
		return ret
	}
	return *o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetDisplayIdOk() (*string, bool) {
	if o == nil || o.DisplayId == nil {
		return nil, false
	}
	return o.DisplayId, true
}

// HasDisplayId returns a boolean if a field has been set.
func (o *GetCertificateValue) HasDisplayId() bool {
	if o != nil && o.DisplayId != nil {
		return true
	}

	return false
}

// SetDisplayId gets a reference to the given string and assigns it to the DisplayId field.
func (o *GetCertificateValue) SetDisplayId(v string) {
	o.DisplayId = &v
}

// GetIgnoreCache returns the IgnoreCache field value if set, zero value otherwise.
func (o *GetCertificateValue) GetIgnoreCache() string {
	if o == nil || o.IgnoreCache == nil {
		var ret string
		return ret
	}
	return *o.IgnoreCache
}

// GetIgnoreCacheOk returns a tuple with the IgnoreCache field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetIgnoreCacheOk() (*string, bool) {
	if o == nil || o.IgnoreCache == nil {
		return nil, false
	}
	return o.IgnoreCache, true
}

// HasIgnoreCache returns a boolean if a field has been set.
func (o *GetCertificateValue) HasIgnoreCache() bool {
	if o != nil && o.IgnoreCache != nil {
		return true
	}

	return false
}

// SetIgnoreCache gets a reference to the given string and assigns it to the IgnoreCache field.
func (o *GetCertificateValue) SetIgnoreCache(v string) {
	o.IgnoreCache = &v
}

// GetIssuanceToken returns the IssuanceToken field value if set, zero value otherwise.
func (o *GetCertificateValue) GetIssuanceToken() string {
	if o == nil || o.IssuanceToken == nil {
		var ret string
		return ret
	}
	return *o.IssuanceToken
}

// GetIssuanceTokenOk returns a tuple with the IssuanceToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetIssuanceTokenOk() (*string, bool) {
	if o == nil || o.IssuanceToken == nil {
		return nil, false
	}
	return o.IssuanceToken, true
}

// HasIssuanceToken returns a boolean if a field has been set.
func (o *GetCertificateValue) HasIssuanceToken() bool {
	if o != nil && o.IssuanceToken != nil {
		return true
	}

	return false
}

// SetIssuanceToken gets a reference to the given string and assigns it to the IssuanceToken field.
func (o *GetCertificateValue) SetIssuanceToken(v string) {
	o.IssuanceToken = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GetCertificateValue) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GetCertificateValue) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GetCertificateValue) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *GetCertificateValue) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *GetCertificateValue) SetName(v string) {
	o.Name = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GetCertificateValue) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GetCertificateValue) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GetCertificateValue) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GetCertificateValue) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GetCertificateValue) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GetCertificateValue) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *GetCertificateValue) GetVersion() int32 {
	if o == nil || o.Version == nil {
		var ret int32
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetCertificateValue) GetVersionOk() (*int32, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *GetCertificateValue) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int32 and assigns it to the Version field.
func (o *GetCertificateValue) SetVersion(v int32) {
	o.Version = &v
}

func (o GetCertificateValue) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CertIssuerName != nil {
		toSerialize["cert-issuer-name"] = o.CertIssuerName
	}
	if o.DisplayId != nil {
		toSerialize["display-id"] = o.DisplayId
	}
	if o.IgnoreCache != nil {
		toSerialize["ignore-cache"] = o.IgnoreCache
	}
	if o.IssuanceToken != nil {
		toSerialize["issuance-token"] = o.IssuanceToken
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableGetCertificateValue struct {
	value *GetCertificateValue
	isSet bool
}

func (v NullableGetCertificateValue) Get() *GetCertificateValue {
	return v.value
}

func (v *NullableGetCertificateValue) Set(val *GetCertificateValue) {
	v.value = val
	v.isSet = true
}

func (v NullableGetCertificateValue) IsSet() bool {
	return v.isSet
}

func (v *NullableGetCertificateValue) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGetCertificateValue(val *GetCertificateValue) *NullableGetCertificateValue {
	return &NullableGetCertificateValue{value: val, isSet: true}
}

func (v NullableGetCertificateValue) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGetCertificateValue) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


