/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretTmpCredsUpdate dynamicSecretTmpCredsUpdate is a command that updates dynamic secret temp creds
type DynamicSecretTmpCredsUpdate struct {
	// Host
	Host string `json:"host"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// New TTL in Minutes
	NewTtlMin int64 `json:"new-ttl-min"`
	// Tmp Creds ID
	TmpCredsId string `json:"tmp-creds-id"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewDynamicSecretTmpCredsUpdate instantiates a new DynamicSecretTmpCredsUpdate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretTmpCredsUpdate(host string, name string, newTtlMin int64, tmpCredsId string, ) *DynamicSecretTmpCredsUpdate {
	this := DynamicSecretTmpCredsUpdate{}
	this.Host = host
	var json bool = false
	this.Json = &json
	this.Name = name
	this.NewTtlMin = newTtlMin
	this.TmpCredsId = tmpCredsId
	return &this
}

// NewDynamicSecretTmpCredsUpdateWithDefaults instantiates a new DynamicSecretTmpCredsUpdate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretTmpCredsUpdateWithDefaults() *DynamicSecretTmpCredsUpdate {
	this := DynamicSecretTmpCredsUpdate{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetHost returns the Host field value
func (o *DynamicSecretTmpCredsUpdate) GetHost() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Host
}

// GetHostOk returns a tuple with the Host field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretTmpCredsUpdate) GetHostOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Host, true
}

// SetHost sets field value
func (o *DynamicSecretTmpCredsUpdate) SetHost(v string) {
	o.Host = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretTmpCredsUpdate) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretTmpCredsUpdate) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretTmpCredsUpdate) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretTmpCredsUpdate) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretTmpCredsUpdate) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretTmpCredsUpdate) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretTmpCredsUpdate) SetName(v string) {
	o.Name = v
}

// GetNewTtlMin returns the NewTtlMin field value
func (o *DynamicSecretTmpCredsUpdate) GetNewTtlMin() int64 {
	if o == nil  {
		var ret int64
		return ret
	}

	return o.NewTtlMin
}

// GetNewTtlMinOk returns a tuple with the NewTtlMin field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretTmpCredsUpdate) GetNewTtlMinOk() (*int64, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.NewTtlMin, true
}

// SetNewTtlMin sets field value
func (o *DynamicSecretTmpCredsUpdate) SetNewTtlMin(v int64) {
	o.NewTtlMin = v
}

// GetTmpCredsId returns the TmpCredsId field value
func (o *DynamicSecretTmpCredsUpdate) GetTmpCredsId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.TmpCredsId
}

// GetTmpCredsIdOk returns a tuple with the TmpCredsId field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretTmpCredsUpdate) GetTmpCredsIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.TmpCredsId, true
}

// SetTmpCredsId sets field value
func (o *DynamicSecretTmpCredsUpdate) SetTmpCredsId(v string) {
	o.TmpCredsId = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretTmpCredsUpdate) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretTmpCredsUpdate) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretTmpCredsUpdate) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretTmpCredsUpdate) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretTmpCredsUpdate) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretTmpCredsUpdate) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretTmpCredsUpdate) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretTmpCredsUpdate) SetUidToken(v string) {
	o.UidToken = &v
}

func (o DynamicSecretTmpCredsUpdate) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["host"] = o.Host
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if true {
		toSerialize["new-ttl-min"] = o.NewTtlMin
	}
	if true {
		toSerialize["tmp-creds-id"] = o.TmpCredsId
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretTmpCredsUpdate struct {
	value *DynamicSecretTmpCredsUpdate
	isSet bool
}

func (v NullableDynamicSecretTmpCredsUpdate) Get() *DynamicSecretTmpCredsUpdate {
	return v.value
}

func (v *NullableDynamicSecretTmpCredsUpdate) Set(val *DynamicSecretTmpCredsUpdate) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretTmpCredsUpdate) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretTmpCredsUpdate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretTmpCredsUpdate(val *DynamicSecretTmpCredsUpdate) *NullableDynamicSecretTmpCredsUpdate {
	return &NullableDynamicSecretTmpCredsUpdate{value: val, isSet: true}
}

func (v NullableDynamicSecretTmpCredsUpdate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretTmpCredsUpdate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


