/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AuthMethodRoleAssociation AuthMethodRoleAssociation includes details of an association between an auth method and a role.
type AuthMethodRoleAssociation struct {
	AllowedOps *[]string `json:"allowed_ops,omitempty"`
	AssocId *string `json:"assoc_id,omitempty"`
	AuthMethodSubClaims *map[string][]string `json:"auth_method_sub_claims,omitempty"`
	IsSubClaimsCaseSensitive *bool `json:"is_sub_claims_case_sensitive,omitempty"`
	IsSubclaimsWithOperator *bool `json:"is_subclaims_with_operator,omitempty"`
	RoleName *string `json:"role_name,omitempty"`
	Rules *Rules `json:"rules,omitempty"`
}

// NewAuthMethodRoleAssociation instantiates a new AuthMethodRoleAssociation object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAuthMethodRoleAssociation() *AuthMethodRoleAssociation {
	this := AuthMethodRoleAssociation{}
	return &this
}

// NewAuthMethodRoleAssociationWithDefaults instantiates a new AuthMethodRoleAssociation object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAuthMethodRoleAssociationWithDefaults() *AuthMethodRoleAssociation {
	this := AuthMethodRoleAssociation{}
	return &this
}

// GetAllowedOps returns the AllowedOps field value if set, zero value otherwise.
func (o *AuthMethodRoleAssociation) GetAllowedOps() []string {
	if o == nil || o.AllowedOps == nil {
		var ret []string
		return ret
	}
	return *o.AllowedOps
}

// GetAllowedOpsOk returns a tuple with the AllowedOps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodRoleAssociation) GetAllowedOpsOk() (*[]string, bool) {
	if o == nil || o.AllowedOps == nil {
		return nil, false
	}
	return o.AllowedOps, true
}

// HasAllowedOps returns a boolean if a field has been set.
func (o *AuthMethodRoleAssociation) HasAllowedOps() bool {
	if o != nil && o.AllowedOps != nil {
		return true
	}

	return false
}

// SetAllowedOps gets a reference to the given []string and assigns it to the AllowedOps field.
func (o *AuthMethodRoleAssociation) SetAllowedOps(v []string) {
	o.AllowedOps = &v
}

// GetAssocId returns the AssocId field value if set, zero value otherwise.
func (o *AuthMethodRoleAssociation) GetAssocId() string {
	if o == nil || o.AssocId == nil {
		var ret string
		return ret
	}
	return *o.AssocId
}

// GetAssocIdOk returns a tuple with the AssocId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodRoleAssociation) GetAssocIdOk() (*string, bool) {
	if o == nil || o.AssocId == nil {
		return nil, false
	}
	return o.AssocId, true
}

// HasAssocId returns a boolean if a field has been set.
func (o *AuthMethodRoleAssociation) HasAssocId() bool {
	if o != nil && o.AssocId != nil {
		return true
	}

	return false
}

// SetAssocId gets a reference to the given string and assigns it to the AssocId field.
func (o *AuthMethodRoleAssociation) SetAssocId(v string) {
	o.AssocId = &v
}

// GetAuthMethodSubClaims returns the AuthMethodSubClaims field value if set, zero value otherwise.
func (o *AuthMethodRoleAssociation) GetAuthMethodSubClaims() map[string][]string {
	if o == nil || o.AuthMethodSubClaims == nil {
		var ret map[string][]string
		return ret
	}
	return *o.AuthMethodSubClaims
}

// GetAuthMethodSubClaimsOk returns a tuple with the AuthMethodSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodRoleAssociation) GetAuthMethodSubClaimsOk() (*map[string][]string, bool) {
	if o == nil || o.AuthMethodSubClaims == nil {
		return nil, false
	}
	return o.AuthMethodSubClaims, true
}

// HasAuthMethodSubClaims returns a boolean if a field has been set.
func (o *AuthMethodRoleAssociation) HasAuthMethodSubClaims() bool {
	if o != nil && o.AuthMethodSubClaims != nil {
		return true
	}

	return false
}

// SetAuthMethodSubClaims gets a reference to the given map[string][]string and assigns it to the AuthMethodSubClaims field.
func (o *AuthMethodRoleAssociation) SetAuthMethodSubClaims(v map[string][]string) {
	o.AuthMethodSubClaims = &v
}

// GetIsSubClaimsCaseSensitive returns the IsSubClaimsCaseSensitive field value if set, zero value otherwise.
func (o *AuthMethodRoleAssociation) GetIsSubClaimsCaseSensitive() bool {
	if o == nil || o.IsSubClaimsCaseSensitive == nil {
		var ret bool
		return ret
	}
	return *o.IsSubClaimsCaseSensitive
}

// GetIsSubClaimsCaseSensitiveOk returns a tuple with the IsSubClaimsCaseSensitive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodRoleAssociation) GetIsSubClaimsCaseSensitiveOk() (*bool, bool) {
	if o == nil || o.IsSubClaimsCaseSensitive == nil {
		return nil, false
	}
	return o.IsSubClaimsCaseSensitive, true
}

// HasIsSubClaimsCaseSensitive returns a boolean if a field has been set.
func (o *AuthMethodRoleAssociation) HasIsSubClaimsCaseSensitive() bool {
	if o != nil && o.IsSubClaimsCaseSensitive != nil {
		return true
	}

	return false
}

// SetIsSubClaimsCaseSensitive gets a reference to the given bool and assigns it to the IsSubClaimsCaseSensitive field.
func (o *AuthMethodRoleAssociation) SetIsSubClaimsCaseSensitive(v bool) {
	o.IsSubClaimsCaseSensitive = &v
}

// GetIsSubclaimsWithOperator returns the IsSubclaimsWithOperator field value if set, zero value otherwise.
func (o *AuthMethodRoleAssociation) GetIsSubclaimsWithOperator() bool {
	if o == nil || o.IsSubclaimsWithOperator == nil {
		var ret bool
		return ret
	}
	return *o.IsSubclaimsWithOperator
}

// GetIsSubclaimsWithOperatorOk returns a tuple with the IsSubclaimsWithOperator field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodRoleAssociation) GetIsSubclaimsWithOperatorOk() (*bool, bool) {
	if o == nil || o.IsSubclaimsWithOperator == nil {
		return nil, false
	}
	return o.IsSubclaimsWithOperator, true
}

// HasIsSubclaimsWithOperator returns a boolean if a field has been set.
func (o *AuthMethodRoleAssociation) HasIsSubclaimsWithOperator() bool {
	if o != nil && o.IsSubclaimsWithOperator != nil {
		return true
	}

	return false
}

// SetIsSubclaimsWithOperator gets a reference to the given bool and assigns it to the IsSubclaimsWithOperator field.
func (o *AuthMethodRoleAssociation) SetIsSubclaimsWithOperator(v bool) {
	o.IsSubclaimsWithOperator = &v
}

// GetRoleName returns the RoleName field value if set, zero value otherwise.
func (o *AuthMethodRoleAssociation) GetRoleName() string {
	if o == nil || o.RoleName == nil {
		var ret string
		return ret
	}
	return *o.RoleName
}

// GetRoleNameOk returns a tuple with the RoleName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodRoleAssociation) GetRoleNameOk() (*string, bool) {
	if o == nil || o.RoleName == nil {
		return nil, false
	}
	return o.RoleName, true
}

// HasRoleName returns a boolean if a field has been set.
func (o *AuthMethodRoleAssociation) HasRoleName() bool {
	if o != nil && o.RoleName != nil {
		return true
	}

	return false
}

// SetRoleName gets a reference to the given string and assigns it to the RoleName field.
func (o *AuthMethodRoleAssociation) SetRoleName(v string) {
	o.RoleName = &v
}

// GetRules returns the Rules field value if set, zero value otherwise.
func (o *AuthMethodRoleAssociation) GetRules() Rules {
	if o == nil || o.Rules == nil {
		var ret Rules
		return ret
	}
	return *o.Rules
}

// GetRulesOk returns a tuple with the Rules field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodRoleAssociation) GetRulesOk() (*Rules, bool) {
	if o == nil || o.Rules == nil {
		return nil, false
	}
	return o.Rules, true
}

// HasRules returns a boolean if a field has been set.
func (o *AuthMethodRoleAssociation) HasRules() bool {
	if o != nil && o.Rules != nil {
		return true
	}

	return false
}

// SetRules gets a reference to the given Rules and assigns it to the Rules field.
func (o *AuthMethodRoleAssociation) SetRules(v Rules) {
	o.Rules = &v
}

func (o AuthMethodRoleAssociation) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AllowedOps != nil {
		toSerialize["allowed_ops"] = o.AllowedOps
	}
	if o.AssocId != nil {
		toSerialize["assoc_id"] = o.AssocId
	}
	if o.AuthMethodSubClaims != nil {
		toSerialize["auth_method_sub_claims"] = o.AuthMethodSubClaims
	}
	if o.IsSubClaimsCaseSensitive != nil {
		toSerialize["is_sub_claims_case_sensitive"] = o.IsSubClaimsCaseSensitive
	}
	if o.IsSubclaimsWithOperator != nil {
		toSerialize["is_subclaims_with_operator"] = o.IsSubclaimsWithOperator
	}
	if o.RoleName != nil {
		toSerialize["role_name"] = o.RoleName
	}
	if o.Rules != nil {
		toSerialize["rules"] = o.Rules
	}
	return json.Marshal(toSerialize)
}

type NullableAuthMethodRoleAssociation struct {
	value *AuthMethodRoleAssociation
	isSet bool
}

func (v NullableAuthMethodRoleAssociation) Get() *AuthMethodRoleAssociation {
	return v.value
}

func (v *NullableAuthMethodRoleAssociation) Set(val *AuthMethodRoleAssociation) {
	v.value = val
	v.isSet = true
}

func (v NullableAuthMethodRoleAssociation) IsSet() bool {
	return v.isSet
}

func (v *NullableAuthMethodRoleAssociation) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAuthMethodRoleAssociation(val *AuthMethodRoleAssociation) *NullableAuthMethodRoleAssociation {
	return &NullableAuthMethodRoleAssociation{value: val, isSet: true}
}

func (v NullableAuthMethodRoleAssociation) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAuthMethodRoleAssociation) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


