#!/bin/bash

file=$1
project=$(echo "$2" | cut -d = -f 2)

if [[ "$file" = "" ]] ; then
    echo "Usage:  $0 <file with smatch messages> -p=<project>"
    exit 1
fi

bin_dir=$(dirname $0)
remove=$(echo ${bin_dir}/../smatch_data/${project}.bit_shifters.remove)
tmp=$(mktemp /tmp/smatch.XXXX)

echo "// list of macros used as shifters." \
    > ${project}.bit_shifters
echo '// generated by `gen_bit_shifters.sh`' >> ${project}.bit_shifters
grep "info: bit shifter" $file | cut -s -d "'" -f 2- | sed -e "s/'//g" | sort -u > $tmp

cat $tmp $remove $remove 2> /dev/null | sort | uniq -u >> ${project}.bit_shifters
rm $tmp
echo "Done.  List saved as '${project}.bit_shifters'"

